/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.data.node;

import java.io.Serializable;

public class GWTBitSet
implements Serializable {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private long[] words;
    private int referenceHashCode;

    public GWTBitSet() {
        this.words = new long[0];
    }

    public GWTBitSet(int nbits) {
        this.words = new long[GWTBitSet.wordIndex(nbits - 1) + 1];
    }

    public GWTBitSet(GWTBitSet bitSet) {
        this.referenceHashCode = bitSet.referenceHashCode;
        this.words = new long[bitSet.words.length];
        System.arraycopy(bitSet.words, 0, this.words, 0, bitSet.words.length);
    }

    public void set(int bitIndex) {
        int wordIndex;
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int n = wordIndex = GWTBitSet.wordIndex(bitIndex);
        this.words[n] = this.words[n] | 1L << bitIndex;
    }

    public boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = GWTBitSet.wordIndex(bitIndex);
        return (this.words[wordIndex] & 1L << bitIndex) != 0L;
    }

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    public void and(GWTBitSet set) {
        if (this == set) {
            return;
        }
        for (int i = 0; i < this.words.length; ++i) {
            int n = i;
            this.words[n] = this.words[n] & set.words[i];
        }
    }

    public int getReferenceHashCode() {
        return this.referenceHashCode;
    }

    public void setReferenceHashCode(int referenceHashCode) {
        this.referenceHashCode = referenceHashCode;
    }
}

