/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.data.publication;

import com.google.gwt.user.client.ui.Image;
import java.util.HashMap;
import java.util.Map;
import org.jahia.ajax.gwt.client.data.SerializableBaseModel;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;

public class GWTJahiaPublicationInfo
extends SerializableBaseModel {
    private static final long serialVersionUID = -8549934950900000042L;
    public static final int PUBLISHED = 1;
    public static final int MODIFIED = 3;
    public static final int NOT_PUBLISHED = 4;
    public static final int UNPUBLISHED = 5;
    public static final int MANDATORY_LANGUAGE_UNPUBLISHABLE = 6;
    public static final int LIVE_MODIFIED = 7;
    public static final int LIVE_ONLY = 8;
    public static final int CONFLICT = 9;
    public static final int MANDATORY_LANGUAGE_VALID = 10;
    public static final int DELETED = 11;
    public static final int MARKED_FOR_DELETION = 12;
    public static final Map<Integer, String> statusToLabel = new HashMap<Integer, String>();

    public GWTJahiaPublicationInfo() {
    }

    public GWTJahiaPublicationInfo(String uuid, int status) {
        this.setUuid(uuid);
        this.setStatus(status);
        this.setLocked(false);
        this.setWorkInProgress(false);
        this.setIsAllowedToPublishWithoutWorkflow(false);
        this.setIsNonRootMarkedForDeletion(false);
    }

    public String getTitle() {
        return (String)this.get("title");
    }

    public void setTitle(String title) {
        this.set("title", title);
    }

    public String getNodetype() {
        return (String)this.get("nodetype");
    }

    public void setNodetype(String nodetype) {
        this.set("nodetype", nodetype);
    }

    public String getUuid() {
        return (String)this.get("uuid");
    }

    public void setUuid(String uuid) {
        this.set("uuid", uuid);
    }

    public String getI18nUuid() {
        return (String)this.get("i18nUuid");
    }

    public void setI18NUuid(String uuid) {
        this.set("i18nUuid", uuid);
    }

    public String getDeletedI18nUuid() {
        return (String)this.get("deletedI18nUuid");
    }

    public void setDeletedI18nUuid(String uuids) {
        this.set("deletedI18nUuid", uuids);
    }

    public Integer getStatus() {
        return (Integer)this.get("status");
    }

    public void setStatus(Integer status) {
        this.set("status", status);
    }

    public Boolean isAllowedToPublishWithoutWorkflow() {
        return (Boolean)this.get("isAllowedToPublishWithoutWorkflow");
    }

    public void setIsAllowedToPublishWithoutWorkflow(Boolean canPublish) {
        this.set("isAllowedToPublishWithoutWorkflow", canPublish);
    }

    public Boolean getIsNonRootMarkedForDeletion() {
        return (Boolean)this.get("nonRootMarkedForDeletion");
    }

    public void setIsNonRootMarkedForDeletion(Boolean canPublish) {
        this.set("nonRootMarkedForDeletion", canPublish);
    }

    public Boolean isLocked() {
        return (Boolean)this.get("locked");
    }

    public void setLocked(Boolean locked) {
        this.set("locked", locked);
    }

    public Boolean isWorkInProgress() {
        return (Boolean)this.get("workInProgress");
    }

    public void setWorkInProgress(Boolean workInProgress) {
        this.set("workInProgress", workInProgress);
    }

    public String getMainPath() {
        return (String)this.get("mainPath");
    }

    public void setMainPath(String mainTitle) {
        this.set("mainPath", mainTitle);
    }

    public Integer getMainPathIndex() {
        return (Integer)this.get("mainPathIndex");
    }

    public void setMainPathIndex(Integer mainTitle) {
        this.set("mainPathIndex", mainTitle);
    }

    public String getWorkflowGroup() {
        return (String)this.get("workflowGroup");
    }

    public void setWorkflowGroup(String workflowGroup) {
        this.set("workflowGroup", workflowGroup);
    }

    public String getWorkflowTitle() {
        return (String)this.get("workflowTitle");
    }

    public void setWorkflowTitle(String workflowTitle) {
        this.set("workflowTitle", workflowTitle);
    }

    public String getWorkflowDefinition() {
        return (String)this.get("workflowDefinition");
    }

    public void setWorkflowDefinition(String workflowDefinition) {
        this.set("workflowDefinition", workflowDefinition);
    }

    public String getLanguage() {
        return (String)this.get("language");
    }

    public void setLanguage(String language) {
        this.set("language", language);
    }

    public static Image renderPublicationStatusImage(GWTJahiaPublicationInfo info) {
        return GWTJahiaPublicationInfo.statusLabelToImage(info.isWorkInProgress() != false ? "workinprogress" : statusToLabel.get(info.getStatus()));
    }

    public static Image renderPublicationStatusImage(Integer status) {
        return GWTJahiaPublicationInfo.statusLabelToImage(statusToLabel.get(status));
    }

    private static Image statusLabelToImage(String label) {
        String title = Messages.get("label.publication." + label, label);
        Image image = ToolbarIconProvider.getInstance().getIcon("publication/" + label).createImage();
        image.setTitle(title);
        return image;
    }

    public boolean isPublishable() {
        return this.isLocked() == false && this.getStatus() > 1 && this.getStatus() != 6 && this.getStatus() != 10 && this.isWorkInProgress() == false && this.getIsNonRootMarkedForDeletion() == false;
    }

    public boolean isUnpublishable() {
        return this.isLocked() == false && this.getStatus() != 5 && this.getStatus() != 4 && this.getStatus() != 6;
    }

    public void setMainUUID(String uuid) {
        this.set("mainUUID", uuid);
    }

    public String getMainUUID() {
        return (String)this.get("mainUUID");
    }

    public void setPath(String path) {
        this.set("path", path);
    }

    public String getPath() {
        return (String)this.get("path");
    }

    static {
        statusToLabel.put(1, "published");
        statusToLabel.put(12, "markedfordeletion");
        statusToLabel.put(3, "modified");
        statusToLabel.put(4, "notpublished");
        statusToLabel.put(5, "unpublished");
        statusToLabel.put(6, "mandatorylanguageunpublishable");
        statusToLabel.put(7, "livemodified");
        statusToLabel.put(8, "liveonly");
        statusToLabel.put(9, "conflict");
        statusToLabel.put(10, "mandatorylanguagevalid");
        statusToLabel.put(11, "deleted");
    }
}

