/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.util.acleditor;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.Store;
import com.extjs.gxt.ui.client.store.StoreFilter;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACE;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.widget.usergroup.UserGroupSelect;

public class AclEditor {
    private GWTJahiaNodeACL acl;
    private final String siteKey;
    private Button restoreButton;
    private boolean canBreakInheritance = false;
    private String autoAddRole;
    private transient PrincipalModelData autoAddRoleAdded = null;
    private Button breakinheritanceItem;
    private boolean readOnly = false;
    private List<String> displayedRoles;
    private String addUsersLabel = this.getResource("newUsers.label");
    private String addGroupsLabel = this.getResource("newGroups.label");
    private List<AclEditor> rolesEditors;
    private List<Grid> grids;
    private Boolean breakAllInheritance;
    private Map<String, List<PrincipalModelData>> initialValues;
    private Map<String, ListStore<PrincipalModelData>> stores;
    private StoreFilter<PrincipalModelData> inheritanceBreakFilter;
    private FormPanel formPanel;

    public AclEditor(GWTJahiaNodeACL acl, String siteKey, Set<String> roles, Set<String> roleGroups, List<AclEditor> rolesEditors) {
        this.acl = acl;
        this.siteKey = siteKey;
        if (rolesEditors == null) {
            rolesEditors = new ArrayList<AclEditor>();
        }
        this.rolesEditors = rolesEditors;
        Map<String, List<String>> map = acl.getAvailableRoles();
        if ((roleGroups == null || roleGroups.isEmpty()) && (roles == null || roles.isEmpty())) {
            this.displayedRoles = new ArrayList<String>();
            if (map != null && !map.isEmpty()) {
                for (List list : map.values()) {
                    this.displayedRoles.addAll(list);
                }
            }
        } else {
            this.displayedRoles = new ArrayList<String>();
            if (map != null && !map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    if (roleGroups != null && roleGroups.contains(entry.getKey())) {
                        this.displayedRoles.addAll((Collection)entry.getValue());
                        continue;
                    }
                    if (roles == null || roles.isEmpty()) continue;
                    for (Object s : (List)entry.getValue()) {
                        if (!roles.contains(s)) continue;
                        this.displayedRoles.add((String)s);
                    }
                }
            }
        }
        this.initialValues = new HashMap<String, List<PrincipalModelData>>();
        this.stores = new HashMap<String, ListStore<PrincipalModelData>>();
        for (String string : this.displayedRoles) {
            ArrayList<PrincipalModelData> values = new ArrayList<PrincipalModelData>();
            this.initialValues.put(string, values);
            for (GWTJahiaNodeACE gwtJahiaNodeACE : acl.getAce()) {
                boolean inherited;
                boolean set = gwtJahiaNodeACE.getRoles().containsKey(string);
                boolean bl = inherited = gwtJahiaNodeACE.getInheritedRoles().containsKey(string) && gwtJahiaNodeACE.getInheritedRoles().get(string) != false;
                if (!set && !inherited) continue;
                PrincipalModelData entry = new PrincipalModelData(gwtJahiaNodeACE.getPrincipalKey(), Character.valueOf(gwtJahiaNodeACE.getPrincipalType()), gwtJahiaNodeACE.getPrincipal(), gwtJahiaNodeACE.getPrincipalDisplayName(), !set);
                if (inherited) {
                    entry.setInheritedFrom(gwtJahiaNodeACE.getInheritedFrom());
                } else {
                    entry.setInheritedFrom("");
                }
                if (set && !gwtJahiaNodeACE.getRoles().get(string).booleanValue()) {
                    entry.setRemoved(true);
                }
                values.add(entry);
            }
            ListStore store = new ListStore();
            for (PrincipalModelData value : values) {
                store.add((ModelData)value.getClone());
            }
            this.stores.put(string, (ListStore<PrincipalModelData>)store);
        }
        this.breakinheritanceItem = new Button();
        this.breakinheritanceItem.setEnabled(!this.readOnly && this.canBreakInheritance);
        this.breakinheritanceItem.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                boolean newValue;
                boolean bl = newValue = AclEditor.this.breakAllInheritance == false;
                if (AclEditor.this.autoAddRole != null && AclEditor.this.stores.containsKey(AclEditor.this.autoAddRole)) {
                    if (newValue) {
                        AclEditor.this.autoAddRoleAdded = new PrincipalModelData(JahiaGWTParameters.getCurrentUser(), Character.valueOf('u'), JahiaGWTParameters.getCurrentUser(), JahiaGWTParameters.getCurrentUser(), false);
                        ((ListStore)AclEditor.this.stores.get(AclEditor.this.autoAddRole)).add((ModelData)AclEditor.this.autoAddRoleAdded);
                    } else if (AclEditor.this.autoAddRoleAdded != null) {
                        ((ListStore)AclEditor.this.stores.get(AclEditor.this.autoAddRole)).remove((ModelData)AclEditor.this.autoAddRoleAdded);
                        AclEditor.this.autoAddRoleAdded = null;
                    }
                }
                for (AclEditor roleEditor : AclEditor.this.rolesEditors) {
                    roleEditor.setBreakAllInheritance(newValue);
                    roleEditor.setDirty();
                    for (Grid grid : AclEditor.this.grids) {
                        AclEditor.this.resizeGrid(grid);
                    }
                }
            }
        });
        this.restoreButton = new Button(this.getResource("label.restore"));
        this.restoreButton.addStyleName("button-restore");
        this.restoreButton.setIcon(StandardIconsProvider.STANDARD_ICONS.restore());
        this.restoreButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                for (AclEditor aclEditor : AclEditor.this.rolesEditors) {
                    aclEditor.setBreakAllInheritance(AclEditor.this.acl.isBreakAllInheritance());
                }
                AclEditor.this.setBreakInheritanceLabel();
                for (Map.Entry entry : AclEditor.this.initialValues.entrySet()) {
                    ((ListStore)AclEditor.this.stores.get(entry.getKey())).removeAll();
                    for (PrincipalModelData data : (List)entry.getValue()) {
                        ((ListStore)AclEditor.this.stores.get(entry.getKey())).add((ModelData)data.getClone());
                    }
                }
                for (Grid grid : AclEditor.this.grids) {
                    grid.show();
                    AclEditor.this.resizeGrid(grid);
                }
                AclEditor.this.restoreButton.setEnabled(false);
            }
        });
        this.restoreButton.setEnabled(false);
        this.inheritanceBreakFilter = new StoreFilter<PrincipalModelData>(){

            public boolean select(Store<PrincipalModelData> store, PrincipalModelData parent, PrincipalModelData item, String property) {
                return item.getInherited() == false && item.getRemoved() == false;
            }
        };
        boolean breakAllInheritance = acl.isBreakAllInheritance();
        if (!rolesEditors.isEmpty() && rolesEditors.iterator().next().getBreakAllInheritance() != breakAllInheritance) {
            breakAllInheritance = rolesEditors.iterator().next().getBreakAllInheritance();
            this.setDirty();
        }
        this.setBreakAllInheritance(breakAllInheritance);
        rolesEditors.add(this);
    }

    public Boolean getBreakAllInheritance() {
        return this.breakAllInheritance;
    }

    public void setBreakAllInheritance(Boolean breakAllInheritance) {
        if (this.breakAllInheritance == breakAllInheritance) {
            return;
        }
        this.breakAllInheritance = breakAllInheritance;
        this.setBreakInheritanceLabel();
        if (breakAllInheritance.booleanValue()) {
            for (ListStore<PrincipalModelData> listStore : this.stores.values()) {
                listStore.addFilter(this.inheritanceBreakFilter);
                listStore.applyFilters(null);
            }
        } else {
            for (ListStore<PrincipalModelData> listStore : this.stores.values()) {
                listStore.removeFilter(this.inheritanceBreakFilter);
                ArrayList<PrincipalModelData> l = new ArrayList<PrincipalModelData>();
                boolean duplicate = false;
                for (PrincipalModelData data : listStore.getModels()) {
                    if (!l.contains((Object)data)) {
                        l.add(data);
                        continue;
                    }
                    duplicate = true;
                    PrincipalModelData otherData = (PrincipalModelData)((Object)l.get(l.indexOf((Object)data)));
                    if (data.getInherited().booleanValue()) {
                        l.remove((Object)otherData);
                        l.add(data);
                        continue;
                    }
                    if (data.getInheritedFrom() == null || !data.getRemoved().booleanValue()) continue;
                    data.setRemoved(false);
                    l.remove((Object)otherData);
                    l.add(data);
                }
                if (!duplicate) continue;
                listStore.removeAll();
                listStore.add(l);
            }
        }
    }

    public List<GWTJahiaNodeACE> getEntries() {
        HashMap<String, GWTJahiaNodeACE> r = new HashMap<String, GWTJahiaNodeACE>();
        for (GWTJahiaNodeACE gWTJahiaNodeACE : this.acl.getAce()) {
            GWTJahiaNodeACE value = gWTJahiaNodeACE.cloneObject();
            value.getRoles().keySet().retainAll(this.displayedRoles);
            for (String role : this.displayedRoles) {
                if (!value.getRoles().containsKey(role)) continue;
                value.getRoles().put(role, false);
            }
            value.getInheritedRoles().keySet().retainAll(this.displayedRoles);
            r.put(gWTJahiaNodeACE.getPrincipalType() + gWTJahiaNodeACE.getPrincipal(), value);
        }
        for (Map.Entry entry : this.stores.entrySet()) {
            for (PrincipalModelData data : ((ListStore)entry.getValue()).getModels()) {
                String key = data.getType() + data.getName();
                if (!r.containsKey(key)) {
                    GWTJahiaNodeACE ace = new GWTJahiaNodeACE();
                    ace.setPrincipal(data.getName());
                    ace.setPrincipalType(data.getType().charValue());
                    ace.setPrincipalKey(data.getKey());
                    ace.setPrincipalDisplayName(data.getDisplayName());
                    ace.setRoles(new HashMap<String, Boolean>());
                    ace.setInheritedRoles(new HashMap<String, Boolean>());
                    r.put(key, ace);
                }
                if (data.getInherited().booleanValue() && !data.getRemoved().booleanValue()) continue;
                ((GWTJahiaNodeACE)r.get(key)).getRoles().put((String)entry.getKey(), data.getRemoved() == false);
            }
        }
        return new ArrayList<GWTJahiaNodeACE>(r.values());
    }

    public void setCanBreakInheritance(boolean canBreakInheritance) {
        this.canBreakInheritance = canBreakInheritance;
        this.breakinheritanceItem.setEnabled(!this.readOnly && canBreakInheritance);
    }

    public void setAutoAddRole(String autoAddRole) {
        this.autoAddRole = autoAddRole;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getAddUsersLabel() {
        if (this.addUsersLabel == null) {
            return this.getResource("newUsers.label");
        }
        return this.addUsersLabel;
    }

    public void setAddUsersLabel(String addUsersLabel) {
        this.addUsersLabel = addUsersLabel;
    }

    public String getAddGroupsLabel() {
        if (this.addGroupsLabel == null) {
            return this.getResource("newGroups.label");
        }
        return this.addGroupsLabel;
    }

    public void setAddGroupsLabel(String addGroupsLabel) {
        this.addGroupsLabel = addGroupsLabel;
    }

    public void addNewAclPanel(LayoutContainer c) {
        this.formPanel = new FormPanel();
        this.formPanel.setScrollMode(Style.Scroll.AUTO);
        this.grids = new ArrayList<Grid>();
        for (String displayedRole : this.displayedRoles) {
            FieldSet fs = new FieldSet();
            fs.setHeadingHtml(this.acl.getRolesLabels().get(displayedRole));
            ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
            ColumnConfig principalType = new ColumnConfig("type", 30);
            principalType.setRenderer(new GridCellRenderer(){

                public Object render(ModelData model, String property, ColumnData config, int rowIndex, int colIndex, ListStore store, Grid grid) {
                    Character type = (Character)model.get(property);
                    Image html = type.equals(Character.valueOf('u')) ? StandardIconsProvider.STANDARD_ICONS.user().createImage() : StandardIconsProvider.STANDARD_ICONS.group().createImage();
                    return html;
                }
            });
            configs.add(principalType);
            ColumnConfig displayName = new ColumnConfig("displayName", 100);
            displayName.setRenderer((GridCellRenderer)new GridCellRenderer<PrincipalModelData>(){

                public Object render(PrincipalModelData model, String property, ColumnData config, int rowIndex, int colIndex, ListStore store, Grid grid) {
                    if (model.getRemoved().booleanValue()) {
                        return "<span class=\"markedForDeletion\">" + model.get(property) + "</span>";
                    }
                    return model.get(property);
                }
            });
            configs.add(displayName);
            ColumnConfig removedColumnConfig = new ColumnConfig("removed", 50);
            removedColumnConfig.setRenderer((GridCellRenderer)new GridCellRenderer<PrincipalModelData>(){

                public Object render(final PrincipalModelData model, String property, ColumnData config, int rowIndex, int colIndex, final ListStore store, final Grid grid) {
                    Button button = new Button();
                    button.setBorders(false);
                    button.setEnabled(!AclEditor.this.readOnly);
                    if (!model.getRemoved().booleanValue()) {
                        button.setIcon(StandardIconsProvider.STANDARD_ICONS.delete());
                        button.setToolTip(AclEditor.this.getResource("label.remove"));
                        if (model.getInheritedFrom() != null && !model.getInheritedFrom().equals("") && !AclEditor.this.breakAllInheritance.booleanValue()) {
                            button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                                public void componentSelected(ButtonEvent event) {
                                    model.setRemoved(true);
                                    grid.getView().refresh(false);
                                    AclEditor.this.setDirty();
                                }
                            });
                        } else {
                            button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                                public void componentSelected(ButtonEvent event) {
                                    store.remove((ModelData)model);
                                    AclEditor.this.resizeGrid(grid);
                                    AclEditor.this.setDirty();
                                }
                            });
                        }
                        return button;
                    }
                    button.setIcon(StandardIconsProvider.STANDARD_ICONS.restore());
                    button.setToolTip(AclEditor.this.getResource("label.restore"));
                    button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                        public void componentSelected(ButtonEvent event) {
                            model.setRemoved(false);
                            grid.getView().refresh(false);
                            AclEditor.this.setDirty();
                        }
                    });
                    return button;
                }
            });
            configs.add(removedColumnConfig);
            ColumnConfig inheritedColumnConfig = new ColumnConfig("inheritedFrom", 300);
            inheritedColumnConfig.setRenderer((GridCellRenderer)new GridCellRenderer<PrincipalModelData>(){

                public Object render(PrincipalModelData model, String property, ColumnData config, int rowIndex, int colIndex, ListStore store, Grid grid) {
                    if (!AclEditor.this.breakAllInheritance.booleanValue()) {
                        return model.getInheritedFrom();
                    }
                    return "";
                }
            });
            configs.add(inheritedColumnConfig);
            ListStore<PrincipalModelData> listStore = this.stores.get(displayedRole);
            Grid g = new Grid(listStore, new ColumnModel(configs));
            g.getView().setAdjustForHScroll(false);
            g.setHideHeaders(true);
            g.setAutoExpandMax(1500);
            g.setAutoExpandColumn("displayName");
            this.grids.add(g);
            fs.add((Widget)g);
            final UserGroupAdder userGroupAdder = new UserGroupAdder(listStore, (Grid<PrincipalModelData>)g);
            ToolBar toolBar = new ToolBar();
            Button addUsersToolItem = new Button(this.getAddUsersLabel());
            addUsersToolItem.addStyleName("button-add-users");
            addUsersToolItem.setIcon(StandardIconsProvider.STANDARD_ICONS.user());
            addUsersToolItem.setEnabled(!this.readOnly);
            addUsersToolItem.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent event) {
                    new UserGroupSelect(userGroupAdder, 1, AclEditor.this.siteKey);
                }
            });
            toolBar.add((Component)addUsersToolItem);
            addUsersToolItem = new Button(this.getAddGroupsLabel());
            addUsersToolItem.addStyleName("button-add-groups");
            addUsersToolItem.setIcon(StandardIconsProvider.STANDARD_ICONS.group());
            addUsersToolItem.setEnabled(!this.readOnly);
            addUsersToolItem.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent event) {
                    new UserGroupSelect(userGroupAdder, 2, AclEditor.this.siteKey);
                }
            });
            toolBar.add((Component)addUsersToolItem);
            fs.add((Widget)toolBar);
            this.formPanel.add((Widget)fs);
        }
        ToolBar toolBar = new ToolBar();
        toolBar.add((Component)this.breakinheritanceItem);
        toolBar.add((Component)new FillToolItem());
        toolBar.add((Component)this.restoreButton);
        this.formPanel.setTopComponent((Component)toolBar);
        c.add((Widget)this.formPanel);
        c.layout();
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                for (Grid grid : AclEditor.this.grids) {
                    AclEditor.this.resizeGrid(grid);
                }
            }
        });
    }

    private void setBreakInheritanceLabel() {
        if (this.breakAllInheritance.booleanValue()) {
            this.breakinheritanceItem.setText(this.getResource("org.jahia.engines.rights.ManageRights.restoreAllInheritance.label"));
        } else {
            this.breakinheritanceItem.setText(this.getResource("org.jahia.engines.rights.ManageRights.breakAllInheritance.label"));
        }
    }

    public void setDirty() {
        this.restoreButton.setEnabled(true);
    }

    public List<String> getDisplayedRoles() {
        return this.displayedRoles;
    }

    public GWTJahiaNodeACL getAcl() {
        GWTJahiaNodeACL acl = new GWTJahiaNodeACL(this.getEntries());
        acl.setBreakAllInheritance(this.breakAllInheritance);
        return acl;
    }

    public String getResource(String key) {
        return Messages.get(key);
    }

    private void resizeGrid(Grid grid) {
        int h = 0;
        if (grid.getStore().getModels().size() > 0) {
            grid.show();
        } else {
            grid.hide();
        }
        for (int i = 0; i < grid.getStore().getModels().size(); ++i) {
            h += grid.getView().getRow(i).getOffsetHeight();
        }
        grid.setHeight(h);
    }

    private class UserGroupAdder
    implements org.jahia.ajax.gwt.client.widget.usergroup.UserGroupAdder {
        private final ListStore<PrincipalModelData> store;
        private final Grid<PrincipalModelData> grid;

        public UserGroupAdder(ListStore<PrincipalModelData> store, Grid<PrincipalModelData> grid) {
            this.store = store;
            this.grid = grid;
        }

        @Override
        public void addUsersGroups(List<GWTJahiaNode> users) {
            for (GWTJahiaNode user : users) {
                PrincipalModelData entry = new PrincipalModelData(user.getPath(), Character.valueOf(user.isNodeType("jnt:user") ? (char)'u' : 'g'), user.getEscapedName(), user.getDisplayName(), false);
                if (this.store.contains((ModelData)entry)) continue;
                this.store.add((ModelData)entry);
            }
            AclEditor.this.resizeGrid(this.grid);
            AclEditor.this.setDirty();
        }
    }

    class PrincipalModelData
    extends BaseModelData {
        private PrincipalModelData(Map<String, Object> properties) {
            super(properties);
        }

        public PrincipalModelData(String key, Character type, String name, String displayName, Boolean inherited) {
            this.setKey(key);
            this.setType(type);
            this.setName(name);
            this.setDisplayName(displayName);
            this.setInherited(inherited);
            this.setRemoved(false);
        }

        public PrincipalModelData getClone() {
            return new PrincipalModelData(this.getProperties());
        }

        public String getName() {
            return (String)this.get("name");
        }

        public void setName(String name) {
            this.set("name", name);
        }

        public String getDisplayName() {
            return (String)this.get("displayName");
        }

        public void setDisplayName(String displayName) {
            this.set("displayName", displayName);
        }

        public Character getType() {
            return (Character)this.get("type");
        }

        public void setType(Character type) {
            this.set("type", type);
        }

        public String getKey() {
            return (String)this.get("key");
        }

        public void setKey(String key) {
            this.set("key", key);
        }

        public Boolean getInherited() {
            return (Boolean)this.get("inherited");
        }

        public void setInherited(Boolean inherited) {
            this.set("inherited", inherited);
        }

        public String getInheritedFrom() {
            return (String)this.get("inheritedFrom");
        }

        public void setInheritedFrom(String inheritedFrom) {
            this.set("inheritedFrom", inheritedFrom);
        }

        public Boolean getRemoved() {
            return (Boolean)this.get("removed");
        }

        public void setRemoved(Boolean removed) {
            this.set("removed", removed);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            PrincipalModelData that = (PrincipalModelData)((Object)o);
            if (this.getKey() != null ? !this.getKey().equals(that.getKey()) : that.getKey() != null) {
                return false;
            }
            return !(this.getType() != null ? !this.getType().equals(that.getType()) : that.getType() != null);
        }

        public int hashCode() {
            int result = this.getKey() != null ? this.getKey().hashCode() : 0;
            result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
            return result;
        }
    }
}

