/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.util.content;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.core.client.JsArrayUtils;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.storage.client.Storage;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.content.JCRClientUtils;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.content.ManagerLinker;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.PlaceholderModule;
import org.jahia.ajax.gwt.client.widget.toolbar.action.ClipboardActionItem;

public class CopyPasteEngine {
    private static CopyPasteEngine instance = null;
    private List<PlaceholderModule> placeholders = new ArrayList<PlaceholderModule>();
    private final List<GWTJahiaNode> copiedNodes = new ArrayList<GWTJahiaNode>();
    private final Storage storage;
    private String previousStoredValue;
    private boolean cut;

    public static CopyPasteEngine getInstance() {
        if (instance == null) {
            instance = new CopyPasteEngine();
        }
        return instance;
    }

    protected CopyPasteEngine() {
        this.exportStaticMethod();
        this.storage = Storage.getLocalStorageIfSupported();
        if (this.storage != null) {
            Timer t = new Timer(){

                public void run() {
                    String clipboardString = CopyPasteEngine.this.storage.getItem("jahia-clipboard");
                    if (clipboardString != null && !clipboardString.equals(CopyPasteEngine.this.previousStoredValue)) {
                        ArrayList<GWTJahiaNode> nodes = new ArrayList<GWTJahiaNode>();
                        JSONObject clipboard = JSONParser.parseStrict((String)clipboardString).isObject();
                        JSONArray nodesArray = clipboard.get("nodes").isArray();
                        int size = nodesArray.size();
                        for (int i = 0; i < size; ++i) {
                            nodes.add(CopyPasteEngine.this.getGwtJahiaNode(nodesArray.get(i).isObject()));
                        }
                        String type = clipboard.get("type").isString().stringValue();
                        if (!nodes.equals(CopyPasteEngine.this.copiedNodes) || CopyPasteEngine.this.cut != "cut".equals(type)) {
                            CopyPasteEngine.this.setClipboard(nodes, type);
                        }
                        CopyPasteEngine.this.previousStoredValue = clipboardString;
                    }
                }
            };
            t.schedule(100);
            t.scheduleRepeating(1000);
        }
    }

    private GWTJahiaNode getGwtJahiaNode(JSONObject object) {
        GWTJahiaNode node = new GWTJahiaNode();
        node.setUUID(object.get("uuid").isString().stringValue());
        node.setName(object.get("name").isString().stringValue());
        node.setPath(object.get("path").isString().stringValue());
        node.setDisplayName(object.get("displayName").isString().stringValue());
        node.setNodeTypes(this.getStringList(object.get("nodeTypes")));
        node.setInheritedNodeTypes(this.getStringList(object.get("inheritedNodeTypes")));
        JSONValue referenceNode = object.get("referenceNode");
        if (referenceNode != null && referenceNode.isObject() != null) {
            node.setReference(true);
            node.setReferencedNode(this.getGwtJahiaNode(referenceNode.isObject()));
        }
        return node;
    }

    private List<String> getStringList(JSONValue nodetypes) {
        ArrayList<String> l = new ArrayList<String>();
        JSONArray array = nodetypes.isArray();
        if (array != null) {
            for (int i = 0; i < array.size(); ++i) {
                l.add(array.get(i).isString().stringValue());
            }
        }
        return l;
    }

    public void paste(final GWTJahiaNode m, final Linker linker, List<String> childNodeTypesToSkip, String newName) {
        if (!this.getCopiedNodes().isEmpty()) {
            JahiaContentManagementService.App.getInstance().paste(JCRClientUtils.getPathesList(this.getCopiedNodes()), m.getPath(), newName, this.isCut(), childNodeTypesToSkip, new BaseAsyncCallback(){

                @Override
                public void onApplicationFailure(Throwable throwable) {
                    String message = CopyPasteEngine.this.isCut() ? throwable.getLocalizedMessage() : Messages.get("failure.paste.label") + "\n" + throwable.getLocalizedMessage();
                    Window.alert((String)message);
                    if (linker instanceof ManagerLinker) {
                        ManagerLinker managerLinker = (ManagerLinker)linker;
                        managerLinker.getLeftComponent().unmask();
                        managerLinker.getTopRightComponent().unmask();
                    } else {
                        linker.loaded();
                    }
                }

                public void onSuccess(Object o) {
                    CopyPasteEngine.this.afterPaste(linker, m);
                }
            });
        }
    }

    public void pasteReference(final GWTJahiaNode m, final Linker linker) {
        JahiaContentManagementService.App.getInstance().pasteReferences(JCRClientUtils.getPathesList(this.getCopiedNodes()), m.getPath(), null, new BaseAsyncCallback(){

            @Override
            public void onApplicationFailure(Throwable throwable) {
                String message = CopyPasteEngine.this.isCut() ? throwable.getLocalizedMessage() : Messages.get("failure.paste.label") + "\n" + throwable.getLocalizedMessage();
                Window.alert((String)message);
                if (linker instanceof ManagerLinker) {
                    ManagerLinker managerLinker = (ManagerLinker)linker;
                    managerLinker.getLeftComponent().unmask();
                    managerLinker.getTopRightComponent().unmask();
                } else {
                    linker.loaded();
                }
            }

            public void onSuccess(Object o) {
                CopyPasteEngine.this.afterPaste(linker, m);
            }
        });
    }

    private void afterPaste(Linker linker, GWTJahiaNode target) {
        linker.loaded();
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<String> newPaths = new ArrayList<String>();
        for (GWTJahiaNode node : this.getCopiedNodes()) {
            newPaths.add(target.getPath() + "/" + node.getName());
        }
        data.put("node", this.getCopiedNodes().get(0));
        data.put("nodes", newPaths);
        if (linker instanceof ManagerLinker) {
            ManagerLinker managerLinker = (ManagerLinker)linker;
            managerLinker.getLeftComponent().unmask();
            managerLinker.getTopRightComponent().unmask();
            data.put("refreshAll", true);
            linker.refresh(data);
        } else if (this.isCut() && MainModule.getInstance().getPath().contains(this.getCopiedNodes().get(0).getPath())) {
            MainModule.staticGoTo((String)newPaths.get(0), MainModule.getInstance().getTemplate());
        } else {
            data.put("refreshMain", true);
            linker.refresh(data);
        }
        this.onPastedPath();
    }

    public List<GWTJahiaNode> getCopiedNodes() {
        return this.copiedNodes;
    }

    public native void exportStaticMethod();

    private JsArray<JavaScriptObject> getCopiedNodesAsJs() {
        ArrayList<JavaScriptObject> l = new ArrayList<JavaScriptObject>();
        for (GWTJahiaNode gwtJahiaNode : this.copiedNodes) {
            l.add(this.convertGwtNode(gwtJahiaNode));
        }
        return JsArrayUtils.readOnlyJsArray((JavaScriptObject[])l.toArray(new JavaScriptObject[l.size()]));
    }

    public static JsArrayString toJsArray(List<String> input) {
        JsArrayString jsArrayString = (JsArrayString)JsArrayString.createArray().cast();
        for (String s : input) {
            jsArrayString.push(s);
        }
        return jsArrayString;
    }

    private JavaScriptObject convertGwtNode(GWTJahiaNode gwtJahiaNode) {
        GWTJahiaNode ref = gwtJahiaNode.getReferencedNode();
        return this.convertGwtNode(gwtJahiaNode.getName(), gwtJahiaNode.getPath(), gwtJahiaNode.getUUID(), gwtJahiaNode.getNodeTypes() != null && !gwtJahiaNode.getNodeTypes().isEmpty() ? gwtJahiaNode.getNodeTypes().get(0) : null, gwtJahiaNode.getDisplayName(), CopyPasteEngine.toJsArray(gwtJahiaNode.getNodeTypes()), CopyPasteEngine.toJsArray(gwtJahiaNode.getInheritedNodeTypes()), ref != null ? this.convertGwtNode(ref) : null);
    }

    private native JavaScriptObject convertGwtNode(String var1, String var2, String var3, String var4, String var5, JsArrayString var6, JsArrayString var7, JavaScriptObject var8);

    private native String stringify(JsArray<JavaScriptObject> var1, String var2);

    private native void sendCopyEvent(JsArray<JavaScriptObject> var1, String var2);

    public void setCopiedNodes(List<GWTJahiaNode> copiedPaths) {
        this.setClipboard(copiedPaths, "copy");
    }

    public void setCutNodes(List<GWTJahiaNode> cutPaths) {
        this.setClipboard(cutPaths, "cut");
    }

    public void onPastedPath() {
        this.setClipboard(Collections.<GWTJahiaNode>emptyList(), "copy");
    }

    private void setClipboard(List<GWTJahiaNode> copiedPaths, String type) {
        this.cut = "cut".equals(type);
        this.copiedNodes.clear();
        this.copiedNodes.addAll(copiedPaths);
        ClipboardActionItem.setCopied(copiedPaths);
        this.updatePlaceholders();
        JsArray<JavaScriptObject> copiedNodesAsJs = this.getCopiedNodesAsJs();
        if (this.storage != null) {
            this.storage.setItem("jahia-clipboard", this.stringify(copiedNodesAsJs, type));
        }
        this.sendCopyEvent(copiedNodesAsJs, type);
    }

    public boolean isCut() {
        return this.cut;
    }

    public boolean canCopyTo(GWTJahiaNode dest) {
        if (dest == null) {
            return false;
        }
        if (!this.copiedNodes.isEmpty()) {
            GWTJahiaNode copiedPath = this.copiedNodes.get(0);
            return !(dest.getPath() + "/").startsWith(copiedPath.getPath() + "/") && (!this.isCut() || !copiedPath.getPath().substring(0, copiedPath.getPath().lastIndexOf(47)).equals(dest.getPath()));
        }
        return true;
    }

    public boolean checkNodeType(String nodetypes, boolean checkReferences) {
        List<GWTJahiaNode> sources = this.getCopiedNodes();
        boolean allowed = true;
        if (nodetypes != null && nodetypes.length() > 0) {
            if (!sources.isEmpty()) {
                String[] allowedTypes = nodetypes.split(" |,");
                for (GWTJahiaNode source : sources) {
                    allowed &= this.isNodeAllowed(checkReferences, allowedTypes, source);
                }
            }
        } else {
            allowed = false;
        }
        return allowed;
    }

    private boolean isNodeAllowed(boolean checkReferences, String[] allowedTypes, GWTJahiaNode source) {
        for (String type : allowedTypes) {
            if (!source.isNodeType(type) && (!source.isReference() || source.getReferencedNode() == null || !source.getReferencedNode().isNodeType(type)) && (!checkReferences || !type.equals("jnt:contentReference") || !source.isNodeType("jmix:droppableContent"))) continue;
            return true;
        }
        return false;
    }

    public boolean canPasteAsReference() {
        if (this.isCut()) {
            return false;
        }
        List<GWTJahiaNode> sources = this.getCopiedNodes();
        if (!sources.isEmpty()) {
            for (GWTJahiaNode source : sources) {
                if (!source.isReference()) continue;
                return false;
            }
        }
        return true;
    }

    private void updatePlaceholders() {
        for (PlaceholderModule module : this.placeholders) {
            module.updatePasteButton();
        }
    }

    public void addPlaceholder(PlaceholderModule module) {
        this.placeholders.add(module);
    }
}

