/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.util.content.actions;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.content.CopyPasteEngine;
import org.jahia.ajax.gwt.client.util.content.JCRClientUtils;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.content.FileUploader;
import org.jahia.ajax.gwt.client.widget.content.ManagerLinker;
import org.jahia.ajax.gwt.client.widget.content.portlet.PortletWizardWindow;
import org.jahia.ajax.gwt.client.widget.edit.ContentTypeWindow;

public class ContentActions {
    public static void pasteReference(final Linker linker) {
        GWTJahiaNode m = linker.getSelectionContext().getSingleSelection();
        if (m != null) {
            linker.loading(Messages.get("statusbar.pastingref.label"));
            final CopyPasteEngine copyPasteEngine = CopyPasteEngine.getInstance();
            JahiaContentManagementService.App.getInstance().pasteReferences(JCRClientUtils.getPathesList(copyPasteEngine.getCopiedNodes()), m.getPath(), null, new BaseAsyncCallback<Object>(){

                @Override
                public void onApplicationFailure(Throwable throwable) {
                    com.google.gwt.user.client.Window.alert((String)(Messages.get("failure.pasteref.label") + "\n" + throwable.getLocalizedMessage()));
                    linker.loaded();
                }

                public void onSuccess(Object o) {
                    boolean refresh = false;
                    for (GWTJahiaNode n : copyPasteEngine.getCopiedNodes()) {
                        if (n.isFile().booleanValue()) continue;
                        refresh = true;
                        break;
                    }
                    copyPasteEngine.onPastedPath();
                    linker.loaded();
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    if (refresh) {
                        data.put("refreshAll", true);
                    } else {
                        data.put("refreshMain", true);
                    }
                    linker.refresh(data);
                }
            });
        }
    }

    public static void move(final Linker linker, final List<GWTJahiaNode> sources, GWTJahiaNode target) {
        JahiaContentManagementService.App.getInstance().paste(JCRClientUtils.getPathesList(sources), target.getPath(), null, true, null, new BaseAsyncCallback<Object>(){

            @Override
            public void onApplicationFailure(Throwable throwable) {
                com.google.gwt.user.client.Window.alert((String)("Paste failed :\n" + throwable.getLocalizedMessage()));
                linker.loaded();
            }

            public void onSuccess(Object o) {
                boolean refresh = false;
                for (GWTJahiaNode n : sources) {
                    if (n.isFile().booleanValue()) continue;
                    refresh = true;
                    break;
                }
                linker.loaded();
                HashMap<String, Object> data = new HashMap<String, Object>();
                if (refresh) {
                    data.put("refreshAll", true);
                } else {
                    data.put("refreshMain", true);
                }
                linker.refresh(data);
            }
        });
    }

    public static void download(Linker linker) {
        GWTJahiaNode selection = linker.getSelectionContext().getSingleSelection();
        if (selection != null) {
            ContentActions.download(linker, selection, selection.getUrl());
        }
    }

    public static void download(Linker linker, GWTJahiaNode selection, String url) {
        if (selection != null && selection.isFile().booleanValue()) {
            linker.loading(Messages.get("statusbar.downloading.label"));
            if (url != null) {
                HTML link = new HTML(Messages.get("downloadMessage.label") + "<br /><br /><a href=\"" + url + "\" target=\"_new\">" + SafeHtmlUtils.htmlEscape((String)selection.getName()) + "</a>");
                Window dl = new Window();
                dl.addStyleName("download-file");
                dl.setModal(true);
                dl.setHeadingHtml(Messages.get("label.download"));
                dl.setLayout((Layout)new FlowLayout());
                dl.setScrollMode(Style.Scroll.AUTO);
                dl.add((Widget)link);
                dl.setHeight(120);
                dl.show();
            } else {
                com.google.gwt.user.client.Window.alert((String)Messages.get("failure.download.label"));
            }
            linker.loaded();
        }
    }

    public static void createFolder(final Linker linker) {
        GWTJahiaNode parent = linker.getSelectionContext().getSingleSelection();
        if (parent != null) {
            String newFolder = com.google.gwt.user.client.Window.prompt((String)Messages.get("newDirName.label"), (String)"untitled");
            if (newFolder != null && FileUploader.filenameHasInvalidCharacters(newFolder)) {
                MessageBox.alert((String)Messages.get("label.error"), (String)Messages.getWithArgs("failure.upload.invalid.filename", "", new String[]{newFolder}), null);
            } else if (newFolder != null && newFolder.length() > 0) {
                linker.loading(Messages.get("statusbar.newfoldering.label"));
                JahiaContentManagementService.App.getInstance().createFolder(parent.getPath(), newFolder, (AsyncCallback<GWTJahiaNode>)new BaseAsyncCallback<GWTJahiaNode>(){

                    @Override
                    public void onApplicationFailure(Throwable throwable) {
                        com.google.gwt.user.client.Window.alert((String)(Messages.get("failure.newDir.label") + "\n" + throwable.getLocalizedMessage()));
                        linker.loaded();
                    }

                    public void onSuccess(GWTJahiaNode node) {
                        linker.setSelectPathAfterDataUpdate(Arrays.asList(node.getPath()));
                        linker.loaded();
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("node", node);
                        if (linker instanceof ManagerLinker) {
                            data.put("refreshMain", "true");
                        }
                        linker.refresh(data);
                    }
                });
            }
        }
    }

    public static void createNode(String nodeName, final Linker linker, String windowHeader, final String nodeType, List<String> mixins, List<GWTJahiaNodeProperty> nodeProperties, boolean useMainNode) {
        GWTJahiaNode parent = useMainNode ? linker.getSelectionContext().getMainNode() : linker.getSelectionContext().getSingleSelection();
        if (parent != null) {
            String name;
            boolean isNodeNameProvided = nodeName != null && nodeName.length() > 0;
            String string = name = isNodeNameProvided ? nodeName : com.google.gwt.user.client.Window.prompt((String)windowHeader, (String)"untitled");
            if (name != null && name.length() > 0) {
                linker.loading(Messages.get("statusbar.newfoldering.label"));
                JahiaContentManagementService.App.getInstance().createNode(parent.getPath(), name, nodeType, mixins, null, nodeProperties, null, null, null, !isNodeNameProvided, (AsyncCallback<GWTJahiaNode>)new BaseAsyncCallback<GWTJahiaNode>(){

                    public void onSuccess(GWTJahiaNode node) {
                        linker.setSelectPathAfterDataUpdate(Arrays.asList(node.getPath()));
                        linker.loaded();
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("node", node);
                        if (linker instanceof ManagerLinker) {
                            data.put("refreshMain", "true");
                        }
                        linker.refresh(data);
                    }

                    @Override
                    public void onApplicationFailure(Throwable throwable) {
                        Log.error((String)("Unable to create [" + nodeType + "]"), (Throwable)throwable);
                        linker.loaded();
                    }
                });
            }
        }
    }

    public static void showPortletWizard(Linker linker) {
        GWTJahiaNode parent = linker.getSelectionContext().getSingleSelection();
        if (parent != null) {
            PortletWizardWindow window = new PortletWizardWindow(linker, parent);
            window.show();
        }
    }

    public static void showContentWizard(Linker linker, String nodeTypes, boolean includeSubTypes) {
        ContentActions.showContentWizard(linker, nodeTypes, linker.getSelectionContext().getSingleSelection(), includeSubTypes);
    }

    public static void showContentWizard(Linker linker, String nodeTypes, GWTJahiaNode parent, boolean includeSubTypes) {
        ContentActions.showContentWizard(linker, nodeTypes, parent, null, includeSubTypes);
    }

    public static void showContentWizard(Linker linker, String nodeTypes, GWTJahiaNode parent, String name, boolean includeSubTypes) {
        ContentActions.showContentWizard(linker, nodeTypes, parent, name, includeSubTypes, null, false);
    }

    public static void showContentWizard(Linker linker, String nodeTypes, GWTJahiaNode parent, boolean includeSubTypes, boolean skipRefreshOnSave) {
        ContentActions.showContentWizard(linker, nodeTypes, parent, null, includeSubTypes, null, skipRefreshOnSave);
    }

    public static void showContentWizard(Linker linker, String nodeTypes, GWTJahiaNode parent, String name, boolean includeSubTypes, Set<String> displayedNodeTypes, boolean skipRefreshOnSave) {
        ContentActions.showContentWizard(linker, nodeTypes, parent, name, includeSubTypes, displayedNodeTypes, skipRefreshOnSave, false);
    }

    public static void showContentWizard(Linker linker, String nodeTypes, GWTJahiaNode parent, String name, boolean includeSubTypes, Set<String> displayedNodeTypes, boolean skipRefreshOnSave, boolean systemNameReadOnly) {
        if (parent != null) {
            ContentTypeWindow.createContent(linker, name, nodeTypes != null ? Arrays.asList(nodeTypes.split(" ")) : null, new HashMap<String, GWTJahiaNodeProperty>(), parent, includeSubTypes, false, displayedNodeTypes, skipRefreshOnSave, systemNameReadOnly);
        }
    }

    public static void lock(boolean lock, final Linker linker) {
        List<GWTJahiaNode> selectedItems = linker.getSelectionContext().getMultipleSelection();
        if (selectedItems != null && selectedItems.size() > 0) {
            ArrayList<String> selectedPaths = new ArrayList<String>(selectedItems.size());
            for (GWTJahiaNode node : selectedItems) {
                if ((!lock || !node.canLock().booleanValue()) && (lock || !node.canUnlock().booleanValue())) continue;
                selectedPaths.add(node.getPath());
            }
            boolean continueOperation = true;
            if (continueOperation && !selectedPaths.isEmpty()) {
                linker.loading(lock ? Messages.get("statusbar.locking.label") : Messages.get("statusbar.unlocking.label"));
                JahiaContentManagementService.App.getInstance().setLock(selectedPaths, lock, new BaseAsyncCallback<Object>(){

                    @Override
                    public void onApplicationFailure(Throwable throwable) {
                        MessageBox.alert((String)Messages.get("label.error", "Error"), (String)throwable.getLocalizedMessage(), null);
                        linker.loaded();
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("refreshMain", true);
                        linker.refresh(data);
                    }

                    public void onSuccess(Object o) {
                        linker.loaded();
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("refreshMain", true);
                        linker.refresh(data);
                    }
                });
            }
        }
    }
}

