/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.job.GWTJahiaJobDetail;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.form.FileUploadField;

public class ContentImport
extends Window {
    private Linker m_linker;
    private final boolean replaceContent;

    public ContentImport(Linker linker, GWTJahiaNode n) {
        this(linker, n, false);
    }

    public ContentImport(Linker linker, final GWTJahiaNode n, boolean replaceContent) {
        this.addStyleName("content-import");
        this.m_linker = linker;
        this.replaceContent = replaceContent;
        this.setHeadingHtml(Messages.get("label.import"));
        this.setSize(500, 150);
        this.setResizable(false);
        this.setModal(true);
        this.setId("JahiaGxtContentImport");
        ButtonBar buttons = new ButtonBar();
        FormPanel form = new FormPanel();
        form.setFrame(false);
        form.setHeaderVisible(false);
        form.setBorders(false);
        form.setLabelWidth(200);
        final FileUploadField field = new FileUploadField("import");
        field.setFieldLabel(Messages.get("label.import"));
        form.add((Widget)field);
        Button submit = new Button(Messages.get("label.ok"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                ContentImport.this.mask();
                ContentImport.this.doImport(n.getPath(), field.getValue());
            }
        });
        submit.addStyleName("button-submit");
        Button cancel = new Button(Messages.get("label.cancel"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                ContentImport.this.hide();
            }
        });
        cancel.addStyleName("button-cancel");
        buttons.add((Component)submit);
        buttons.add((Component)cancel);
        this.setButtonAlign(Style.HorizontalAlignment.CENTER);
        this.setBottomComponent((Component)buttons);
        this.add((Component)form);
    }

    public void doImport(String path, Object value) {
        Log.debug((String)(path + " " + value));
        JahiaContentManagementService.App.getInstance().importContent(path, value.toString(), this.replaceContent, (AsyncCallback<List<GWTJahiaJobDetail>>)new BaseAsyncCallback<List<GWTJahiaJobDetail>>(){

            @Override
            public void onApplicationFailure(Throwable caught) {
                com.google.gwt.user.client.Window.alert((String)(Messages.get("label.error") + "\n" + caught.getLocalizedMessage()));
                Log.error((String)Messages.get("label.error"), (Throwable)caught);
                ContentImport.this.hide();
            }

            public void onSuccess(List<GWTJahiaJobDetail> result) {
                ContentImport.this.removeAll();
                ContentImport.this.unmask();
                ContentImport.this.add((Component)new Label(Messages.get("label.import.wait", "Your import will be processed by the system as a background job.")));
                if (result.size() > 0) {
                    ContentImport.this.add((Component)new Label(Messages.getWithArgs("label.import.waitingprocess", "There are {0} jobs to finish before this import will be processed.", new Object[]{Integer.toString(result.size())})));
                }
                ButtonBar buttons = (ButtonBar)ContentImport.this.getBottomComponent();
                Button close = new Button(Messages.get("label.close"), (SelectionListener)new SelectionListener<ButtonEvent>(){

                    public void componentSelected(ButtonEvent event) {
                        ContentImport.this.hide();
                    }
                });
                close.addStyleName("button-close");
                buttons.removeAll();
                buttons.add((Component)close);
                ContentImport.this.layout();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("refreshAll", true);
                ContentImport.this.m_linker.refresh(data);
            }
        });
    }
}

