/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.google.gwt.storage.client.Storage;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.HashMap;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTManagerConfiguration;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.content.ContentDetails;
import org.jahia.ajax.gwt.client.widget.content.ContentRepositoryTabs;
import org.jahia.ajax.gwt.client.widget.content.ContentStatusBar;
import org.jahia.ajax.gwt.client.widget.content.ContentToolbar;
import org.jahia.ajax.gwt.client.widget.content.ContentViews;
import org.jahia.ajax.gwt.client.widget.toolbar.ActionContextMenu;
import org.jahia.ajax.gwt.client.widget.tripanel.LinkableComponent;
import org.jahia.ajax.gwt.client.widget.tripanel.TriPanelBrowserLayout;

public class ContentManager
extends TriPanelBrowserLayout {
    public ContentManager(List<String> filters, List<String> mimeTypes, final List<String> selectedPaths, final GWTManagerConfiguration config, int southSize) {
        super(config);
        JahiaGWTParameters.setSiteNode(config.getSiteNode());
        this.setWidth("100%");
        this.setHeight("500px");
        this.setCenterData(new BorderLayoutData(Style.LayoutRegion.SOUTH, (float)southSize));
        if (mimeTypes != null && mimeTypes.size() > 0) {
            config.getMimeTypes().addAll(mimeTypes);
        }
        if (filters != null && filters.size() > 0) {
            config.getFilters().addAll(filters);
        }
        ContentRepositoryTabs leftTree = null;
        Component leftTreeComponent = null;
        ContentDetails bottomTabs = null;
        Component bottomTabsComponent = null;
        if (selectedPaths.isEmpty()) {
            String lastpath;
            Storage storage = Storage.getLocalStorageIfSupported();
            String string = lastpath = storage != null ? storage.getItem("lastSavedPath_" + this.getLinker().getConfig().getName() + "_" + JahiaGWTParameters.getSiteKey()) : null;
            if (lastpath != null && lastpath.length() > 0) {
                selectedPaths.add(lastpath);
            }
        }
        if (!config.isHideLeftPanel()) {
            leftTree = new ContentRepositoryTabs(config, selectedPaths);
            leftTreeComponent = ((LinkableComponent)leftTree).getComponent();
        } else {
            leftTree = null;
            leftTreeComponent = null;
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    JahiaContentManagementService.App.getInstance().getRoot(config.getRepositories().get(0).getPaths(), null, null, null, GWTJahiaNode.DEFAULT_FIELDS, selectedPaths, null, false, ContentManager.this.linker.isDisplayHiddenTypes(), config.getHiddenTypes(), config.getHiddenRegex(), false, (AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

                        public void onSuccess(List<GWTJahiaNode> gwtJahiaNode) {
                            ContentManager.this.linker.setLeftPanelSelectionWhenHidden(gwtJahiaNode.get(0));
                            HashMap<String, Object> data = new HashMap<String, Object>();
                            data.put("refreshAll", true);
                            ContentManager.this.linker.refresh(data);
                        }

                        @Override
                        public void onApplicationFailure(Throwable throwable) {
                            Log.error((String)"Unable to load node with path", (Throwable)throwable);
                        }
                    });
                }
            });
        }
        ContentViews contentViews = new ContentViews(config);
        if (config.getManagerEngineTabs() != null) {
            bottomTabs = new ContentDetails(config, this.linker);
            bottomTabsComponent = ((LinkableComponent)bottomTabs).getComponent();
        }
        ContentToolbar toolbar = new ContentToolbar(config, this.linker){};
        ContentStatusBar statusBar = new ContentStatusBar();
        this.initWidgets(leftTreeComponent, contentViews.getComponent(), bottomTabsComponent, ((LinkableComponent)toolbar).getComponent(), ((LinkableComponent)statusBar).getComponent());
        this.linker.registerComponents(leftTree, contentViews, bottomTabs, toolbar, statusBar);
        if (config.getContextMenu() != null) {
            ActionContextMenu actionContextMenu = new ActionContextMenu(config.getContextMenu(), this.linker);
            if (leftTree != null) {
                ((LinkableComponent)leftTree).getComponent().setContextMenu((Menu)actionContextMenu);
            }
            contentViews.getComponent().setContextMenu((Menu)actionContextMenu);
        }
        this.linker.handleNewSelection();
        if (!config.isExpandRoot()) {
            this.linker.handleNewSelection();
        }
        this.addStyleName("x-viewport-" + config.getName());
    }
}

