/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionEvent;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.google.gwt.storage.client.Storage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTManagerConfiguration;
import org.jahia.ajax.gwt.client.widget.content.ContentRepositoryTabs;
import org.jahia.ajax.gwt.client.widget.content.ContentToolbar;
import org.jahia.ajax.gwt.client.widget.content.ContentViews;
import org.jahia.ajax.gwt.client.widget.content.PickedContentView;
import org.jahia.ajax.gwt.client.widget.toolbar.ActionContextMenu;
import org.jahia.ajax.gwt.client.widget.tripanel.LinkableComponent;
import org.jahia.ajax.gwt.client.widget.tripanel.TriPanelBrowserLayout;

public class ContentPicker
extends TriPanelBrowserLayout {
    private PickedContentView pickedContent;

    public ContentPicker(Map<String, String> selectorOptions, List<GWTJahiaNode> selectedNodes, final List<String> types, List<String> filters, List<String> mimeTypes, final GWTManagerConfiguration config, boolean multiple) {
        super(config);
        JahiaGWTParameters.setSiteNode(config.getSiteNode());
        this.setId("JahiaGxtContentPicker");
        this.setHeight("700px");
        if (types != null && types.size() > 0) {
            config.setNodeTypes(types);
        }
        if (mimeTypes != null && mimeTypes.size() > 0) {
            config.getMimeTypes().addAll(mimeTypes);
        }
        if (filters != null && filters.size() > 0) {
            config.getFilters().addAll(filters);
        }
        ArrayList<String> selectedPaths = new ArrayList<String>();
        for (GWTJahiaNode node : selectedNodes) {
            String path = node.getPath();
            selectedPaths.add(path.substring(0, path.lastIndexOf("/")));
        }
        if (selectedPaths.isEmpty()) {
            String lastpath;
            Storage storage = Storage.getLocalStorageIfSupported();
            String string = lastpath = storage != null ? storage.getItem("lastSavedPath_" + this.getLinker().getConfig().getName() + "_" + JahiaGWTParameters.getSiteKey()) : null;
            if (lastpath != null && lastpath.length() > 0) {
                selectedPaths.add(lastpath);
            }
        }
        ContentRepositoryTabs tree = new ContentRepositoryTabs(config, selectedPaths);
        ContentViews contentViews = new ContentViews(config);
        if (multiple) {
            contentViews.setSelectionMode(Style.SelectionMode.MULTI);
        } else {
            contentViews.setSelectionMode(Style.SelectionMode.SINGLE);
        }
        contentViews.addSelectionListener(Events.BeforeSelect, (Listener)new Listener<SelectionEvent>(){

            public void handleEvent(SelectionEvent be) {
                GWTJahiaNode selection = (GWTJahiaNode)be.getModel();
                if (selection != null) {
                    ContentPicker.this.checkTypes(be, selection, config.getNodeTypes());
                    if (types != null) {
                        ContentPicker.this.checkTypes(be, selection, types);
                    }
                }
            }
        });
        contentViews.selectNodes(selectedNodes);
        PickedContentView bottomComponents = new PickedContentView(selectedNodes, multiple, config);
        ContentToolbar toolbar = new ContentToolbar(config, this.linker){};
        this.initWidgets(((LinkableComponent)tree).getComponent(), contentViews.getComponent(), multiple ? ((LinkableComponent)bottomComponents).getComponent() : null, ((LinkableComponent)toolbar).getComponent(), null);
        this.linker.registerComponents(tree, contentViews, bottomComponents, toolbar, null);
        if (config.getContextMenu() != null) {
            ActionContextMenu actionContextMenu = new ActionContextMenu(config.getContextMenu(), this.linker);
            ((LinkableComponent)tree).getComponent().setContextMenu((Menu)actionContextMenu);
            contentViews.getComponent().setContextMenu((Menu)actionContextMenu);
        }
        this.linker.handleNewSelection();
        this.pickedContent = bottomComponents;
    }

    private void checkTypes(SelectionEvent be, GWTJahiaNode selection, List<String> nodeTypes) {
        boolean found = false;
        for (String s : nodeTypes) {
            if (!selection.getNodeTypes().contains(s) && !selection.getInheritedNodeTypes().contains(s)) continue;
            found = true;
            break;
        }
        if (!found) {
            be.setCancelled(true);
        }
    }

    public List<GWTJahiaNode> getSelectedNodes() {
        return this.pickedContent.getSelectedContent();
    }

    public void setSaveButton(Button saveButton) {
        this.pickedContent.setSaveButton(saveButton);
    }
}

