/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FormEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.ProgressBar;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.HiddenField;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.DirectionalTextHelper;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.widget.Linker;

public class FileUploader
extends Window {
    private final UploadOption uploadOption;
    private int fieldCount = 0;
    private FormPanel form;
    private List<UploadPanel> uploads = new LinkedList<UploadPanel>();

    public FileUploader(final Linker linker, final GWTJahiaNode location, String defaultUploadOption) {
        int index;
        this.addStyleName("file-uploader");
        this.uploadOption = "rename".equalsIgnoreCase(defaultUploadOption) ? UploadOption.RENAME : ("version".equalsIgnoreCase(defaultUploadOption) ? UploadOption.VERSION : UploadOption.AUTO);
        this.setHeadingHtml(Messages.get("uploadFile.label"));
        this.setSize(500, 500);
        this.setResizable(false);
        ButtonBar buttons = new ButtonBar();
        final ProgressBar bar = new ProgressBar();
        bar.setWidth(200);
        this.form = new FormPanel();
        String entryPoint = JahiaGWTParameters.getServiceEntryPoint();
        if (entryPoint == null) {
            entryPoint = "/gwt/";
        }
        this.form.setHeaderVisible(false);
        this.form.setBorders(false);
        this.form.setBodyBorder(false);
        this.form.setAction(entryPoint + "fileupload");
        this.form.setEncoding(FormPanel.Encoding.MULTIPART);
        this.form.setMethod(FormPanel.Method.POST);
        this.form.setLabelWidth(200);
        this.setModal(true);
        Hidden dest = new Hidden();
        dest.setName("uploadLocation");
        final CheckBox unzip = new CheckBox();
        unzip.setFieldLabel(Messages.get("autoUnzip.label"));
        unzip.setName("unzip");
        String parentPath = location.getPath();
        if (location.isFile().booleanValue() && (index = parentPath.lastIndexOf("/")) > 0) {
            parentPath = parentPath.substring(0, index);
        }
        dest.setValue(parentPath);
        this.form.add((Widget)dest);
        this.form.add((Widget)unzip);
        this.form.addListener(Events.Submit, (Listener)new Listener<FormEvent>(){

            public void handleEvent(FormEvent ce) {
                String r = ce.getResultHtml();
                if (r == null) {
                    return;
                }
                if (r.contains("UPLOAD-SIZE-ISSUE:")) {
                    MessageBox.alert((String)Messages.get("label.error"), (String)new DirectionalTextHelper((Element)new HTML(r.replace("UPLOAD-SIZE-ISSUE:", "")).getElement(), true).getTextOrHtml(false), null);
                } else if (r.contains("UPLOAD-ISSUE:")) {
                    FileUploader.this.unmask();
                    Dialog dl = new Dialog();
                    dl.setModal(true);
                    dl.setHeadingHtml(Messages.get("label.error"));
                    dl.setHideOnButtonClick(true);
                    dl.setLayout((Layout)new FlowLayout());
                    dl.setWidth(300);
                    dl.setScrollMode(Style.Scroll.NONE);
                    dl.add((Widget)new HTML(new DirectionalTextHelper((Element)new HTML(r.replace("UPLOAD-ISSUE:", "")).getElement(), true).getTextOrHtml(false)));
                    dl.setHeight(150);
                    dl.show();
                }
            }
        });
        Button cancel = new Button(Messages.get("label.cancel"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                FileUploader.this.hide();
            }
        });
        cancel.addStyleName("button-cancel");
        final Button submit = new Button(Messages.get("label.ok"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                try {
                    FileUploader.this.mask(Messages.get("message.uploading", "Uploading..."), "x-mask-loading");
                    FileUploader.this.form.submit();
                }
                catch (Exception e) {
                    FileUploader.this.unmask();
                    bar.reset();
                    bar.setVisible(false);
                    com.google.gwt.user.client.Window.alert((String)Messages.get("checkUploads.label"));
                }
            }
        });
        submit.addStyleName("button-ok");
        buttons.add((Component)cancel);
        buttons.add((Component)submit);
        this.setButtonAlign(Style.HorizontalAlignment.CENTER);
        this.setBottomComponent((Component)buttons);
        UploadPanel p = new UploadPanel();
        this.form.add((Widget)p);
        this.form.addListener(Events.BeforeSubmit, (Listener)new Listener<FormEvent>(){

            public void handleEvent(FormEvent formEvent) {
                bar.setVisible(true);
                bar.auto();
            }
        });
        this.form.addListener(Events.Submit, (Listener)new Listener<FormEvent>(){

            public void handleEvent(FormEvent formEvent) {
                bar.reset();
                String selectFileAfterDataUpdate = null;
                String result = formEvent.getResultHtml();
                FileUploader.this.removeAll();
                String[] results = result.split("\n");
                final ArrayList exists = new ArrayList();
                for (int i = 0; i < results.length; ++i) {
                    String s = new HTML(results[i]).getText();
                    if (s.startsWith("OK:")) {
                        if (selectFileAfterDataUpdate != null) continue;
                        selectFileAfterDataUpdate = URL.decode((String)s.substring("OK: ".length()));
                        continue;
                    }
                    if (!s.startsWith("EXISTS:")) continue;
                    int i1 = s.indexOf(32);
                    int i2 = s.indexOf(32, i1 + 1);
                    int i3 = s.indexOf(32, i2 + 1);
                    String key = URL.decode((String)s.substring(i1 + 1, i2));
                    String tmp = URL.decode((String)s.substring(i2 + 1, i3));
                    String name = URL.decode((String)s.substring(i3 + 1));
                    FileUploader.this.addExistingToForm(exists, key, tmp, name, submit);
                }
                if (!exists.isEmpty()) {
                    submit.removeAllListeners();
                    submit.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                        public void componentSelected(ButtonEvent event) {
                            FileUploader.this.mask(Messages.get("message.uploading", "Uploading..."), "x-mask-loading");
                            submit.setEnabled(false);
                            ArrayList list = new ArrayList(exists);
                            exists.clear();
                            FileUploader.this.removeAll();
                            ArrayList<String[]> uploadeds = new ArrayList<String[]>();
                            for (Field[] exist : list) {
                                String tmpName = (String)exist[0].getValue();
                                int operation = ((SimpleComboBox)exist[1]).getSelectedIndex();
                                String newName = (String)exist[2].getValue();
                                uploadeds.add(new String[]{location.getPath(), tmpName, Integer.toString(operation), newName});
                            }
                            JahiaContentManagementService.App.getInstance().uploadedFile(uploadeds, new BaseAsyncCallback(){

                                public void onSuccess(Object result) {
                                    FileUploader.this.endUpload(unzip, linker);
                                }

                                @Override
                                public void onFailure(Throwable caught) {
                                    super.onFailure(caught);
                                    MessageBox.alert((String)Messages.get("label.error", "error"), (String)caught.getLocalizedMessage(), null);
                                    HashMap<String, Object> data = new HashMap<String, Object>();
                                    data.put("refreshAll", true);
                                    linker.refresh(data);
                                    FileUploader.this.unmask();
                                    FileUploader.this.hide();
                                }
                            });
                        }
                    });
                    FileUploader.this.layout();
                } else {
                    if (selectFileAfterDataUpdate != null) {
                        linker.setSelectPathAfterDataUpdate(Arrays.asList(location.getPath() + "/" + selectFileAfterDataUpdate));
                    }
                    FileUploader.this.endUpload(unzip, linker);
                }
            }
        });
        this.add((Component)this.form);
        this.setScrollMode(Style.Scroll.AUTO);
        this.show();
    }

    private void endUpload(CheckBox unzip, Linker linker) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (unzip.getValue().booleanValue()) {
            data.put("refreshAll", true);
        } else {
            data.put("refreshMain", true);
            data.put("event", "fileUploaded");
        }
        linker.refresh(data);
        this.unmask();
        this.hide();
    }

    private void addExistingToForm(final List<Field[]> exists, String key, String tmp, final String name, final Button submitButton) {
        this.unmask();
        final TextField textField = new TextField();
        textField.setFieldLabel("rename");
        textField.setName(key + "_name");
        textField.setValue((Object)name);
        textField.setEnabled(this.uploadOption == UploadOption.RENAME);
        textField.sinkEvents(Events.Change.getEventCode() | Events.OnKeyUp.getEventCode());
        HiddenField hiddenField = new HiddenField();
        hiddenField.setName(key + "_tmp");
        hiddenField.setValue((Object)tmp);
        final SimpleComboBox choose = new SimpleComboBox();
        choose.setEditable(false);
        choose.setName(key);
        choose.setTriggerAction(ComboBox.TriggerAction.ALL);
        choose.setForceSelection(true);
        final String labelRename = Messages.get("label.rename", "Rename");
        choose.add((Object)labelRename);
        choose.add((Object)(labelRename + " auto"));
        choose.add((Object)Messages.get("confirm.addNewVersion.label", "Add a new version"));
        choose.setHideLabel(true);
        choose.setValue(choose.getStore().getAt(this.uploadOption.getValue()));
        Listener<ComponentEvent> textListener = new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent be) {
                boolean canEnableSubmit = true;
                for (Field[] fld : exists) {
                    if (!((String)((SimpleComboValue)((SimpleComboBox)fld[1]).getValue()).getValue()).equals(labelRename) || fld[2].isDirty()) continue;
                    canEnableSubmit = false;
                    break;
                }
                submitButton.setEnabled(canEnableSubmit);
            }
        };
        choose.addListener(Events.SelectionChange, (Listener)new Listener<SelectionChangedEvent>((Listener)textListener, submitButton){
            final /* synthetic */ Listener val$textListener;
            final /* synthetic */ Button val$submitButton;
            {
                this.val$textListener = listener;
                this.val$submitButton = button;
            }

            public void handleEvent(SelectionChangedEvent event) {
                if (((String)((SimpleComboValue)choose.getValue()).getValue()).equals(labelRename)) {
                    textField.setValue((Object)name);
                    textField.enable();
                    textField.addListener(Events.Change, this.val$textListener);
                    textField.addListener(Events.OnKeyUp, this.val$textListener);
                    this.val$submitButton.disable();
                } else {
                    textField.setValue((Object)name);
                    textField.disable();
                    textField.removeListener(Events.Change, this.val$textListener);
                    textField.removeListener(Events.OnKeyUp, this.val$textListener);
                    this.val$submitButton.enable();
                }
            }
        });
        HorizontalPanel p = new HorizontalPanel();
        Label w = new Label(Messages.get("alreadyExists.label"));
        w.setStyleName("x-form-field");
        p.add((Widget)w);
        p.add((Widget)choose);
        p.add((Widget)textField);
        this.add((Widget)p);
        exists.add(new Field[]{hiddenField, choose, textField});
    }

    private void addUploadField() {
        this.form.add((Widget)new UploadPanel());
        for (UploadPanel p : this.uploads) {
            p.checkVisibility();
        }
        this.form.layout();
    }

    public static boolean filenameHasInvalidCharacters(String fileName) {
        if (fileName.contains("/")) {
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        } else if (fileName.contains("\\")) {
            fileName = fileName.substring(fileName.lastIndexOf("\\") + 1);
        }
        return fileName.matches(".*[\\\\/:*?\\\"<>|]+.*");
    }

    private class UploadPanel
    extends HorizontalPanel {
        private Button remove;
        private FileUpload upload;

        public UploadPanel() {
            final UploadPanel panel = this;
            this.remove = new Button("", (SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent event) {
                    if (FileUploader.this.uploads.size() > 1) {
                        FileUploader.this.form.remove((Widget)panel);
                        FileUploader.this.uploads.remove((Object)panel);
                        for (UploadPanel p : FileUploader.this.uploads) {
                            p.checkVisibility();
                        }
                    }
                }
            });
            this.remove.addStyleName("button-remove");
            this.remove.setIcon(StandardIconsProvider.STANDARD_ICONS.minusRound());
            this.remove.setToolTip(Messages.get("label.remove"));
            if (FileUploader.this.uploads.size() == 0) {
                this.remove.setVisible(false);
            }
            this.add((Widget)this.remove);
            this.upload = new FileUpload();
            this.upload.addChangeHandler(new ChangeHandler(){
                private boolean done;

                public void onChange(ChangeEvent event) {
                    if (!(this.done && FileUploader.this.uploads.size() != 1 || UploadPanel.this.upload.getFilename() == null || UploadPanel.this.upload.getFilename().length() <= 0)) {
                        if (FileUploader.filenameHasInvalidCharacters(UploadPanel.this.upload.getFilename())) {
                            MessageBox.alert((String)Messages.get("label.error"), (String)Messages.getWithArgs("failure.upload.invalid.filename", "", new String[]{UploadPanel.this.upload.getFilename()}), null);
                            this.done = false;
                            UploadPanel.this.upload.getElement().setPropertyString("value", "");
                        } else {
                            FileUploader.this.addUploadField();
                            this.done = true;
                        }
                    }
                }
            });
            this.upload.setWidth("430px");
            DOM.setElementAttribute((com.google.gwt.user.client.Element)this.upload.getElement(), (String)"size", (String)"53");
            this.upload.setName("uploadedFile" + FileUploader.this.fieldCount++);
            this.upload.addStyleName("fm-bottom-margin");
            this.add((Widget)this.upload);
            FileUploader.this.uploads.add(this);
        }

        public FileUpload getUpload() {
            return this.upload;
        }

        public void checkVisibility() {
            this.remove.setVisible(FileUploader.this.uploads.size() > 1);
        }
    }

    private static enum UploadOption {
        AUTO(1),
        RENAME(0),
        VERSION(2);

        private final int value;

        private UploadOption(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

