/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.extjs.gxt.ui.client.event.DNDListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.google.gwt.storage.client.Storage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTManagerConfiguration;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.tripanel.BottomBar;
import org.jahia.ajax.gwt.client.widget.tripanel.BottomRightComponent;
import org.jahia.ajax.gwt.client.widget.tripanel.LeftComponent;
import org.jahia.ajax.gwt.client.widget.tripanel.TopBar;
import org.jahia.ajax.gwt.client.widget.tripanel.TopRightComponent;

public class ManagerLinker
implements Linker {
    private LeftComponent m_leftComponent;
    private TopRightComponent m_topRightComponent;
    private BottomRightComponent m_bottomRightComponent;
    private TopBar m_topBar;
    private BottomBar m_bottomBar;
    private DNDListener dndListener;
    private LinkerSelectionContext selectionContext = new LinkerSelectionContext();
    private GWTJahiaNode leftPanelSelectionWhenHidden;
    private GWTManagerConfiguration config;
    protected static final String PICKER = "picker";
    protected static final String MANAGER = "manager";
    private boolean displayHiddenTypes = false;
    private boolean displayHiddenProperties = false;

    public ManagerLinker(GWTManagerConfiguration configuration) {
        this.config = configuration;
    }

    public ManagerLinker(LeftComponent leftComponent, TopRightComponent topRightComponent, BottomRightComponent bottomRightComponent, TopBar topBar, BottomBar bottomBar) {
        this.m_topRightComponent = topRightComponent;
        this.m_topBar = topBar;
        this.m_bottomRightComponent = bottomRightComponent;
        this.m_leftComponent = leftComponent;
        this.m_bottomBar = bottomBar;
        this.registerLinker();
    }

    public void registerComponents(LeftComponent leftComponent, TopRightComponent topRightComponent, BottomRightComponent bottomRightComponent, TopBar topBar, BottomBar bottomBar) {
        this.m_topRightComponent = topRightComponent;
        this.m_topBar = topBar;
        this.m_bottomRightComponent = bottomRightComponent;
        this.m_leftComponent = leftComponent;
        this.m_bottomBar = bottomBar;
        this.registerLinker();
    }

    protected void registerLinker() {
        if (this.config.isEnableDragAndDrop()) {
            this.dndListener = new DNDListener();
        }
        if (this.m_bottomBar != null) {
            this.m_bottomBar.initWithLinker(this);
        }
        if (this.m_topBar != null) {
            this.m_topBar.initWithLinker(this);
        }
        if (this.m_leftComponent != null) {
            this.m_leftComponent.initWithLinker(this);
        }
        if (this.m_topRightComponent != null) {
            this.m_topRightComponent.initWithLinker(this);
        }
        if (this.m_bottomRightComponent != null) {
            this.m_bottomRightComponent.initWithLinker(this);
        }
    }

    public void onTreeItemSelected() {
        if (this.m_leftComponent != null && this.m_leftComponent.getSelectedItem() != null) {
            boolean clearSelection = true;
            if (this.m_bottomRightComponent != null) {
                if (this.m_bottomRightComponent.getSelection() != null) {
                    for (GWTJahiaNode n : this.m_bottomRightComponent.getSelection()) {
                        if (!n.getPath().substring(0, n.toString().lastIndexOf("/")).equals(this.m_leftComponent.getSelectedItem().toString())) continue;
                        clearSelection = false;
                        break;
                    }
                }
                if (this.m_bottomRightComponent.getComponentType().equals(PICKER)) {
                    if (clearSelection && this.m_leftComponent != null) {
                        this.m_bottomRightComponent.emptySelection();
                    }
                } else {
                    this.m_bottomRightComponent.fillData(this.m_leftComponent.getSelectedItem());
                }
            }
            if (this.m_topRightComponent != null) {
                if (clearSelection) {
                    this.m_topRightComponent.clearSelection();
                }
                this.m_topRightComponent.setContent(this.m_leftComponent.getSelectedItem());
            }
            this.handleNewSelection();
        }
    }

    public void onTableItemSelected() {
        this.handleNewSelection();
        if (this.m_bottomRightComponent != null && this.m_topRightComponent != null && this.m_topRightComponent.getSelection() != null) {
            this.m_bottomRightComponent.fillData(this.m_topRightComponent.getSelection());
        }
    }

    public void handleNewSelection() {
        this.syncSelectionContext(1);
        if (this.m_topBar != null) {
            this.m_topBar.handleNewSelection();
        }
    }

    public void handleNewSelection(List<GWTJahiaNode> nodes) {
        this.selectionContext.setSelectedNodes(nodes);
        this.selectionContext.refresh(1);
        if (this.m_topBar != null) {
            this.m_topBar.handleNewSelection();
        }
    }

    public void onTableItemDoubleClicked(Object item) {
        if (this.m_leftComponent != null) {
            this.m_leftComponent.openAndSelectItem(item);
        }
    }

    public void refreshTable() {
        if (this.m_topRightComponent != null) {
            this.m_topRightComponent.refresh(null);
        }
        if (this.m_bottomRightComponent != null) {
            this.m_bottomRightComponent.fillData(this.m_topRightComponent != null ? this.m_topRightComponent.getHiddenSelection() : null);
        }
        this.handleNewSelection();
    }

    public void loading() {
        if (this.m_bottomBar != null) {
            this.m_bottomBar.showBusy();
        }
    }

    @Override
    public void loading(String msg) {
        if (this.m_bottomBar != null) {
            this.m_bottomBar.showBusy(msg);
        }
    }

    @Override
    public void loaded() {
        if (this.m_bottomBar != null) {
            this.m_bottomBar.clear();
        }
    }

    public Object getTreeSelection() {
        if (this.m_leftComponent != null) {
            return this.m_leftComponent.getSelectedItem();
        }
        return this.leftPanelSelectionWhenHidden;
    }

    public Object getTableSelection() {
        if (this.m_topRightComponent != null) {
            return this.m_topRightComponent.getSelection();
        }
        return null;
    }

    public Component getBottomRightComponent() {
        if (this.m_bottomRightComponent != null) {
            return this.m_bottomRightComponent.getComponent();
        }
        return null;
    }

    public Component getLeftComponent() {
        if (this.m_leftComponent != null) {
            return this.m_leftComponent.getComponent();
        }
        return null;
    }

    public Component getTopRightComponent() {
        if (this.m_topRightComponent != null) {
            return this.m_topRightComponent.getComponent();
        }
        return null;
    }

    public Component getTopBar() {
        if (this.m_topBar != null) {
            return this.m_topBar.getComponent();
        }
        return null;
    }

    public Component getBottomBar() {
        if (this.m_bottomBar != null) {
            return this.m_bottomBar.getComponent();
        }
        return null;
    }

    public BottomRightComponent getBottomRightObject() {
        return this.m_bottomRightComponent;
    }

    public LeftComponent getLeftObject() {
        return this.m_leftComponent;
    }

    public TopRightComponent getTopRightObject() {
        return this.m_topRightComponent;
    }

    public TopBar getTopObject() {
        return this.m_topBar;
    }

    public BottomBar getBottomObject() {
        return this.m_bottomBar;
    }

    public DNDListener getDndListener() {
        return this.dndListener;
    }

    public void setLeftPanelSelectionWhenHidden(GWTJahiaNode leftPanelSelectionWhenHidden) {
        this.leftPanelSelectionWhenHidden = leftPanelSelectionWhenHidden;
    }

    @Override
    public void setSelectPathAfterDataUpdate(List<String> paths) {
        ArrayList<GWTJahiaNode> l = new ArrayList<GWTJahiaNode>();
        for (String path : paths) {
            GWTJahiaNode n = new GWTJahiaNode();
            n.setPath(path);
            n.setName(path.substring(path.lastIndexOf("/")));
            l.add(n);
        }
        this.m_topRightComponent.selectNodes(l);
        if (this.m_bottomRightComponent != null && !l.isEmpty()) {
            this.m_bottomRightComponent.fillData(l.get(0));
        }
    }

    @Override
    public void refresh(Map<String, Object> data) {
        if (this.m_leftComponent != null) {
            this.m_leftComponent.refresh(data);
        }
        this.refreshTable();
    }

    @Override
    public void select(Object o) {
        List<GWTJahiaNode> nodes = null;
        if (o != null) {
            if (this.m_leftComponent != null) {
                this.m_leftComponent.openAndSelectItem(o);
            }
            if (this.m_bottomRightComponent != null) {
                this.m_bottomRightComponent.clear();
            }
            if (this.m_topRightComponent != null) {
                this.m_topRightComponent.setContent(o);
            }
            if (o instanceof GWTJahiaNode) {
                nodes = new ArrayList<GWTJahiaNode>();
            } else if (o instanceof List) {
                nodes = (List)o;
            }
            this.handleNewSelection(nodes);
        } else {
            this.handleNewSelection();
        }
    }

    @Override
    public LinkerSelectionContext getSelectionContext() {
        return this.selectionContext;
    }

    @Override
    public void syncSelectionContext(int context) {
        if (this.getTreeSelection() instanceof GWTJahiaNode) {
            this.selectionContext.setMainNode((GWTJahiaNode)this.getTreeSelection());
            Storage storage = Storage.getLocalStorageIfSupported();
            if (storage != null) {
                storage.setItem("lastSavedPath_" + this.getConfig().getName() + "_" + JahiaGWTParameters.getSiteKey(), ((GWTJahiaNode)this.getTreeSelection()).getPath());
            }
        }
        List list = null;
        if (this.getTableSelection() != null) {
            list = (List)this.getTableSelection();
        }
        this.selectionContext.setSelectedNodes(list);
        this.selectionContext.refresh(context);
    }

    @Override
    public GWTConfiguration getConfig() {
        return this.config;
    }

    public void setLocale(GWTJahiaLanguage locale) {
        JahiaGWTParameters.setLanguage(locale);
    }

    public void switchLanguage(GWTJahiaLanguage locale) {
        this.setLocale(locale);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("refreshAll", true);
        this.refresh(data);
    }

    public boolean isDisplayHiddenTypes() {
        return this.displayHiddenTypes;
    }

    public void setDisplayHiddenTypes(boolean displayHiddenTypes) {
        this.displayHiddenTypes = displayHiddenTypes;
    }

    @Override
    public boolean isDisplayHiddenProperties() {
        return this.displayHiddenProperties;
    }

    public void setDisplayHiddenProperties(boolean displayHiddenProperties) {
        this.displayHiddenProperties = displayHiddenProperties;
    }
}

