/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseListLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.ListLoader;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.layout.CenterLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTRenderResult;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNodeUsage;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;

public class NodeUsagesGrid {
    private static final JahiaContentManagementServiceAsync instance = JahiaContentManagementService.App.getInstance();

    public static Grid<GWTJahiaNodeUsage> createUsageGrid(final List<GWTJahiaNode> nodes, final String baseUsageUrl) {
        ArrayList<ColumnConfig> columns = new ArrayList<ColumnConfig>();
        ColumnConfig col = new ColumnConfig("pagePath", Messages.get("label.pageUrl", "Page URL"), 300);
        col.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaNodeUsage>(){

            public Object render(GWTJahiaNodeUsage gwtJahiaNodeUsage, String s, ColumnData columnData, int i, int i1, ListStore<GWTJahiaNodeUsage> gwtJahiaNodeUsageListStore, Grid<GWTJahiaNodeUsage> gwtJahiaNodeUsageGrid) {
                if (gwtJahiaNodeUsage.getLanguage() == null) {
                    return "<a href=\"" + baseUsageUrl + gwtJahiaNodeUsage.getPagePath() + ".html\" target=\"_blank\">" + gwtJahiaNodeUsage.getPageTitle() + "<a>";
                }
                return "<a href=\"" + baseUsageUrl + "/../" + gwtJahiaNodeUsage.getLanguage() + gwtJahiaNodeUsage.getPagePath() + ".html\" target=\"_blank\">" + gwtJahiaNodeUsage.getPageTitle() + " (" + gwtJahiaNodeUsage.getLanguage() + ")<a>";
            }
        });
        columns.add(col);
        col = new ColumnConfig("path", Messages.get("label.path", "URL"), 300);
        columns.add(col);
        ColumnModel cm = new ColumnModel(columns);
        ListStore usageStore = new ListStore((ListLoader)new BaseListLoader((DataProxy)new RpcProxy<List<GWTJahiaNodeUsage>>(){

            protected void load(Object loadConfig, final AsyncCallback<List<GWTJahiaNodeUsage>> asyncCallback) {
                ArrayList<String> paths = new ArrayList<String>();
                for (GWTJahiaNode selectedNode : nodes) {
                    paths.add(selectedNode.getPath());
                }
                instance.getUsages(paths, (AsyncCallback<List<GWTJahiaNodeUsage>>)new BaseAsyncCallback<List<GWTJahiaNodeUsage>>(){

                    @Override
                    public void onApplicationFailure(Throwable throwable) {
                        Log.debug((String)"Cannot retrieve usages", (Throwable)throwable);
                    }

                    public void onSuccess(List<GWTJahiaNodeUsage> gwtJahiaNodeUsages) {
                        asyncCallback.onSuccess(gwtJahiaNodeUsages);
                    }
                });
            }
        }));
        Grid tbl = new Grid(usageStore, cm);
        tbl.addListener(Events.RowDoubleClick, new Listener<GridEvent<?>>(){

            public void handleEvent(GridEvent<?> tableEvent) {
                Object url = tableEvent.getModel().get("path");
                if (url != null && url instanceof String) {
                    instance.getRenderedContent((String)url, null, JahiaGWTParameters.getUILanguage(), null, "module", null, false, null, null, null, (AsyncCallback<GWTRenderResult>)new BaseAsyncCallback<GWTRenderResult>(){

                        public void onSuccess(GWTRenderResult result) {
                            HTML html = new HTML(result.getResult());
                            Window w = new Window();
                            w.addStyleName("node-usage-dblclick-preview");
                            w.setScrollMode(Style.Scroll.AUTO);
                            w.setModal(true);
                            w.setClosable(true);
                            w.setMaximizable(true);
                            w.setSize(800, 600);
                            w.setBlinkModal(true);
                            w.setPlain(true);
                            w.setLayout((Layout)new CenterLayout());
                            w.add((Widget)html);
                            w.show();
                        }
                    });
                }
            }
        });
        usageStore.getLoader().load();
        return tbl;
    }
}

