/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelComparer;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridGroupRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridView;
import com.extjs.gxt.ui.client.widget.grid.GroupColumnData;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import java.util.ArrayList;
import java.util.List;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTManagerConfiguration;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.util.URL;
import org.jahia.ajax.gwt.client.util.icons.ContentModelIconProvider;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.widget.grid.JahiaGroupingView;
import org.jahia.ajax.gwt.client.widget.tripanel.BottomRightComponent;

public class PickedContentView
extends BottomRightComponent {
    private GroupingStore<GWTJahiaNode> store;
    private Grid<GWTJahiaNode> m_grid;
    private GWTManagerConfiguration config;
    private boolean readOnly = false;
    private boolean multiple;
    private List<GWTJahiaNode> selectedNodes;
    private String emtypSelectionMessage = "No selection";
    private Button saveButton;

    public PickedContentView(List<GWTJahiaNode> selectedNodes, boolean multiple, GWTManagerConfiguration config) {
        this.config = config;
        this.selectedNodes = selectedNodes;
        this.multiple = multiple;
        this.setComponentType("picker");
        this.createUI();
    }

    private void createUI() {
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
        ColumnConfig column = new ColumnConfig();
        column.setWidth(20);
        column.setId("preview");
        column.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaNode>(){

            public Object render(GWTJahiaNode gwtJahiaNode, String s, ColumnData columnData, int i, int i1, ListStore<GWTJahiaNode> gwtJahiaNodeListStore, Grid<GWTJahiaNode> gwtJahiaNodeGrid) {
                String url = gwtJahiaNode.getPreview() != null ? URL.appendTimestamp(gwtJahiaNode.getPreview()) : ContentModelIconProvider.getInstance().getIcon(gwtJahiaNode, true).createImage().getUrl();
                if (PickedContentView.this.multiple) {
                    return "<img heigth='16px' width='32px' src=\"" + url + "\">";
                }
                return "<img heigth='40px' width='60px' src=\"" + url + "\">";
            }
        });
        column.setHeaderHtml(Messages.get("displayName"));
        configs.add(column);
        column = new ColumnConfig();
        column.setWidth(100);
        column.setAlignment(Style.HorizontalAlignment.LEFT);
        column.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaNode>(){

            public Object render(GWTJahiaNode gwtJahiaNode, String s, ColumnData columnData, int i, int i1, ListStore<GWTJahiaNode> gwtJahiaNodeListStore, Grid<GWTJahiaNode> gwtJahiaNodeGrid) {
                String nameEscaped = SafeHtmlUtils.htmlEscape((String)gwtJahiaNode.getName());
                String html = "<div class=\"details\"> \n      <b> Name:</b> \n      <span>" + nameEscaped + "</span>\n      <b>Alt:</b> \n      <span>" + nameEscaped + "</span>\n      <br/> <b>Path:</b> \n      <span>" + SafeHtmlUtils.htmlEscape((String)gwtJahiaNode.getPath()) + "</span></div> \n      </div>";
                return html;
            }
        });
        column.setId("name");
        column.setHeaderHtml(Messages.get("name"));
        configs.add(column);
        column = new ColumnConfig();
        column.setId("displayName");
        column.setHidden(true);
        column.setHeaderHtml(Messages.get("displayName"));
        configs.add(column);
        column = new ColumnConfig();
        column.setId("path");
        column.setHeaderHtml(Messages.get("path"));
        configs.add(column);
        column = new ColumnConfig();
        column.setWidth(100);
        column.setAlignment(Style.HorizontalAlignment.RIGHT);
        column.setId("remove");
        column.setHeaderHtml("");
        column.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaNode>(){

            public Object render(final GWTJahiaNode gwtJahiaNode, String s, ColumnData columnData, int i, int i1, ListStore<GWTJahiaNode> gwtJahiaNodeListStore, Grid<GWTJahiaNode> gwtJahiaNodeGrid) {
                Button pickContentButton = new Button(Messages.get("label.remove"));
                pickContentButton.addStyleName("button-remove");
                pickContentButton.setIcon(StandardIconsProvider.STANDARD_ICONS.minusRound());
                pickContentButton.setBorders(false);
                pickContentButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                    public void componentSelected(ButtonEvent buttonEvent) {
                        PickedContentView.this.store.remove((ModelData)gwtJahiaNode);
                    }
                });
                return pickContentButton;
            }
        });
        configs.add(column);
        this.store = new GroupingStore();
        this.store.add(this.selectedNodes);
        this.store.setModelComparer((ModelComparer)new ModelComparer<GWTJahiaNode>(){

            public boolean equals(GWTJahiaNode gwtJahiaNode, GWTJahiaNode gwtJahiaNode1) {
                String path2;
                String path = gwtJahiaNode != null ? gwtJahiaNode.getPath() : null;
                String string = path2 = gwtJahiaNode1 != null ? gwtJahiaNode1.getPath() : null;
                if (path == null && path2 == null) {
                    return true;
                }
                if (path == null) {
                    return false;
                }
                return path.equalsIgnoreCase(path2);
            }
        });
        ColumnModel columnModel = new ColumnModel(configs);
        this.store.sort("name", Style.SortDir.ASC);
        this.store.groupBy("path");
        this.m_grid = new Grid(this.store, columnModel);
        this.m_grid.setHideHeaders(true);
        this.m_grid.setBorders(true);
        JahiaGroupingView view = new JahiaGroupingView();
        view.setShowGroupedColumn(false);
        view.setForceFit(true);
        view.setEmptyText(this.emtypSelectionMessage);
        view.setGroupRenderer(new GridGroupRenderer(){

            public String render(GroupColumnData data) {
                return Messages.get("label." + PickedContentView.this.config.getName() + ".selection", PickedContentView.this.config.getName() + ".selection") + ((GWTJahiaNode)data.models.get(0)).getPath();
            }
        });
        this.m_grid.setView((GridView)view);
    }

    @Override
    public void clear() {
    }

    @Override
    public void emptySelection() {
        this.fillData(new ArrayList());
    }

    @Override
    public void fillData(Object root) {
        if (this.readOnly) {
            return;
        }
        if (root instanceof List) {
            this.setSelection((List)root);
        } else if (root instanceof GWTJahiaNode) {
            ArrayList<GWTJahiaNode> list = new ArrayList<GWTJahiaNode>();
            list.add((GWTJahiaNode)root);
            this.setSelection(list);
        }
    }

    @Override
    public List<GWTJahiaNode> getSelection() {
        return this.store.getModels();
    }

    public void setSelection(List<GWTJahiaNode> selection) {
        if (this.readOnly) {
            return;
        }
        if (selection != null && selection.size() > 0) {
            if (this.multiple) {
                for (GWTJahiaNode n : selection) {
                    if (this.store.contains((ModelData)n)) continue;
                    this.store.add((ModelData)n);
                }
            } else {
                this.store.removeAll();
                this.store.add((ModelData)selection.get(0));
            }
            if (this.saveButton != null) {
                this.saveButton.setEnabled(true);
            }
        } else if (this.saveButton != null) {
            this.saveButton.setEnabled(false);
        }
    }

    public void refresh() {
        Log.warn((String)"Method refresh() no implemented");
    }

    @Override
    public Component getComponent() {
        return this.m_grid;
    }

    public List<GWTJahiaNode> getSelectedContent() {
        return this.store.getModels();
    }

    public List<String[]> getSelectedContentPath(String jahiaContextPath, String jahiaServletPath, String filesServletPath) {
        List<GWTJahiaNode> selectedContents = this.getSelectedContent();
        if (selectedContents == null) {
            return null;
        }
        if (selectedContents.isEmpty()) {
            return new ArrayList<String[]>(0);
        }
        ArrayList<String[]> pathes = new ArrayList<String[]>();
        String prefix = jahiaContextPath + filesServletPath;
        for (GWTJahiaNode s : selectedContents) {
            if (this.config.getNodeTypes().contains("nt:file")) {
                String url = s.getUrl();
                if (url.startsWith(prefix) && url.length() > prefix.length() + 2) {
                    try {
                        url = url.substring(prefix.length()).substring(1);
                        url = prefix + "/{workspace}" + url.substring(url.indexOf("/"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                pathes.add(new String[]{url, s.getDisplayName()});
                continue;
            }
            prefix = jahiaContextPath + jahiaServletPath;
            pathes.add(new String[]{prefix + "/{mode}/{lang}" + s.getPath() + ".html", s.getDisplayName()});
        }
        return pathes;
    }

    public void setSaveButton(Button saveButton) {
        this.saveButton = saveButton;
    }

    public Button getSaveButton() {
        return this.saveButton;
    }

    public native String getThumbsListTemplate();
}

