/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.core.El;
import com.extjs.gxt.ui.client.data.BasePagingLoadResult;
import com.extjs.gxt.ui.client.data.LoadEvent;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.dnd.DND;
import com.extjs.gxt.ui.client.dnd.GridDragSource;
import com.extjs.gxt.ui.client.dnd.GridDropTarget;
import com.extjs.gxt.ui.client.dnd.Insert;
import com.extjs.gxt.ui.client.event.DNDEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.LoadListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.util.Rectangle;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentPlugin;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.grid.CellEditor;
import com.extjs.gxt.ui.client.widget.grid.CheckBoxSelectionModel;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.EditorGrid;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridSelectionModel;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaItemDefinition;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTManagerConfiguration;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.WindowUtil;
import org.jahia.ajax.gwt.client.util.content.actions.ContentActions;
import org.jahia.ajax.gwt.client.util.definition.FormFieldCreator;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.NodeColumnConfigList;
import org.jahia.ajax.gwt.client.widget.content.AbstractView;
import org.jahia.ajax.gwt.client.widget.content.ImagePopup;
import org.jahia.ajax.gwt.client.widget.content.ManagerLinker;
import org.jahia.ajax.gwt.client.widget.content.PickedContentView;
import org.jahia.ajax.gwt.client.widget.tripanel.BottomRightComponent;

public class TableView
extends AbstractView {
    private Grid<GWTJahiaNode> m_grid;

    public TableView(final GWTManagerConfiguration config) {
        super(config);
        final NodeColumnConfigList columns = new NodeColumnConfigList(this.configuration.getTableColumns());
        columns.init();
        CheckBoxSelectionModel checkboxSelectionModel = null;
        if (this.configuration.isAllowsMultipleSelection()) {
            checkboxSelectionModel = new CheckBoxSelectionModel();
            columns.add(0, checkboxSelectionModel.getColumn());
        }
        this.m_grid = this.configuration.isEditableGrid() ? new EditorGrid(this.store, new ColumnModel((List)columns)) : new Grid(this.store, new ColumnModel((List)columns));
        this.m_grid.setBorders(true);
        if (columns.getAutoExpand() != null) {
            this.m_grid.setAutoExpandColumn(columns.getAutoExpand());
            this.store.setSortField(columns.getAutoExpand());
            this.m_grid.setAutoExpandMax(1000);
        }
        if (checkboxSelectionModel != null) {
            this.m_grid.setSelectionModel((GridSelectionModel)checkboxSelectionModel);
            this.m_grid.addPlugin((ComponentPlugin)checkboxSelectionModel);
        }
        this.selectionModel = this.m_grid.getSelectionModel();
        if (this.configuration.isAllowsMultipleSelection()) {
            this.selectionModel.setSelectionMode(Style.SelectionMode.MULTI);
        } else {
            this.selectionModel.setSelectionMode(Style.SelectionMode.SINGLE);
        }
        this.m_grid.addListener(Events.RowDoubleClick, (Listener)new Listener<GridEvent>(){

            public void handleEvent(GridEvent event) {
                List sel = TableView.this.selectionModel.getSelectedItems();
                if (sel != null && sel.size() == 1) {
                    GWTJahiaNode el = (GWTJahiaNode)sel.get(0);
                    if (el.isFile().booleanValue()) {
                        BottomRightComponent buttonBar = TableView.this.getLinker().getBottomRightObject();
                        if (buttonBar instanceof PickedContentView) {
                            ((PickedContentView)buttonBar).setSelection(sel);
                            ((PickedContentView)buttonBar).getSaveButton().fireEvent(Events.Select);
                            return;
                        }
                        if (config.isEnableFileDoubleClick()) {
                            if (el.isDisplayable()) {
                                ImagePopup.popImage(el, TableView.this.getLinker());
                            } else {
                                ContentActions.download(TableView.this.getLinker());
                            }
                        }
                    } else if (!config.isHideLeftPanel()) {
                        TableView.this.getLinker().onTableItemDoubleClicked(sel.get(0));
                        TableView.this.setContent(sel.get(0));
                    } else {
                        Log.debug((String)"Double click disable if left panle is hidden");
                    }
                }
            }
        });
        if (config.isEditableGrid()) {
            this.loader.addLoadListener(new LoadListener(){

                public void loaderLoad(LoadEvent le) {
                    BasePagingLoadResult r = (BasePagingLoadResult)le.getData();
                    ArrayList<String> nodeTypes = null;
                    for (GWTJahiaNode node : r.getData()) {
                        ArrayList<String> currentNodeTypes = new ArrayList<String>(node.getNodeTypes());
                        currentNodeTypes.addAll(node.getInheritedNodeTypes());
                        if (nodeTypes == null) {
                            nodeTypes = currentNodeTypes;
                            continue;
                        }
                        nodeTypes.retainAll(currentNodeTypes);
                    }
                    TableView.this.generateEditableColumns(columns, nodeTypes);
                }
            });
        }
    }

    private void generateEditableColumns(final NodeColumnConfigList columns, List<String> nodeTypes) {
        JahiaContentManagementService.App.getInstance().getNodeTypes(nodeTypes, new AsyncCallback<List<GWTJahiaNodeType>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(List<GWTJahiaNodeType> result) {
                ColumnModel columnModel = new ColumnModel((List)columns);
                for (GWTJahiaNodeType gwtJahiaNodeType : result) {
                    block9: for (GWTJahiaItemDefinition definition : gwtJahiaNodeType.getItems()) {
                        Field<?> f;
                        if (!definition.getDataType().equals("content") || definition.isHidden() || definition.isProtected()) continue;
                        ColumnConfig e = new ColumnConfig(definition.getName(), definition.getLabel(), 200);
                        switch (definition.getSelector()) {
                            case 1: {
                                break;
                            }
                            case 5: {
                                break;
                            }
                            case 2: {
                                continue block9;
                            }
                            case 3: 
                            case 4: {
                                e.setWidth(100);
                                break;
                            }
                            case 11: 
                            case 12: 
                            case 13: 
                            case 15: {
                                break;
                            }
                            case 9: {
                                e.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaNode>(){

                                    public Object render(GWTJahiaNode model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<GWTJahiaNode> store, Grid<GWTJahiaNode> grid) {
                                        return ((String)model.get(property)).substring(((String)model.get(property)).indexOf("/"));
                                    }
                                });
                                break;
                            }
                        }
                        if ((f = FormFieldCreator.createField(definition, null, null, false, TableView.this.root.getPermissions(), null)) == null) continue;
                        e.setEditor(new CellEditor(f));
                        columnModel.getColumns().add(e);
                    }
                }
                TableView.this.m_grid.reconfigure(TableView.this.m_grid.getStore(), columnModel);
            }
        });
    }

    @Override
    public void initWithLinker(ManagerLinker linker) {
        super.initWithLinker(linker);
        if (this.getLinker().getDndListener() != null) {
            GridDragSource source = new GridDragSource(this.m_grid){

                protected void onDragDrop(DNDEvent e) {
                }

                protected void onDragStart(DNDEvent e) {
                    super.onDragStart(e);
                    List l = (List)e.getData();
                    if (l != null) {
                        for (GWTJahiaNode node : l) {
                            if (TableView.this.isNodeTypeAllowed(node) && PermissionsUtils.isPermitted("jcr:removeNode", node.getPermissions())) continue;
                            e.setCancelled(true);
                            break;
                        }
                    } else {
                        e.setCancelled(true);
                    }
                }
            };
            source.addDNDListener(linker.getDndListener());
            MyGridDropTarget target = new MyGridDropTarget(this.m_grid);
            target.setAllowSelfAsSource(true);
            target.addDNDListener(linker.getDndListener());
        }
    }

    public void setContextMenu(Menu menu) {
        this.m_grid.setContextMenu(menu);
    }

    @Override
    public Component getComponent() {
        return this.m_grid;
    }

    private class MyGridDropTarget
    extends GridDropTarget {
        private boolean before;

        public MyGridDropTarget(Grid grid) {
            super(grid);
        }

        protected void showFeedback(DNDEvent event) {
            GWTJahiaNode node = TableView.this.root;
            this.feedback = "index".equals(TableView.this.store.getSortField()) && TableView.this.store.getSortDir() == Style.SortDir.ASC && Boolean.TRUE.equals(node.get("hasOrderableChildNodes")) ? DND.Feedback.INSERT : DND.Feedback.APPEND;
            event.getStatus().setStatus(true);
            com.google.gwt.user.client.Element row = (com.google.gwt.user.client.Element)this.grid.getView().findRow((Element)event.getTarget()).cast();
            if (row != null) {
                if (this.feedback == DND.Feedback.INSERT) {
                    boolean after;
                    int height = row.getOffsetHeight();
                    int quarter = height / 4;
                    int top = WindowUtil.getAbsoluteTop(row);
                    int y = event.getClientY();
                    this.before = y < top + quarter;
                    boolean bl = after = y > top + 3 * quarter;
                    if (this.before || after) {
                        int idx = this.grid.getView().findRowIndex((Element)row);
                        this.showInsert(event, row);
                        if (after) {
                            this.activeItem = this.grid.getStore().getAt(idx + 1);
                            this.before = true;
                        } else {
                            this.activeItem = this.grid.getStore().getAt(idx);
                        }
                        this.insertIndex = this.adjustIndex(event, idx);
                    } else {
                        this.activeItem = this.grid.getStore().getAt(this.grid.getView().findRowIndex((Element)row));
                        Insert.get().hide();
                    }
                } else {
                    this.activeItem = this.grid.getStore().getAt(this.grid.getView().findRowIndex((Element)row));
                }
            } else {
                this.activeItem = null;
                this.before = false;
                this.insertIndex = 0;
                if (this.feedback == DND.Feedback.INSERT) {
                    this.showInsert(event, (com.google.gwt.user.client.Element)this.grid.getView().getRow(this.grid.getStore().getCount() - 1));
                }
            }
            if (!this.before) {
                GWTJahiaNode target = this.activeItem != null ? (GWTJahiaNode)this.activeItem : node;
                event.getStatus().setStatus(this.checkTarget((GWTJahiaNode)((List)event.getData()).get(0), target));
            }
        }

        protected void onDragDrop(DNDEvent dndEvent) {
            if (dndEvent.getStatus().getStatus()) {
                GWTJahiaNode target;
                BaseAsyncCallback callback = new BaseAsyncCallback(){

                    public void onSuccess(Object o) {
                        TableView.this.getLinker().loaded();
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("refreshAll", true);
                        TableView.this.getLinker().refresh(data);
                    }
                };
                List gwtJahiaNodes = (List)dndEvent.getData();
                ArrayList<String> sources = new ArrayList<String>();
                for (GWTJahiaNode n : gwtJahiaNodes) {
                    sources.add(n.getPath());
                }
                if (this.activeItem != null) {
                    target = (GWTJahiaNode)this.activeItem;
                    if (this.before) {
                        JahiaContentManagementService.App.getInstance().moveOnTopOf(sources, target.getPath(), callback);
                    } else {
                        JahiaContentManagementService.App.getInstance().moveAtEnd(sources, target.getPath(), callback);
                    }
                } else {
                    target = TableView.this.root;
                    JahiaContentManagementService.App.getInstance().moveAtEnd(sources, target.getPath(), callback);
                }
            }
        }

        private boolean checkTarget(GWTJahiaNode source, GWTJahiaNode target) {
            HashSet<String> constraints = new HashSet<String>(Arrays.asList(target.getChildConstraints().split(" ")));
            constraints.retainAll(source.getInheritedNodeTypes());
            return !constraints.isEmpty();
        }

        private int adjustIndex(DNDEvent event, int index) {
            Object data = event.getData();
            List models = this.prepareDropData(data, true);
            for (ModelData m : models) {
                int idx = this.grid.getStore().indexOf(m);
                if (idx <= -1 || !(this.before ? idx < index : idx <= index)) continue;
                --index;
            }
            return this.before ? index : index + 1;
        }

        private void showInsert(DNDEvent event, com.google.gwt.user.client.Element row) {
            Insert insert = Insert.get();
            insert.show(row);
            Rectangle rect = El.fly((com.google.gwt.user.client.Element)row).getBounds();
            int y = !this.before ? rect.y + rect.height - 4 : rect.y - 2;
            insert.el().setBounds(rect.x, y, rect.width, 6);
        }
    }
}

