/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.FormButtonBinding;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACE;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.content.util.ContentHelper;
import org.jahia.ajax.gwt.client.widget.contentengine.AbstractContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.ContentTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.CreateContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.SaveButtonItem;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;

public class CreateButtonItem
extends SaveButtonItem {
    private boolean forceCreation = true;
    private boolean useNamePopup = false;
    private boolean redirectToCreatedPage;

    public void setUseNamePopup(boolean useNamePopup) {
        this.useNamePopup = useNamePopup;
    }

    @Override
    protected void prepareAndSave(AbstractContentEngine engine, boolean closeAfterSave) {
        if (this.useNamePopup) {
            this.showNamePopup(engine, closeAfterSave);
        } else {
            this.continuePrepareAndSave(engine, closeAfterSave, ((CreateContentEngine)engine).getTargetName());
        }
    }

    protected void continuePrepareAndSave(AbstractContentEngine engine, boolean closeAfterSave, String nodeName) {
        GWTJahiaNodeACL newNodeACL = new GWTJahiaNodeACL();
        ArrayList<GWTJahiaNode> children = new ArrayList<GWTJahiaNode>();
        newNodeACL.setAce(new ArrayList<GWTJahiaNodeACE>());
        HashSet<String> addedTypes = new HashSet<String>();
        for (TabItem tab : engine.getTabs().getItems()) {
            EditEngineTabItem item = (EditEngineTabItem)tab.getData("item");
            if (item instanceof ContentTabItem) {
                List<CheckBox> values;
                if (((ContentTabItem)item).isNodeNameFieldDisplayed()) {
                    nodeName = (String)((ContentTabItem)item).getName().getValue();
                }
                if ((values = ((ContentTabItem)item).getCheckedLanguagesCheckBox()) != null) {
                    List<GWTJahiaLanguage> siteLanguages = JahiaGWTParameters.getSiteLanguages();
                    if (values.size() != siteLanguages.size()) {
                        List<GWTJahiaNodePropertyValue> list;
                        ArrayList<String> strings = new ArrayList<String>(siteLanguages.size());
                        for (GWTJahiaLanguage gWTJahiaLanguage : siteLanguages) {
                            strings.add(gWTJahiaLanguage.getLanguage());
                        }
                        GWTJahiaNodeProperty gwtJahiaNodeProperty = new GWTJahiaNodeProperty();
                        gwtJahiaNodeProperty.setName("j:invalidLanguages");
                        gwtJahiaNodeProperty.setMultiple(true);
                        for (CheckBox value : values) {
                            if (!value.getValue().booleanValue()) continue;
                            strings.remove(value.getValueAttribute());
                        }
                        if (strings.size() > 0) {
                            gwtJahiaNodeProperty.setValues(new ArrayList<GWTJahiaNodePropertyValue>());
                            for (String string : strings) {
                                gwtJahiaNodeProperty.getValues().add(new GWTJahiaNodePropertyValue(string));
                            }
                        }
                        if ((list = gwtJahiaNodeProperty.getValues()) != null && list.size() > 0) {
                            engine.getChangedProperties().add(gwtJahiaNodeProperty);
                            addedTypes.add("jmix:i18n");
                        }
                    }
                }
            }
            item.doSave(engine.getNode(), engine.getChangedProperties(), engine.getChangedI18NProperties(), addedTypes, new HashSet<String>(), children, newNodeACL);
        }
        this.doSave((CreateContentEngine)engine, nodeName, engine.getChangedProperties(), engine.getChangedI18NProperties(), new ArrayList<String>(addedTypes), children, newNodeACL, closeAfterSave);
    }

    protected void doSave(final CreateContentEngine engine, String nodeName, List<GWTJahiaNodeProperty> props, Map<String, List<GWTJahiaNodeProperty>> langCodeProperties, List<String> mixin, List<GWTJahiaNode> children, GWTJahiaNodeACL newNodeACL, final boolean closeAfterSave) {
        BaseAsyncCallback<GWTJahiaNode> callback = new BaseAsyncCallback<GWTJahiaNode>(){

            @Override
            public void onApplicationFailure(Throwable throwable) {
                CreateButtonItem.this.failSave(engine, throwable);
            }

            public void onSuccess(GWTJahiaNode node) {
                if (closeAfterSave) {
                    Info.display((String)Messages.get("label.information", "Information"), (String)(Messages.get("org.jahia.engines.contentmanager.addContentWizard.formCard.success.save", "Content node created successfully:") + " " + node.getName()));
                    engine.close();
                    engine.getLinker().setSelectPathAfterDataUpdate(Arrays.asList(node.getPath()));
                    if (!engine.skipRefreshOnSave()) {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("refreshMain", true);
                        data.put("node", node);
                        engine.getLinker().refresh(data);
                        MainModule mainModule = MainModule.getInstance();
                        if (CreateButtonItem.this.redirectToCreatedPage && mainModule != null && mainModule.getEditLinker() != null && node.isPage()) {
                            MainModule.staticGoTo(node.getPath(), null);
                        }
                    }
                } else {
                    engine.getTabs().removeAll();
                    engine.getProperties().clear();
                    engine.initTabs();
                    engine.getChangedI18NProperties().clear();
                    engine.getChangedProperties().clear();
                    engine.getTabs().setSelection((TabItem)engine.getTabs().getItem(0));
                    engine.layout(true);
                    engine.unmask();
                    engine.setButtonsEnabled(true);
                    engine.setChildCount(engine.getChildCount() + 1);
                }
                ContentHelper.sendContentModificationEvent(node.getUUID(), node.getPath(), node.getName(), "create", engine.getType().getName());
            }
        };
        engine.removeUneditedLanguages();
        if (mixin.contains("jmix:createdFromPageModel")) {
            String sourcePath = null;
            for (GWTJahiaNodeProperty p : engine.getChangedProperties()) {
                if (!p.getName().equals("j:templateName")) continue;
                sourcePath = p.getValues().get(0).getString();
                engine.getChangedProperties().remove(p);
                break;
            }
            JahiaContentManagementService.App.getInstance().createPageFromPageModel(sourcePath, engine.getTargetNode().getPath(), nodeName, engine.getType().getName(), mixin, newNodeACL, props, langCodeProperties, (AsyncCallback<GWTJahiaNode>)callback);
        } else if (engine.isCreateInParentAndMoveBefore()) {
            JahiaContentManagementService.App.getInstance().createNodeAndMoveBefore(engine.getTargetNode().getPath(), nodeName, engine.getType().getName(), mixin, newNodeACL, props, langCodeProperties, (AsyncCallback<GWTJahiaNode>)callback);
        } else {
            JahiaContentManagementService.App.getInstance().createNode(engine.getParentPath(), nodeName, engine.getType().getName(), mixin, newNodeACL, props, langCodeProperties, children, null, this.forceCreation, (AsyncCallback<GWTJahiaNode>)callback);
        }
    }

    protected void showNamePopup(final AbstractContentEngine engine, final boolean closeAfterSave) {
        final Window popup = new Window();
        popup.addStyleName("set-name-modal");
        popup.setHeadingHtml(Messages.get("label.saveAs", "Save as ..."));
        popup.setHeight(120);
        popup.setWidth(350);
        popup.setModal(true);
        FormPanel f = new FormPanel();
        f.setHeaderVisible(false);
        f.setBorders(false);
        final TextField name = new TextField();
        name.setFieldLabel(Messages.get("label.name", "Name"));
        name.setMinLength(1);
        f.add((Widget)name);
        Button b = new Button(Messages.get("label.submit", "submit"));
        b.addStyleName("button-submit");
        f.addButton(b);
        b.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent buttonEvent) {
                CreateButtonItem.this.continuePrepareAndSave(engine, closeAfterSave, (String)name.getValue());
                popup.hide();
            }
        });
        Button c = new Button(Messages.get("label.cancel", "Cancel"));
        c.addStyleName("button-cancel");
        c.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent buttonEvent) {
                popup.hide();
            }
        });
        f.addButton(c);
        f.setButtonAlign(Style.HorizontalAlignment.CENTER);
        FormButtonBinding binding = new FormButtonBinding(f);
        binding.addButton(b);
        popup.add((Widget)f);
        popup.setFocusWidget((Widget)name);
        popup.show();
    }

    public void setForceCreation(boolean forceCreation) {
        this.forceCreation = forceCreation;
    }

    public void setRedirectToCreatedPage(boolean redirectToCreatedPage) {
        this.redirectToCreatedPage = redirectToCreatedPage;
    }
}

