/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.BoxComponent;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaEditEngineInitBean;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaGetPropertiesResult;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEngineConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEngineTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.Formatter;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.contentengine.AbstractContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.ButtonItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineJSConfig;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineContainer;
import org.jahia.ajax.gwt.client.widget.contentengine.WorkInProgressButtonItem;

public class EditContentEngine
extends AbstractContentEngine {
    private String contentPath;
    private HandlerRegistration handlerRegistration;
    private Map<String, GWTJahiaGetPropertiesResult> langCodeGWTJahiaGetPropertiesResultMap = new HashMap<String, GWTJahiaGetPropertiesResult>();
    private boolean hasOrderableChildNodes;
    private boolean workInProgressCheckedByDefault = false;
    private EditEngineJSConfig jsConfig;

    public EditContentEngine(GWTEngineConfiguration configuration, GWTJahiaNode node, Linker linker, EngineContainer engineContainer, boolean skipRefreshOnSave, EditEngineJSConfig jsConfig) {
        super(configuration, linker, node.getPath().substring(0, node.getPath().lastIndexOf(47)), skipRefreshOnSave);
        this.contentPath = node.getPath();
        this.nodeName = node.getName();
        this.node = node;
        this.jsConfig = jsConfig == null ? EditEngineJSConfig.getDefaultJSConfig() : jsConfig;
        this.init(engineContainer);
        this.loadEngine();
        this.addStyleName("edit-content-engine");
        this.handlerRegistration = Window.addCloseHandler((CloseHandler)new CloseHandler<Window>(){

            public void onClose(CloseEvent<Window> event) {
                EditContentEngine.this.close();
            }
        });
    }

    @Override
    public void close() {
        super.close();
        JahiaGWTParameters.removeEngineLanguage();
        JahiaContentManagementService.App.getInstance().closeEditEngine(this.contentPath, new BaseAsyncCallback<Object>(){

            public void onSuccess(Object result) {
            }
        });
        this.closeEngine();
    }

    protected void closeEngine() {
        if (this.handlerRegistration != null) {
            this.handlerRegistration.removeHandler();
            this.handlerRegistration = null;
        }
        this.container.closeEngine();
    }

    protected void initTabs() {
        this.tabs.setId("JahiaGxtEditEngineTabs");
        for (GWTEngineTab tabConfig : this.config.getEngineTabs()) {
            EditEngineTabItem tabItem = tabConfig.getTabItem();
            if (!this.jsConfig.isTabDisplayed(tabConfig.getId()) || !tabConfig.showInEngine() || tabConfig.getRequiredPermission() != null && !PermissionsUtils.isPermitted(tabConfig.getRequiredPermission(), JahiaGWTParameters.getSiteNode()) || !tabItem.getHideForTypes().isEmpty() && this.node.isNodeType(tabItem.getHideForTypes()) || (!this.hasOrderableChildNodes || !tabItem.isOrderableTab()) && (tabItem.isOrderableTab() || !tabItem.getShowForTypes().isEmpty() && !this.node.isNodeType(tabItem.getShowForTypes()))) continue;
            AsyncTabItem tab = tabItem.create(tabConfig, this);
            if (this.jsConfig.hideHeaders()) {
                tab.getHeader().hide();
            }
            this.tabs.add((TabItem)tab);
        }
        this.tabs.setSelection((TabItem)this.tabs.getItem(0));
    }

    @Override
    protected void initFooter() {
        for (ButtonItem buttonItem : this.config.getEditionButtons()) {
            if (buttonItem instanceof WorkInProgressButtonItem && this.jsConfig.hideWip()) continue;
            BoxComponent button = buttonItem.create(this);
            this.buttons.add(button);
            this.buttonBar.add((Component)button);
        }
        for (ButtonItem buttonItem : this.config.getCommonButtons()) {
            this.buttonBar.add((Component)buttonItem.create(this));
        }
        this.setButtonsEnabled(false);
    }

    private void loadProperties() {
        JahiaContentManagementService.App.getInstance().getProperties(this.contentPath, this.getSelectedLanguage(), (AsyncCallback<GWTJahiaGetPropertiesResult>)new BaseAsyncCallback<GWTJahiaGetPropertiesResult>(){

            @Override
            public void onApplicationFailure(Throwable throwable) {
                Log.debug((String)"Cannot get properties", (Throwable)throwable);
            }

            public void onSuccess(GWTJahiaGetPropertiesResult result) {
                EditContentEngine.this.node = result.getNode();
                EditContentEngine.this.nodeTypes = result.getNodeTypes();
                EditContentEngine.this.properties = result.getProperties();
                EditContentEngine.this.currentLanguageBean = result.getCurrentLocale();
                if (EditContentEngine.this.getSelectedLanguage() != null) {
                    EditContentEngine.this.langCodeGWTJahiaGetPropertiesResultMap.put(EditContentEngine.this.getSelectedLanguage(), result);
                }
                EditContentEngine.this.fillCurrentTab();
                EditContentEngine.this.loaded();
            }
        });
    }

    private void loadEngine() {
        JahiaContentManagementService.App.getInstance().initializeEditEngine(this.contentPath, true, (AsyncCallback<GWTJahiaEditEngineInitBean>)new BaseAsyncCallback<GWTJahiaEditEngineInitBean>(){

            public void onSuccess(GWTJahiaEditEngineInitBean result) {
                if (result == null || EditContentEngine.this.closed) {
                    return;
                }
                if (EditContentEngine.this.jsConfig.hideHeaders()) {
                    EditContentEngine.this.container.getPanel().getHeader().hide();
                    EditContentEngine.this.tabs.setBorders(false);
                    EditContentEngine.this.container.getPanel().addStyleName("hide-headers");
                    EditContentEngine.this.addStyleName("hide-headers");
                }
                EditContentEngine.this.node = result.getNode();
                EditContentEngine.this.nodeTypes = result.getNodeTypes();
                EditContentEngine.this.properties = result.getProperties();
                EditContentEngine.this.currentLanguageBean = result.getCurrentLocale();
                EditContentEngine.this.defaultLanguageCode = result.getDefaultLanguageCode();
                EditContentEngine.this.hasOrderableChildNodes = result.hasOrderableChildNodes();
                EditContentEngine.this.langCodeGWTJahiaGetPropertiesResultMap.put(EditContentEngine.this.currentLanguageBean.getLanguage(), result);
                EditContentEngine.this.acl = result.getAcl();
                EditContentEngine.this.referencesWarnings = result.getReferencesWarnings();
                EditContentEngine.this.heading = !PermissionsUtils.isPermitted("jcr:modifyProperties", EditContentEngine.this.node) ? Messages.getWithArgs("label.edit.engine.heading.read.only", "Read {0} ({1})", new String[]{EditContentEngine.this.nodeName, ((GWTJahiaNodeType)EditContentEngine.this.nodeTypes.get(0)).getLabel()}) : Messages.getWithArgs("label.edit.engine.heading.edit", "Edit {0} ({1})", new String[]{EditContentEngine.this.nodeName, ((GWTJahiaNodeType)EditContentEngine.this.nodeTypes.get(0)).getLabel()});
                Element headerElement = EditContentEngine.this.container.getPanel().getHeader().getElement();
                for (int i = 0; i < headerElement.getChildNodes().getLength(); ++i) {
                    Object el;
                    if (!(headerElement.getChild(i) instanceof Element) || !(el = (Element)headerElement.getChild(i)).getClassName().contains("-header-text")) continue;
                    String string = el.getClassName() + (EditContentEngine.this.node.isMarkedForDeletion() ? " marked-for-deletion" : "") + (EditContentEngine.this.node.isMarkedForDeletionRoot() ? " marked-for-deletion-root" : "");
                    el.setClassName(string);
                    el.setAttribute("data-friendly-name", EditContentEngine.this.node.getDisplayName());
                    Boolean isLocked = EditContentEngine.this.node.isLocked() != false || EditContentEngine.this.node.getLockInfos() != null && !EditContentEngine.this.node.getLockInfos().isEmpty();
                    el.setAttribute("data-content-locked", isLocked.toString());
                }
                EditContentEngine.this.container.getPanel().setHeadingHtml(EditContentEngine.this.heading);
                if (EditContentEngine.this.node.isLocked().booleanValue()) {
                    StringBuilder infos = new StringBuilder();
                    if (EditContentEngine.this.node.getLockInfos().containsKey(null) && EditContentEngine.this.node.getLockInfos().size() == 1) {
                        for (String string : EditContentEngine.this.node.getLockInfos().get(null)) {
                            infos.append(Formatter.getLockLabel(string));
                        }
                    } else {
                        for (Map.Entry entry : EditContentEngine.this.node.getLockInfos().entrySet()) {
                            if (entry.getKey() == null) continue;
                            if (infos.length() > 0) {
                                infos.append("; ");
                            }
                            infos.append((String)entry.getKey()).append(" : ");
                            int i = 0;
                            for (String s : (List)entry.getValue()) {
                                if (i > 0) {
                                    infos.append(", ");
                                }
                                infos.append(Formatter.getLockLabel(s));
                                ++i;
                            }
                        }
                    }
                    EditContentEngine.this.heading = EditContentEngine.this.heading + "&nbsp;" + Messages.getWithArgs("label.edit.engine.heading.locked.by", "[ locked by {0} ]", new String[]{infos.toString()});
                    EditContentEngine.this.container.getPanel().setHeadingHtml(EditContentEngine.this.heading);
                } else if (EditContentEngine.this.node.getLockInfos() != null && !EditContentEngine.this.node.getLockInfos().isEmpty()) {
                    EditContentEngine.this.heading = EditContentEngine.this.heading + "&nbsp;" + Messages.get("label.edit.engine.heading.locked.by.you", "[ locked by you ]");
                    EditContentEngine.this.container.getPanel().setHeadingHtml(EditContentEngine.this.heading);
                }
                boolean doUpdateWipControls = false;
                if (EditContentEngine.this.node.getWorkInProgressStatus() != null) {
                    GWTJahiaNode.WipStatus status = GWTJahiaNode.WipStatus.valueOf(EditContentEngine.this.node.getWorkInProgressStatus());
                    if (EditContentEngine.this.node.getWorkInProgressLanguages() != null) {
                        for (String lang : EditContentEngine.this.node.getWorkInProgressLanguages()) {
                            for (GWTJahiaLanguage l : result.getAvailabledLanguages()) {
                                if (!l.getLanguage().equals(lang)) continue;
                                EditContentEngine.this.workInProgressLanguages.add(lang);
                            }
                        }
                    }
                    EditContentEngine.this.wipStatus = status == GWTJahiaNode.WipStatus.LANGUAGES && EditContentEngine.this.workInProgressLanguages.isEmpty() ? GWTJahiaNode.WipStatus.DISABLED : status;
                    doUpdateWipControls = true;
                }
                if (EditContentEngine.this.workInProgressCheckedByDefault && GWTJahiaNode.WipStatus.DISABLED == EditContentEngine.this.wipStatus) {
                    if (JahiaGWTParameters.getSiteLanguages().size() == 1) {
                        EditContentEngine.this.setWipStatus(GWTJahiaNode.WipStatus.LANGUAGES);
                        EditContentEngine.this.workInProgressLanguages = new HashSet();
                        EditContentEngine.this.workInProgressLanguages.add(JahiaGWTParameters.getSiteLanguages().get(0).getLanguage());
                    } else {
                        EditContentEngine.this.setWipStatus(GWTJahiaNode.WipStatus.ALL_CONTENT);
                    }
                    doUpdateWipControls = true;
                }
                if (doUpdateWipControls) {
                    EditContentEngine.this.updateWipControls();
                }
                EditContentEngine.this.setAvailableLanguages(result.getAvailabledLanguages());
                if (EditContentEngine.this.getSelectedLanguage() != null) {
                    EditContentEngine.this.langCodeGWTJahiaGetPropertiesResultMap.put(EditContentEngine.this.getSelectedLanguage(), result);
                }
                EditContentEngine.this.mixin = result.getMixin();
                EditContentEngine.this.choiceListInitializersValues = result.getInitializersValues();
                EditContentEngine.this.defaultValues = result.getDefaultValues();
                EditContentEngine.this.initTabs();
                EditContentEngine.this.tabs.addListener(Events.Select, (Listener)new Listener<ComponentEvent>(){

                    public void handleEvent(ComponentEvent event) {
                        EditContentEngine.this.fillCurrentTab();
                    }
                });
                EditContentEngine.this.fillCurrentTab();
                if (PermissionsUtils.isPermitted("jcr:modifyProperties", EditContentEngine.this.node) && !EditContentEngine.this.node.isLocked().booleanValue()) {
                    EditContentEngine.this.setButtonsEnabled(true);
                }
                EditContentEngine.this.loaded();
            }

            @Override
            public void onApplicationFailure(Throwable throwable) {
                Log.debug((String)"Cannot get properties", (Throwable)throwable);
                Info.display((String)Messages.get("label.error", "Error"), (String)throwable.getLocalizedMessage());
                EditContentEngine.this.closeEngine();
            }

            @Override
            public void onSessionExpired() {
                EditContentEngine.this.closeEngine();
            }
        });
    }

    @Override
    protected void onLanguageChange(GWTJahiaLanguage previous) {
        this.loading();
        this.handleLanguageChange(previous);
        GWTJahiaGetPropertiesResult result = this.langCodeGWTJahiaGetPropertiesResultMap.get(this.getSelectedLanguage());
        if (result == null) {
            this.loadProperties();
        } else {
            this.node = result.getNode();
            this.nodeTypes = result.getNodeTypes();
            this.properties = result.getProperties();
            this.currentLanguageBean = result.getCurrentLocale();
            this.fillCurrentTab();
            this.loaded();
        }
    }

    @Override
    public void setButtonsEnabled(boolean enabled) {
        for (BoxComponent button : this.buttons) {
            button.setEnabled(enabled);
        }
    }

    public String toString() {
        return this.node.getPath();
    }

    public void setWorkInProgressCheckedByDefault(boolean workInProgressCheckedByDefault) {
        this.workInProgressCheckedByDefault = workInProgressCheckedByDefault;
    }
}

