/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.data.RpcMap;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.content.util.ContentHelper;
import org.jahia.ajax.gwt.client.widget.contentengine.AbstractContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.ContentTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EditContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.SaveButtonItem;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.SidePanelTabItem;

public class UpdateButtonItem
extends SaveButtonItem {
    @Override
    protected void prepareAndSave(final AbstractContentEngine engine, boolean closeAfterSave) {
        HashSet<String> addedTypes = new HashSet<String>();
        HashSet<String> removedTypes = new HashSet<String>();
        for (TabItem tab : engine.getTabs().getItems()) {
            EditEngineTabItem item = (EditEngineTabItem)tab.getData("item");
            if (item instanceof ContentTabItem) {
                List<CheckBox> validLanguagesChecked;
                if (((ContentTabItem)item).isNodeNameFieldDisplayed()) {
                    Field<String> name = ((ContentTabItem)item).getName();
                    if (!name.isValid()) {
                        Window.alert((String)name.getErrorMessage());
                        engine.unmask();
                        engine.setButtonsEnabled(true);
                        return;
                    }
                    engine.setNodeName((String)name.getValue());
                    engine.getNode().setName(engine.getNodeName());
                }
                if ((validLanguagesChecked = ((ContentTabItem)item).getCheckedLanguagesCheckBox()) != null) {
                    boolean hasChanged;
                    List<GWTJahiaLanguage> siteLanguages = JahiaGWTParameters.getSiteLanguages();
                    List<String> invalidLanguages = engine.getNode().getInvalidLanguages();
                    ArrayList<String> newInvalidLanguages = new ArrayList<String>();
                    for (GWTJahiaLanguage gWTJahiaLanguage : siteLanguages) {
                        boolean found = false;
                        for (CheckBox validLang : validLanguagesChecked) {
                            if (!gWTJahiaLanguage.getLanguage().equals(validLang.getValueAttribute())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        newInvalidLanguages.add(gWTJahiaLanguage.getLanguage());
                    }
                    boolean bl = hasChanged = newInvalidLanguages.size() != invalidLanguages.size();
                    if (!hasChanged) {
                        for (String lang : newInvalidLanguages) {
                            if (invalidLanguages.contains(lang)) continue;
                            hasChanged = true;
                            break;
                        }
                    }
                    if (hasChanged) {
                        List<GWTJahiaNodePropertyValue> list;
                        ArrayList<String> arrayList = new ArrayList<String>(siteLanguages.size());
                        for (GWTJahiaLanguage gWTJahiaLanguage : siteLanguages) {
                            arrayList.add(gWTJahiaLanguage.getLanguage());
                        }
                        GWTJahiaNodeProperty gwtJahiaNodeProperty = new GWTJahiaNodeProperty();
                        gwtJahiaNodeProperty.setName("j:invalidLanguages");
                        gwtJahiaNodeProperty.setMultiple(true);
                        for (CheckBox value : validLanguagesChecked) {
                            if (!value.getValue().booleanValue()) continue;
                            arrayList.remove(value.getValueAttribute());
                        }
                        if (arrayList.size() > 0) {
                            gwtJahiaNodeProperty.setValues(new ArrayList<GWTJahiaNodePropertyValue>());
                            for (String string : arrayList) {
                                gwtJahiaNodeProperty.getValues().add(new GWTJahiaNodePropertyValue(string));
                            }
                        }
                        if ((list = gwtJahiaNodeProperty.getValues()) != null && list.size() > 0) {
                            engine.getChangedProperties().add(gwtJahiaNodeProperty);
                            addedTypes.add("jmix:i18n");
                        } else {
                            gwtJahiaNodeProperty.setValues(new ArrayList<GWTJahiaNodePropertyValue>());
                            engine.getChangedProperties().add(gwtJahiaNodeProperty);
                        }
                    }
                }
            }
            item.doSave(engine.getNode(), engine.getChangedProperties(), engine.getChangedI18NProperties(), addedTypes, removedTypes, null, engine.getAcl());
        }
        engine.getNode().getNodeTypes().removeAll(removedTypes);
        engine.getNode().getNodeTypes().addAll(addedTypes);
        engine.removeUneditedLanguages();
        JahiaContentManagementService.App.getInstance().saveNode(engine.getNode(), engine.getAcl(), engine.getChangedI18NProperties(), engine.getChangedProperties(), removedTypes, (AsyncCallback<RpcMap>)new BaseAsyncCallback<RpcMap>(){

            @Override
            public void onApplicationFailure(Throwable throwable) {
                UpdateButtonItem.this.failSave(engine, throwable);
            }

            public void onSuccess(RpcMap o) {
                Info.display((String)Messages.get("label.information", "Information"), (String)Messages.get("saved_prop", "Properties saved\n\n"));
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("refreshMain", true);
                data.put("forceImageRefresh", true);
                EditLinker editLinker = null;
                if (engine.getLinker() instanceof SidePanelTabItem.SidePanelLinker) {
                    editLinker = ((SidePanelTabItem.SidePanelLinker)engine.getLinker()).getEditLinker();
                } else if (engine.getLinker() instanceof EditLinker) {
                    editLinker = (EditLinker)engine.getLinker();
                }
                GWTJahiaNode node = engine.getNode();
                if (editLinker != null && node.equals(editLinker.getMainModule().getNode()) && !node.getName().equals(editLinker.getMainModule().getNode().getName())) {
                    editLinker.getMainModule().handleNewMainSelection(node.getPath().substring(0, node.getPath().lastIndexOf("/") + 1) + node.getName(), editLinker.getMainModule().getTemplate());
                }
                data.put("node", node);
                ((EditContentEngine)engine).closeEngine();
                if (o != null && o.containsKey("siteLanguages")) {
                    JahiaGWTParameters.getSiteNode().set("siteLanguages", o.get("siteLanguages"));
                    if (o.containsKey("permissions")) {
                        PermissionsUtils.loadPermissions((List)o.get("permissions"));
                    }
                }
                if (!engine.skipRefreshOnSave()) {
                    engine.getLinker().refresh(data);
                }
                ContentHelper.sendContentModificationEvent(node.getUUID(), node.getPath(), engine.getNodeName(), "update", null);
            }
        });
    }
}

