/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.EditorEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.RowEditorEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.Record;
import com.extjs.gxt.ui.client.store.Store;
import com.extjs.gxt.ui.client.store.StoreEvent;
import com.extjs.gxt.ui.client.store.StoreListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentPlugin;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.grid.CellEditor;
import com.extjs.gxt.ui.client.widget.grid.CheckColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.RowEditor;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.seo.GWTJahiaUrlMapping;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.URL;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;

public class UrlMappingEditor
extends LayoutContainer {
    private GWTJahiaNode node;
    private boolean editable;
    private String locale;
    private ListStore<GWTJahiaUrlMapping> store;

    public UrlMappingEditor(GWTJahiaNode node, String locale, boolean editable) {
        super((Layout)new FitLayout());
        this.locale = locale;
        this.node = node;
        this.editable = editable;
        this.setBorders(false);
        this.store = new ListStore();
        JahiaContentManagementService.App.getInstance().getUrlMappings(node, locale, (AsyncCallback<List<GWTJahiaUrlMapping>>)new BaseAsyncCallback<List<GWTJahiaUrlMapping>>(){

            @Override
            public void onApplicationFailure(Throwable throwable) {
                Window.alert((String)Messages.getWithArgs("failure.load.urlmappings.label", "Loading URL mapping failed\n\n{0}", new Object[]{throwable.getLocalizedMessage()}));
                Log.error((String)"failed", (Throwable)throwable);
            }

            public void onSuccess(List<GWTJahiaUrlMapping> mappings) {
                UrlMappingEditor.this.store.add(mappings);
            }
        });
    }

    public List<GWTJahiaUrlMapping> getMappings() {
        return this.store.getModels();
    }

    protected void onRender(Element parent, int index) {
        CheckColumnConfig activeColumn;
        CheckColumnConfig defaultColumn;
        super.onRender(parent, index);
        this.setHeight(610);
        ArrayList<Object> configs = new ArrayList<Object>();
        ColumnConfig column = new ColumnConfig();
        column.setId("url");
        column.setHeaderHtml(Messages.get("label_url", "URL"));
        TextField text = new TextField();
        text.setAllowBlank(false);
        text.setMaxLength(250);
        CellEditor ce = new CellEditor((Field)text);
        ce.addListener(Events.BeforeComplete, (Listener)new Listener<EditorEvent>(){

            public void handleEvent(EditorEvent be) {
                Window.alert((String)((String)be.getValue()));
                be.stopEvent();
            }
        });
        column.setEditor(ce);
        configs.add(column);
        if (this.editable) {
            defaultColumn = new CheckColumnConfig("default", Messages.get("label.urlmapping.default", "Default"), 70);
            defaultColumn.setEditor(new CellEditor((Field)new CheckBox()));
            activeColumn = new CheckColumnConfig("active", Messages.get("label.urlmapping.active", "Active"), 55);
            activeColumn.setEditor(new CellEditor((Field)new CheckBox()));
        } else {
            defaultColumn = new CheckColumnConfig("default", Messages.get("label.urlmapping.default", "Default"), 70){

                protected String getCheckState(ModelData model, String property, int rowIndex, int colIndex) {
                    return "-disabled";
                }
            };
            activeColumn = new CheckColumnConfig("active", Messages.get("label.urlmapping.active", "Active"), 55){

                protected String getCheckState(ModelData model, String property, int rowIndex, int colIndex) {
                    return "-disabled";
                }
            };
        }
        configs.add(defaultColumn);
        configs.add(activeColumn);
        column = new ColumnConfig("actions", "", 100);
        column.setAlignment(Style.HorizontalAlignment.CENTER);
        column.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaUrlMapping>(){

            public Object render(GWTJahiaUrlMapping modelData, String s, ColumnData columnData, final int rowIndex, int colIndex, ListStore<GWTJahiaUrlMapping> listStore, Grid<GWTJahiaUrlMapping> grid) {
                Button button = new Button(Messages.get("label_remove", "Remove"), (SelectionListener)new SelectionListener<ButtonEvent>(){

                    public void componentSelected(ButtonEvent buttonEvent) {
                        UrlMappingEditor.this.store.remove(UrlMappingEditor.this.store.getAt(rowIndex));
                    }
                });
                button.addStyleName("button-remove");
                button.setIcon(StandardIconsProvider.STANDARD_ICONS.minusRound());
                button.setEnabled(UrlMappingEditor.this.editable);
                return button;
            }
        });
        column.setFixed(true);
        configs.add(column);
        final RowEditor re = new RowEditor();
        re.addListener(Events.CancelEdit, (Listener)new Listener<RowEditorEvent>(){

            public void handleEvent(RowEditorEvent ree) {
                GWTJahiaUrlMapping urlMapping = (GWTJahiaUrlMapping)((Object)UrlMappingEditor.this.store.getModels().get(ree.getRowIndex()));
                if (urlMapping.getUrl().length() == 0) {
                    UrlMappingEditor.this.store.remove(ree.getRowIndex());
                }
            }
        });
        re.addListener(Events.ValidateEdit, (Listener)new Listener<RowEditorEvent>(){

            public void handleEvent(RowEditorEvent ree) {
                if (ree.getChanges().get("url").toString().matches("/sites")) {
                    ree.setCancelled(true);
                    UrlMappingEditor.this.store.remove(ree.getRowIndex());
                    Window.alert((String)Messages.get("label.urlmapping.error.contains.sites", "SEO Url should not contains /sites as it is used by the system."));
                }
            }
        });
        final Grid grid = new Grid(this.store, new ColumnModel(configs));
        grid.setAutoExpandColumn("url");
        grid.setBorders(true);
        grid.addPlugin((ComponentPlugin)defaultColumn);
        grid.addPlugin((ComponentPlugin)activeColumn);
        if (this.editable) {
            grid.addPlugin((ComponentPlugin)re);
        }
        this.store.addStoreListener((StoreListener)new StoreListener<GWTJahiaUrlMapping>(){

            public void storeUpdate(StoreEvent<GWTJahiaUrlMapping> se) {
                super.storeUpdate(se);
                if (se.getOperation() == Record.RecordUpdate.EDIT && ((GWTJahiaUrlMapping)se.getModel()).isDefault()) {
                    this.clearOtherDefaults((GWTJahiaUrlMapping)se.getModel(), (Store<? extends GWTJahiaUrlMapping>)se.getStore());
                }
            }

            private void clearOtherDefaults(GWTJahiaUrlMapping model, Store<? extends GWTJahiaUrlMapping> store) {
                for (GWTJahiaUrlMapping data : store.getModels()) {
                    if (!data.isDefault() || ((Object)((Object)data)).equals((Object)model)) continue;
                    grid.getStore().getRecord((ModelData)data).set(defaultColumn.getDataIndex(), (Object)Boolean.FALSE);
                }
            }
        });
        ToolBar toolBar = new ToolBar();
        Button add = new Button(Messages.get("label.add", "Add"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                re.stopEditing(false);
                GWTJahiaUrlMapping mapping = new GWTJahiaUrlMapping("", UrlMappingEditor.this.locale, UrlMappingEditor.this.store.getCount() == 0, true);
                UrlMappingEditor.this.store.insert((ModelData)mapping, 0);
                re.startEditing(UrlMappingEditor.this.store.indexOf((ModelData)mapping), true);
            }
        });
        add.addStyleName("button-add");
        add.setIcon(StandardIconsProvider.STANDARD_ICONS.plusRound());
        add.setEnabled(this.editable);
        toolBar.add((Component)add);
        if (URL.getServerBaseURL().startsWith("http://localhost:") || URL.getServerBaseURL().startsWith("https://localhost:")) {
            toolBar.add((Component)new FillToolItem());
            LabelField warningLabel = new LabelField(Messages.get("label.urlmapping.inactiveOnLocalhost", "URL mapping is inactive for server-name: localhost"));
            warningLabel.setStyleAttribute("color", "red");
            toolBar.add((Component)warningLabel);
        }
        ContentPanel cp = new ContentPanel((Layout)new FitLayout());
        cp.setHeadingHtml("<div class='seo-title'>" + Messages.get("ece_seo_urlMapping", "URL mapping") + "</div><div class='seo-title-path'>" + this.node.getUrl() + "</div>");
        cp.setTopComponent((Component)toolBar);
        cp.add((Widget)grid);
        this.setLayout((Layout)new FitLayout());
        this.add((Component)cp);
    }
}

