/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.data.BaseTreeLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.data.TreeLoader;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.Store;
import com.extjs.gxt.ui.client.store.StoreSorter;
import com.extjs.gxt.ui.client.store.TreeStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import com.extjs.gxt.ui.client.widget.treegrid.WidgetTreeGridCellRenderer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflow;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowTask;
import org.jahia.ajax.gwt.client.data.workflow.history.GWTJahiaWorkflowHistoryItem;
import org.jahia.ajax.gwt.client.data.workflow.history.GWTJahiaWorkflowHistoryProcess;
import org.jahia.ajax.gwt.client.data.workflow.history.GWTJahiaWorkflowHistoryTask;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;
import org.jahia.ajax.gwt.client.util.Formatter;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineContainer;
import org.jahia.ajax.gwt.client.widget.contentengine.EnginePanel;
import org.jahia.ajax.gwt.client.widget.poller.Poller;
import org.jahia.ajax.gwt.client.widget.poller.TaskEvent;
import org.jahia.ajax.gwt.client.widget.publication.PublicationWorkflow;
import org.jahia.ajax.gwt.client.widget.workflow.CustomWorkflow;
import org.jahia.ajax.gwt.client.widget.workflow.WorkflowActionDialog;
import org.jahia.ajax.gwt.client.widget.workflow.WorkflowDashboardEngine;

public class WorkflowHistoryPanel
extends LayoutContainer {
    private WorkflowDashboardEngine engine;
    private boolean dashboard = false;
    private Linker linker;
    private String nodeId;
    private String locale;
    private Poller.PollListener<TaskEvent> listener;

    public WorkflowHistoryPanel(String nodeId, String locale) {
        super((Layout)new FitLayout());
        this.nodeId = nodeId;
        this.locale = locale;
        this.init();
    }

    public WorkflowHistoryPanel(WorkflowDashboardEngine engine, Linker linker) {
        super((Layout)new FitLayout());
        this.dashboard = true;
        this.linker = linker;
        this.engine = engine;
        this.init();
    }

    private void init() {
        this.setBorders(false);
        this.removeAll();
        final JahiaContentManagementServiceAsync service = JahiaContentManagementService.App.getInstance();
        RpcProxy<List<GWTJahiaWorkflowHistoryItem>> proxy = new RpcProxy<List<GWTJahiaWorkflowHistoryItem>>(){

            protected void load(Object loadConfig, AsyncCallback<List<GWTJahiaWorkflowHistoryItem>> callback) {
                if (loadConfig == null) {
                    if (WorkflowHistoryPanel.this.dashboard) {
                        service.getWorkflowHistoryForUser(callback);
                    } else {
                        service.getWorkflowHistoryProcesses(WorkflowHistoryPanel.this.nodeId, WorkflowHistoryPanel.this.locale, callback);
                    }
                } else if (loadConfig instanceof GWTJahiaWorkflowHistoryProcess) {
                    GWTJahiaWorkflowHistoryProcess process = (GWTJahiaWorkflowHistoryProcess)((Object)loadConfig);
                    service.getWorkflowHistoryTasks(process.getProvider(), process.getProcessId(), callback);
                } else {
                    callback.onSuccess(new ArrayList());
                }
            }
        };
        BaseTreeLoader<GWTJahiaWorkflowHistoryItem> loader = new BaseTreeLoader<GWTJahiaWorkflowHistoryItem>((DataProxy)proxy){

            public boolean hasChildren(GWTJahiaWorkflowHistoryItem parent) {
                return parent instanceof GWTJahiaWorkflowHistoryProcess;
            }
        };
        final TreeStore store = new TreeStore((TreeLoader)loader);
        store.setStoreSorter((StoreSorter)new StoreSorter<GWTJahiaWorkflowHistoryItem>(){

            public int compare(Store<GWTJahiaWorkflowHistoryItem> store, GWTJahiaWorkflowHistoryItem m1, GWTJahiaWorkflowHistoryItem m2, String property) {
                return m1.getStartDate().compareTo(m2.getStartDate());
            }
        });
        ArrayList<ColumnConfig> config = new ArrayList<ColumnConfig>();
        ColumnConfig column = new ColumnConfig("displayName", Messages.get("label.name", "Name"), 160);
        column.setRenderer((GridCellRenderer)new WidgetTreeGridCellRenderer<GWTJahiaWorkflowHistoryItem>(){

            public Widget getWidget(GWTJahiaWorkflowHistoryItem historyItem, String property, ColumnData config, int rowIndex, int colIndex, ListStore<GWTJahiaWorkflowHistoryItem> gwtJahiaWorkflowHistoryItemListStore, Grid<GWTJahiaWorkflowHistoryItem> grid) {
                if (WorkflowHistoryPanel.this.dashboard && historyItem instanceof GWTJahiaWorkflowHistoryTask) {
                    final GWTJahiaWorkflowHistoryProcess parent = (GWTJahiaWorkflowHistoryProcess)((TreeGrid)grid).getTreeStore().getParent((ModelData)historyItem);
                    for (final GWTJahiaWorkflowTask task : parent.getAvailableTasks()) {
                        if (!task.getId().equals(historyItem.getId())) continue;
                        Button b = new Button((String)historyItem.get("displayName"));
                        b.addStyleName("button-details");
                        b.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                            public void componentSelected(ButtonEvent ce) {
                                EnginePanel container = new EnginePanel();
                                CustomWorkflow customWorkflowInfo = parent.getRunningWorkflow().getCustomWorkflowInfo();
                                String path = "";
                                if (customWorkflowInfo instanceof PublicationWorkflow && ((PublicationWorkflow)customWorkflowInfo).getPublicationInfos().size() > 0) {
                                    path = ((PublicationWorkflow)customWorkflowInfo).getPublicationInfos().get(0).getMainPath();
                                }
                                new WorkflowActionDialog(path, parent.getRunningWorkflow(), task, WorkflowHistoryPanel.this.linker, customWorkflowInfo, (EngineContainer)container);
                                container.showEngine();
                                container.addListener(Events.Close, (Listener)new Listener<BaseEvent>(){

                                    public void handleEvent(BaseEvent be) {
                                        WorkflowHistoryPanel.this.engine.show();
                                        WorkflowHistoryPanel.this.init();
                                        WorkflowHistoryPanel.this.layout(true);
                                    }
                                });
                                WorkflowHistoryPanel.this.engine.hide();
                            }
                        });
                        return b;
                    }
                }
                return new Label((String)historyItem.get("displayName"));
            }
        });
        config.add(column);
        column = new ColumnConfig("locale", 40);
        column.setRenderer((GridCellRenderer)new GridCellRenderer<ModelData>(){

            public Object render(ModelData historyItem, String property, ColumnData config, int rowIndex, int colIndex, ListStore<ModelData> store, Grid<ModelData> grid) {
                String lang;
                if (WorkflowHistoryPanel.this.dashboard && historyItem.get("workflow") instanceof GWTJahiaWorkflow && (lang = (String)((GWTJahiaWorkflow)historyItem.get("workflow")).get("locale")) != null && JahiaGWTParameters.getLanguage(lang) != null) {
                    return "<img src=\"" + JahiaGWTParameters.getLanguage(lang).getImage() + "\"/>&nbsp;";
                }
                return "";
            }
        });
        config.add(column);
        column = new ColumnConfig("user", Messages.get("label.user", "User"), 70);
        config.add(column);
        column = new ColumnConfig("nodeWrapper", Messages.get("label.workflow.start.node", "Workflow Starting Node"), 200);
        column.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaWorkflowHistoryItem>(){

            public Object render(GWTJahiaWorkflowHistoryItem model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<GWTJahiaWorkflowHistoryItem> store, Grid<GWTJahiaWorkflowHistoryItem> grid) {
                GWTJahiaNode wrapper = (GWTJahiaNode)model.getProperties().get("nodeWrapper");
                if (wrapper != null) {
                    return new Label(wrapper.getDisplayName() + " (" + wrapper.getPath() + ")");
                }
                List models = store.getModels();
                for (GWTJahiaWorkflowHistoryItem historyItem : models) {
                    final GWTJahiaNode nodewrapper = (GWTJahiaNode)historyItem.getProperties().get("nodeWrapper");
                    if (nodewrapper == null || !historyItem.getProcessId().equals(model.getProcessId()) || !(historyItem instanceof GWTJahiaWorkflowHistoryProcess)) continue;
                    ButtonBar buttonBar = new ButtonBar();
                    Button previewButton = new Button(Messages.get("label.preview"));
                    previewButton.addStyleName("button-preview");
                    previewButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                        public void componentSelected(ButtonEvent ce) {
                            String path = nodewrapper.getPath();
                            String locale = JahiaGWTParameters.getLanguage();
                            JahiaContentManagementService.App.getInstance().getNodeURL("render", path, null, null, "default", locale, false, (AsyncCallback<String>)new BaseAsyncCallback<String>(){

                                public void onSuccess(String url) {
                                    Window window = new Window();
                                    window.addStyleName("content-preview");
                                    window.setMaximizable(true);
                                    window.setSize(800, 600);
                                    window.setUrl(url);
                                    window.setPosition(((WorkflowHistoryPanel)WorkflowHistoryPanel.this).engine.getPosition((boolean)true).x + 50, ((WorkflowHistoryPanel)WorkflowHistoryPanel.this).engine.getPosition((boolean)true).y + 50);
                                    window.show();
                                }
                            });
                        }
                    });
                    buttonBar.add((Component)previewButton);
                    Button inContextButton = new Button(Messages.get("label.preview.context"));
                    inContextButton.addStyleName("button-incontext-preview");
                    inContextButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                        public void componentSelected(ButtonEvent ce) {
                            String path = nodewrapper.getPath();
                            String locale = JahiaGWTParameters.getLanguage();
                            JahiaContentManagementService.App.getInstance().getNodeURL("render", path, null, null, "default", locale, true, (AsyncCallback<String>)new BaseAsyncCallback<String>(){

                                public void onSuccess(String url) {
                                    Window window = new Window();
                                    window.addStyleName("content-incontext-preview");
                                    window.setMaximizable(true);
                                    window.setSize(1000, 750);
                                    window.setUrl(url);
                                    window.setPosition(((WorkflowHistoryPanel)WorkflowHistoryPanel.this).engine.getPosition((boolean)true).x + 50, ((WorkflowHistoryPanel)WorkflowHistoryPanel.this).engine.getPosition((boolean)true).y + 50);
                                    window.show();
                                }
                            });
                        }
                    });
                    buttonBar.add((Component)inContextButton);
                    return buttonBar;
                }
                return new Label("");
            }
        });
        config.add(column);
        column = new ColumnConfig("startDate", Messages.get("org.jahia.engines.processDisplay.tab.startdate", "Start date"), 90);
        column.setDateTimeFormat(Formatter.DEFAULT_DATETIME_FORMAT);
        config.add(column);
        column = new ColumnConfig("endDate", Messages.get("org.jahia.engines.processDisplay.tab.enddate", "End date"), 90);
        column.setDateTimeFormat(Formatter.DEFAULT_DATETIME_FORMAT);
        config.add(column);
        column = new ColumnConfig("duration", Messages.get("org.jahia.engines.processDisplay.column.duration", "Duration"), 60);
        column.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaWorkflowHistoryItem>(){

            public Object render(GWTJahiaWorkflowHistoryItem historyItem, String property, ColumnData config, int rowIndex, int colIndex, ListStore<GWTJahiaWorkflowHistoryItem> store, Grid<GWTJahiaWorkflowHistoryItem> grid) {
                Long duration = historyItem.getDuration();
                String display = "-";
                if (duration != null) {
                    long time = duration;
                    display = time < 1000L ? time + " " + Messages.get("label.milliseconds", "ms") : (time < 60000L ? time / 1000L + " " + Messages.get("label.seconds", "sec") : (time < 3600000L ? time / 60000L + " " + Messages.get("label.minutes", "min") + " " + time % 60000L / 1000L + " " + Messages.get("label.seconds", "sec") : time / 3600000L + " " + Messages.get("label_hours", "h") + " " + time % 3600000L / 60000L + " " + Messages.get("label.minutes", "min")));
                }
                return new Label(display);
            }
        });
        config.add(column);
        if (PermissionsUtils.isPermitted("viewWorkflowTab", JahiaGWTParameters.getSiteNode().getPermissions())) {
            column = new ColumnConfig("operation", Messages.get("label.operation", "Operation"), 100);
            column.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaWorkflowHistoryItem>((TreeLoader)loader){
                final /* synthetic */ TreeLoader val$loader;
                {
                    this.val$loader = treeLoader;
                }

                public Object render(final GWTJahiaWorkflowHistoryItem model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<GWTJahiaWorkflowHistoryItem> gwtJahiaWorkflowHistoryItemListStore, Grid<GWTJahiaWorkflowHistoryItem> gwtJahiaWorkflowHistoryItemGrid) {
                    if (model instanceof GWTJahiaWorkflowHistoryProcess && !((GWTJahiaWorkflowHistoryProcess)model).isFinished()) {
                        Button button = new Button(Messages.get("label.abort", "Abort"));
                        button.addStyleName("button-abort");
                        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                            public void componentSelected(ButtonEvent ce) {
                                JahiaContentManagementService.App.getInstance().abortWorkflow(model.getId(), model.getProvider(), new BaseAsyncCallback<String>(){

                                    public void onSuccess(String url) {
                                        store.removeAll();
                                        val$loader.load();
                                    }
                                });
                            }
                        });
                        button.setIcon(StandardIconsProvider.STANDARD_ICONS.delete());
                        return button;
                    }
                    return new Label("");
                }
            });
            config.add(column);
        }
        ColumnModel cm = new ColumnModel(config);
        TreeGrid tree = new TreeGrid(store, cm);
        tree.setStateful(true);
        tree.setBorders(true);
        tree.getStyle().setNodeOpenIcon(StandardIconsProvider.STANDARD_ICONS.workflow());
        tree.getStyle().setNodeCloseIcon(StandardIconsProvider.STANDARD_ICONS.workflow());
        tree.getStyle().setLeafIcon(StandardIconsProvider.STANDARD_ICONS.workflowTask());
        tree.setAutoExpandColumn("displayName");
        tree.getTreeView().setRowHeight(25);
        tree.setTrackMouseOver(false);
        tree.setAutoExpandMax(5000);
        this.add((Component)tree);
        this.listener = new Poller.PollListener<TaskEvent>(){

            @Override
            public void handlePollingResult(TaskEvent result) {
                if (result.getEndedTask() != null) {
                    for (GWTJahiaWorkflowHistoryItem item : new ArrayList(store.getAllItems())) {
                        if (item instanceof GWTJahiaWorkflowHistoryProcess) {
                            for (GWTJahiaWorkflowTask task : new ArrayList<GWTJahiaWorkflowTask>(item.getAvailableTasks())) {
                                if (!task.getId().equals(result.getEndedTask())) continue;
                                item.getAvailableTasks().remove(task);
                            }
                            if (!item.getAvailableTasks().isEmpty()) continue;
                            store.remove((ModelData)item);
                            continue;
                        }
                        if (!(item instanceof GWTJahiaWorkflowHistoryTask) || !item.getId().equals(result.getEndedTask())) continue;
                        store.remove((ModelData)item);
                    }
                }
            }
        };
        Poller.getInstance().registerListener(this.listener, TaskEvent.class);
        if (this.engine != null) {
            this.engine.addListener(Events.Hide, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    if (WorkflowHistoryPanel.this.listener != null) {
                        Poller.getInstance().unregisterListener(WorkflowHistoryPanel.this.listener, TaskEvent.class);
                    }
                }
            });
        }
    }
}

