/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.event.TreeGridEvent;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineLoader;
import org.jahia.ajax.gwt.client.widget.edit.ContentTypeTree;

public class ContentTypeWindow
extends Window {
    private GWTJahiaNode parentNode;
    private final Linker linker;
    private ButtonBar buttonBar;
    private Button ok;
    private Button cancel;
    private ContentTypeTree contentTypeTree;

    public ContentTypeWindow(final Linker linker, GWTJahiaNode parent, List<GWTJahiaNodeType> components, final Map<String, GWTJahiaNodeProperty> props, final String nodeName, final boolean createInParentAndMoveBefore, final boolean skipRefreshOnSave, final boolean systemNameReadOnly) {
        this.addStyleName("content-type-window");
        this.linker = linker;
        this.parentNode = parent;
        this.setLayout((Layout)new FitLayout());
        this.setBodyBorder(false);
        this.setSize(400, 650);
        this.setClosable(true);
        this.setResizable(true);
        this.setModal(true);
        this.setMaximizable(true);
        this.contentTypeTree = new ContentTypeTree();
        this.contentTypeTree.fillStore(components);
        TreeGrid<GWTJahiaNodeType> treeGrid = this.contentTypeTree.getTreeGrid();
        treeGrid.sinkEvents(3);
        treeGrid.addListener(Events.OnDoubleClick, (Listener)new Listener<TreeGridEvent<GWTJahiaNodeType>>(){

            public void handleEvent(TreeGridEvent<GWTJahiaNodeType> baseEvent) {
                GWTJahiaNodeType gwtJahiaNodeType = (GWTJahiaNodeType)baseEvent.getModel();
                if (gwtJahiaNodeType != null && linker != null && !gwtJahiaNodeType.isMixin()) {
                    EngineLoader.showCreateEngine(linker, ContentTypeWindow.this.parentNode, gwtJahiaNodeType, props, nodeName, createInParentAndMoveBefore, null, skipRefreshOnSave, systemNameReadOnly);
                    ContentTypeWindow.this.hide();
                }
            }
        });
        this.add((Component)this.contentTypeTree);
        this.setFocusWidget((Widget)this.contentTypeTree.getNameFilterField());
        this.contentTypeTree.layout(true);
        this.layout();
        LayoutContainer buttonsPanel = new LayoutContainer();
        buttonsPanel.setBorders(false);
        final ContentTypeWindow window = this;
        this.buttonBar = new ButtonBar();
        this.buttonBar.setAlignment(Style.HorizontalAlignment.CENTER);
        this.ok = new Button(Messages.get("label.ok"));
        this.ok.addStyleName("button-save");
        this.ok.setHeight(24);
        this.ok.setEnabled(false);
        this.ok.setIcon(StandardIconsProvider.STANDARD_ICONS.engineButtonOK());
        this.ok.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent buttonEvent) {
                GWTJahiaNodeType selectedItem = (GWTJahiaNodeType)ContentTypeWindow.this.contentTypeTree.getTreeGrid().getSelectionModel().getSelectedItem();
                if (selectedItem != null && !selectedItem.isMixin()) {
                    EngineLoader.showCreateEngine(ContentTypeWindow.this.linker, ContentTypeWindow.this.parentNode, selectedItem, props, nodeName, createInParentAndMoveBefore, null, skipRefreshOnSave, systemNameReadOnly);
                    window.hide();
                }
            }
        });
        this.buttonBar.add((Component)this.ok);
        this.cancel = new Button(Messages.get("label.cancel"));
        this.cancel.setHeight(24);
        this.cancel.addStyleName("button-cancel");
        this.cancel.setIcon(StandardIconsProvider.STANDARD_ICONS.engineButtonCancel());
        this.cancel.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent buttonEvent) {
                window.hide();
            }
        });
        this.buttonBar.add((Component)this.cancel);
        buttonsPanel.add((Widget)this.buttonBar);
        this.setBottomComponent((Component)buttonsPanel);
        this.setFooter(true);
        this.ok.setEnabled(true);
    }

    public static void createContent(Linker linker, String name, List<String> nodeTypes, Map<String, GWTJahiaNodeProperty> props, GWTJahiaNode targetNode, boolean includeSubTypes, boolean createInParentAndMoveBefore) {
        ContentTypeWindow.createContent(linker, name, nodeTypes, props, targetNode, includeSubTypes, createInParentAndMoveBefore, null, false);
    }

    public static void createContent(Linker linker, String name, List<String> nodeTypes, Map<String, GWTJahiaNodeProperty> props, GWTJahiaNode targetNode, boolean includeSubTypes, boolean createInParentAndMoveBefore, Set<String> displayedNodeTypes, boolean skipRefreshOnSave) {
        ContentTypeWindow.createContent(linker, name, nodeTypes, props, targetNode, includeSubTypes, createInParentAndMoveBefore, displayedNodeTypes, skipRefreshOnSave, false);
    }

    public static void createContent(final Linker linker, final String name, final List<String> nodeTypes, final Map<String, GWTJahiaNodeProperty> props, final GWTJahiaNode targetNode, boolean includeSubTypes, final boolean createInParentAndMoveBefore, final Set<String> displayedNodeTypes, final boolean skipRefreshOnSave, final boolean systemNameReadOnly) {
        linker.loading(Messages.get("label.loading", "Loading"));
        ArrayList<String> excluded = new ArrayList<String>();
        if (linker.getConfig().getNonEditableTypes() != null) {
            excluded.addAll(linker.getConfig().getNonEditableTypes());
        }
        if (linker.getConfig().getNonVisibleTypes() != null) {
            excluded.addAll(linker.getConfig().getNonVisibleTypes());
        }
        if (linker.getConfig().getExcludedNodeTypes() != null) {
            excluded.addAll(linker.getConfig().getExcludedNodeTypes());
        }
        JahiaContentManagementService.App.getInstance().getContentTypesAsTree(nodeTypes, excluded, includeSubTypes, (AsyncCallback<List<GWTJahiaNodeType>>)new BaseAsyncCallback<List<GWTJahiaNodeType>>(){

            public void onSuccess(List<GWTJahiaNodeType> result) {
                linker.loaded();
                if (result.size() == 1 && result.get(0).getChildren().isEmpty()) {
                    EngineLoader.showCreateEngine(linker, targetNode, result.get(0), props, name, createInParentAndMoveBefore, null, skipRefreshOnSave, systemNameReadOnly);
                } else {
                    GWTJahiaNodeType targetNodeType;
                    if (nodeTypes != null && nodeTypes.size() == 1 && displayedNodeTypes != null && (targetNodeType = this.getTargetNodeType((String)nodeTypes.get(0), result, (Set<String>)displayedNodeTypes)) != null) {
                        EngineLoader.showCreateEngine(linker, targetNode, targetNodeType, props, name, createInParentAndMoveBefore, null, skipRefreshOnSave, systemNameReadOnly);
                        return;
                    }
                    new ContentTypeWindow(linker, targetNode, result, props, name, createInParentAndMoveBefore, skipRefreshOnSave, systemNameReadOnly).show();
                }
            }

            @Override
            public void onFailure(Throwable caught) {
                linker.loaded();
                super.onFailure(caught);
            }

            private GWTJahiaNodeType getTargetNodeType(String nodeTypeName, List<GWTJahiaNodeType> result, Set<String> displayedNodeTypes2) {
                GWTJahiaNodeType targetNodeType = null;
                for (GWTJahiaNodeType nd : result) {
                    Object[] target = this.getTargetNodeType(nodeTypeName, nd, displayedNodeTypes2);
                    if (!((Boolean)target[0]).booleanValue()) {
                        return null;
                    }
                    if (targetNodeType != null || target[1] == null) continue;
                    targetNodeType = (GWTJahiaNodeType)target[1];
                }
                return targetNodeType;
            }

            private Object[] getTargetNodeType(String nodeTypeName, GWTJahiaNodeType startNode, Set<String> displayedNodeTypes2) {
                boolean sinlgeTarget = true;
                GWTJahiaNodeType targetNodeType = null;
                if (startNode.getChildren().size() > 0) {
                    for (ModelData child : startNode.getChildren()) {
                        Object[] result = this.getTargetNodeType(nodeTypeName, (GWTJahiaNodeType)child, displayedNodeTypes2);
                        if (!((Boolean)result[0]).booleanValue()) {
                            return result;
                        }
                        if (targetNodeType != null || result[1] == null) continue;
                        targetNodeType = (GWTJahiaNodeType)result[1];
                    }
                } else if (!startNode.isMixin()) {
                    if (nodeTypeName.equals(startNode.getName())) {
                        targetNodeType = startNode;
                    }
                    if (!displayedNodeTypes2.contains(startNode.getName())) {
                        sinlgeTarget = false;
                    }
                }
                return new Object[]{sinlgeTarget, targetNodeType};
            }
        });
    }
}

