/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.mainarea;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.dnd.DND;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.util.content.CopyPasteEngine;
import org.jahia.ajax.gwt.client.util.content.actions.ContentActions;
import org.jahia.ajax.gwt.client.util.icons.ContentModelIconProvider;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.AreaModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Module;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.ModuleDropTarget;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.ModuleHelper;

public class PlaceholderModule
extends Module {
    private LayoutContainer panel;
    private LayoutContainer pasteButton;
    private LayoutContainer pasteAsReferenceButton;
    private static int MIN_WIDTH = 100;

    public PlaceholderModule(String id, String path, Element divElement, MainModule mainModule) {
        super(id, path, divElement, mainModule, (Layout)new FlowLayout());
        if (path.endsWith("*")) {
            this.setBorders(false);
        } else {
            this.setBorders(true);
        }
        this.html = new HTML("");
    }

    @Override
    public void onParsed() {
        this.panel = new LayoutContainer((Layout)new RowLayout(Style.Orientation.VERTICAL));
        this.add((Component)this.panel);
    }

    @Override
    public void onNodeTypesLoaded() {
        if (this.mainModule.getConfig().isDragAndDropEnabled()) {
            ModuleDropTarget target = new ModuleDropTarget(this, "placeholder");
            target.setOperation(DND.Operation.COPY);
            target.setFeedback(DND.Feedback.INSERT);
            target.addDNDListener(this.mainModule.getEditLinker().getDndListener());
        }
        if (this.getParentModule().getChildCount() >= this.getParentModule().getListLimit() && this.getParentModule().getListLimit() != -1) {
            return;
        }
        if (this.getParentModule() instanceof AreaModule && this.getParentModule().getChildCount() == 0 && ((AreaModule)this.getParentModule()).editable) {
            ((AreaModule)this.getParentModule()).setEnabledEmptyArea();
        }
        String[] nodeTypesArray = null;
        if (this.getParentModule() != null && this.getParentModule().getNodeTypes() != null) {
            nodeTypesArray = this.getParentModule().getNodeTypes().split(" ");
        }
        if (this.getNodeTypes() != null && this.getNodeTypes().length() > 0) {
            nodeTypesArray = this.getNodeTypes().split(" ");
        }
        if (nodeTypesArray != null) {
            List<String> filter = null;
            if (this.nodeTypes != null && this.nodeTypes.length() > 0) {
                filter = Arrays.asList(this.nodeTypes.split(" "));
            }
            final HashSet<String> displayedNodeTypes = new HashSet<String>(Arrays.asList(nodeTypesArray));
            for (final String s : nodeTypesArray) {
                Boolean canUseComponentForCreate;
                GWTJahiaNodeType nodeType;
                if (filter != null && !filter.contains(s) || (nodeType = ModuleHelper.getNodeType(s)) != null && (canUseComponentForCreate = (Boolean)nodeType.get("canUseComponentForCreate")) != null && !canUseComponentForCreate.booleanValue()) continue;
                Image icon = ContentModelIconProvider.getInstance().getIcon(nodeType).createImage();
                icon.setTitle(nodeType != null ? nodeType.getLabel() : s);
                HorizontalPanel p = new HorizontalPanel();
                p.add((Widget)icon);
                Text label = new Text(nodeType != null ? nodeType.getLabel() : s);
                if (this.getWidth() >= MIN_WIDTH || this.getWidth() == 0) {
                    p.add((Widget)label);
                } else {
                    p.setTitle(label.getText());
                }
                p.sinkEvents(1);
                p.addStyleName("button-placeholder");
                p.addListener(Events.OnClick, (Listener)new Listener<ComponentEvent>(){

                    public void handleEvent(ComponentEvent be) {
                        GWTJahiaNode parentNode = PlaceholderModule.this.getParentModule().getNode();
                        if (parentNode != null && PermissionsUtils.isPermitted("jcr:addChildNodes", parentNode) && (!parentNode.isLocked().booleanValue() || parentNode.isLockAllowsAdd().booleanValue())) {
                            String nodeName = null;
                            if (PlaceholderModule.this.path != null && !"*".equals(PlaceholderModule.this.path) && !PlaceholderModule.this.path.startsWith("/")) {
                                nodeName = PlaceholderModule.this.path;
                            }
                            ContentActions.showContentWizard(PlaceholderModule.this.mainModule.getEditLinker(), s, parentNode, nodeName, true, displayedNodeTypes, false, nodeName != null);
                        }
                    }
                });
                this.panel.add((Widget)p, (LayoutData)new RowData());
            }
            Image icon = ToolbarIconProvider.getInstance().getIcon("paste").createImage();
            icon.setTitle(Messages.get("label.paste", "Paste"));
            this.pasteButton = new HorizontalPanel();
            this.pasteButton.add((Widget)icon);
            Text pasteLabel = new Text(Messages.get("label.paste", "Paste"));
            if (this.getWidth() >= MIN_WIDTH) {
                this.pasteButton.add((Widget)pasteLabel);
            } else {
                this.pasteButton.setTitle(pasteLabel.getTitle());
            }
            this.pasteButton.sinkEvents(1);
            this.pasteButton.addStyleName("button-placeholder");
            this.pasteButton.addListener(Events.OnClick, (Listener)new Listener<ComponentEvent>(){

                public void handleEvent(ComponentEvent be) {
                    GWTJahiaNode parentNode = PlaceholderModule.this.getParentModule().getNode();
                    if (parentNode != null && PermissionsUtils.isPermitted("jcr:addChildNodes", parentNode) && (!parentNode.isLocked().booleanValue() || parentNode.isLockAllowsAdd().booleanValue())) {
                        String nodeName = null;
                        if (PlaceholderModule.this.path != null && !"*".equals(PlaceholderModule.this.path) && !PlaceholderModule.this.path.startsWith("/")) {
                            nodeName = PlaceholderModule.this.path;
                        }
                        CopyPasteEngine.getInstance().paste(parentNode, PlaceholderModule.this.mainModule.getEditLinker(), null, nodeName);
                    }
                }
            });
            AbstractImagePrototype pasteAsReferenceIcon = ToolbarIconProvider.getInstance().getIcon("pasteReference");
            this.pasteAsReferenceButton = new HorizontalPanel();
            this.pasteAsReferenceButton.add((Widget)pasteAsReferenceIcon.createImage());
            Text pasteReferenceLabel = new Text(Messages.get("label.pasteReference", "Paste Reference"));
            if (this.getWidth() >= MIN_WIDTH) {
                this.pasteAsReferenceButton.add((Widget)pasteReferenceLabel);
            } else {
                this.pasteAsReferenceButton.setTitle(pasteReferenceLabel.getTitle());
            }
            this.pasteAsReferenceButton.sinkEvents(1);
            this.pasteAsReferenceButton.addStyleName("button-placeholder");
            this.pasteAsReferenceButton.addListener(Events.OnClick, (Listener)new Listener<ComponentEvent>(){

                public void handleEvent(ComponentEvent be) {
                    GWTJahiaNode parentNode = PlaceholderModule.this.getParentModule().getNode();
                    if (parentNode != null && PermissionsUtils.isPermitted("jcr:addChildNodes", parentNode) && (!parentNode.isLocked().booleanValue() || parentNode.isLockAllowsAdd().booleanValue())) {
                        CopyPasteEngine.getInstance().pasteReference(parentNode, PlaceholderModule.this.mainModule.getEditLinker());
                    }
                }
            });
            CopyPasteEngine.getInstance().addPlaceholder(this);
            this.updatePasteButton();
            this.panel.add((Widget)this.pasteButton, (LayoutData)new RowData());
            this.panel.add((Widget)this.pasteAsReferenceButton, (LayoutData)new RowData());
            this.panel.layout();
        }
    }

    @Override
    public boolean isDraggable() {
        return false;
    }

    @Override
    public void setParentModule(Module parentModule) {
        this.parentModule = parentModule;
    }

    public void updatePasteButton() {
        String restrictToNodeTypes;
        String string = restrictToNodeTypes = this.getNodeTypes() != null && !this.getNodeTypes().isEmpty() ? this.getNodeTypes() : this.parentModule.getNodeTypes();
        if (!CopyPasteEngine.getInstance().getCopiedNodes().isEmpty()) {
            this.pasteButton.setVisible(CopyPasteEngine.getInstance().checkNodeType(restrictToNodeTypes, false) && CopyPasteEngine.getInstance().canCopyTo(this.getParentModule().getNode()));
            this.pasteAsReferenceButton.setVisible(CopyPasteEngine.getInstance().checkNodeType(restrictToNodeTypes, true) && CopyPasteEngine.getInstance().canPasteAsReference() && this.parentModule.isAllowReferences() && this.isAllowReferences());
        } else {
            this.pasteButton.setVisible(false);
            this.pasteAsReferenceButton.setVisible(false);
        }
    }
}

