/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.form;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.core.Template;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.fx.FxConfig;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentHelper;
import com.extjs.gxt.ui.client.widget.ComponentPlugin;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.WidgetComponent;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.RowNumberer;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.menu.CheckMenuItem;
import com.extjs.gxt.ui.client.widget.tips.ToolTipConfig;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.wcag.WCAGValidationResult;
import org.jahia.ajax.gwt.client.data.wcag.WCAGViolation;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.widget.ckeditor.CKEditor;
import org.jahia.ajax.gwt.client.widget.ckeditor.CKEditorConfig;

public class CKEditorField
extends Field<String> {
    private static Map<String, CKEditorField> instances = new HashMap<String, CKEditorField>();
    protected CKEditor ckeditor;
    protected Html html;
    protected ContentPanel panel;
    private boolean resizeWidget;
    private WCAGValidationResult wcagValidationResult;
    private ContentPanel wcagPanel;
    private boolean ignoreWcagWarnings;
    private String lastValidatedContent;
    private boolean allowBlank = true;
    private String blankText = GXT.MESSAGES.textField_blankText();

    public CKEditorField() {
        this(null);
    }

    public boolean getAllowBlank() {
        return this.allowBlank;
    }

    public void setAllowBlank(boolean allowBlank) {
        this.allowBlank = allowBlank;
    }

    public CKEditorField(CKEditorConfig config) {
        this.ckeditor = new CKEditor(config, this);
        this.html = new Html();
        this.html.setStyleAttribute("overflow", "scroll");
    }

    public Component getComponent() {
        return this.readOnly ? this.html : this.ckeditor;
    }

    public Element getElement() {
        return this.getComponent().getElement();
    }

    public boolean isAttached() {
        if (this.getComponent() != null) {
            return this.getComponent().isAttached();
        }
        return false;
    }

    public boolean isResizeWidget() {
        return this.resizeWidget;
    }

    public void onBrowserEvent(Event event) {
        super.onBrowserEvent(event);
        this.getComponent().onBrowserEvent(event);
    }

    public void setResizeWidget(boolean resizeWidget) {
        this.resizeWidget = resizeWidget;
    }

    protected void onAttach() {
        ComponentHelper.doAttach((Widget)this.getComponent());
        DOM.setEventListener((Element)this.getElement(), (EventListener)this);
        this.onLoad();
    }

    public void onBlur() {
        super.onBlur(null);
    }

    public void onFocus() {
        super.onFocus(null);
    }

    protected void onDetach() {
        try {
            this.onUnload();
        }
        finally {
            ComponentHelper.doDetach((Widget)this.getComponent());
        }
        this.onDetachHelper();
    }

    protected void onDisable() {
        super.onDisable();
        this.getComponent().disable();
    }

    protected void onEnable() {
        super.onEnable();
        this.getComponent().enable();
    }

    protected void onRender(Element target, int index) {
        Component component = this.getComponent();
        this.ckeditor.setName(this.name);
        if (!component.isRendered()) {
            component.render(target, index);
        }
        this.setElement(component.getElement(), target, index);
        if (GXT.isAriaEnabled() && !this.getAllowBlank()) {
            this.setAriaState("aria-required", "true");
        }
    }

    public void afterCKEditorInstanceReady() {
        String instanceId = this.ckeditor.getInstanceId();
        if (instanceId != null) {
            instances.put(instanceId, this);
        } else {
            Log.warn((String)"CKEditor instance ID is null. Unable to store the reference to this instance of the CKEditorField");
        }
    }

    public void clearInvalid() {
        this.getInputEl().getParent().removeStyleName(this.invalidStyle);
        super.clearInvalid();
    }

    public void markInvalid(String msg) {
        this.getInputEl().getParent().addStyleName(new String[]{this.invalidStyle});
        if (!"side".equals(this.getMessageTarget())) {
            super.markInvalid(msg);
        } else {
            if (this.errorIcon == null) {
                this.errorIcon = new WidgetComponent((Widget)this.getImages().getInvalid().createImage());
                Element p = this.el().getParent().getParent().dom;
                this.errorIcon.render(p, 0);
                this.errorIcon.setHideMode(Style.HideMode.VISIBILITY);
                this.errorIcon.hide();
                this.errorIcon.setStyleAttribute("display", "block");
                this.errorIcon.setStyleAttribute("float", "right");
                this.errorIcon.getAriaSupport().setRole("alert");
                if (GXT.isAriaEnabled()) {
                    this.setAriaState("aria-describedby", this.errorIcon.getId());
                    this.errorIcon.setTitle(this.getErrorMessage());
                }
            } else if (!this.errorIcon.el().isConnected()) {
                Element p = this.el().getParent().getParent().dom;
                p.insertFirst((Node)this.errorIcon.getElement());
            }
            if (!this.errorIcon.isAttached()) {
                ComponentHelper.doAttach((Widget)this.errorIcon);
            }
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    if (CKEditorField.this.errorIcon.isAttached()) {
                        CKEditorField.this.errorIcon.show();
                    }
                }
            });
            this.errorIcon.setToolTip(msg);
            this.errorIcon.getToolTip().addStyleName("x-form-invalid-tip");
            this.el().repaint();
            this.setMessageTarget("none");
            try {
                super.markInvalid(msg);
            }
            finally {
                this.setMessageTarget("side");
            }
        }
    }

    protected boolean validateValue(String value) {
        this.setData("optionalValidation", null);
        boolean isValid = super.validateValue(value);
        if (value != null && (value.length() < 1 || value.equals(""))) {
            if (this.allowBlank) {
                this.clearInvalid();
                return true;
            }
            this.markInvalid(this.blankText);
            return false;
        }
        if (!isValid) {
            return false;
        }
        if (!(this.wcagValidationResult == null || this.lastValidatedContent != null && this.lastValidatedContent.equals(this.getRawValue()))) {
            this.wcagValidationResult = null;
            this.ignoreWcagWarnings = false;
            this.lastValidatedContent = null;
        }
        if (!this.ignoreWcagWarnings && this.wcagValidationResult != null && !this.wcagValidationResult.isEmpty()) {
            this.showWarnings(this.wcagValidationResult, false);
            this.setData("optionalValidation", true);
            return false;
        }
        return true;
    }

    public void clear() {
        if (!this.readOnly) {
            this.ckeditor.clear();
        }
        super.clear();
    }

    public boolean isDirty() {
        return this.readOnly ? false : this.ckeditor.isDirty();
    }

    public String getRawValue() {
        return this.readOnly ? this.html.getHtml() : this.ckeditor.getData();
    }

    public void setRawValue(String html) {
        if (this.readOnly) {
            this.html.setHtml(html);
        } else {
            this.ckeditor.setData(html);
        }
        super.setRawValue(html);
    }

    public void setWcagValidationResult(WCAGValidationResult wcagValidationResult) {
        this.wcagValidationResult = wcagValidationResult;
        this.lastValidatedContent = this.getRawValue();
    }

    protected void showWarnings(WCAGValidationResult wcagResult, final boolean userTriggered) {
        LayoutContainer parent = (LayoutContainer)this.getParent();
        parent.addStyleName(this.invalidStyle);
        if (this.wcagPanel != null) {
            parent.remove((Widget)this.wcagPanel);
        }
        this.wcagPanel = new ContentPanel((Layout)new FitLayout());
        this.wcagPanel.setHeadingHtml(Messages.getWithArgs("label.wcag.report.title", "WCAG Compliance ({0} errors / {1} warnings / {2} infos)", new String[]{String.valueOf(wcagResult.getErrors().size()), String.valueOf(wcagResult.getWarnings().size()), String.valueOf(wcagResult.getInfos().size())}));
        this.wcagPanel.getHeader().setIcon(GXT.IMAGES.field_invalid());
        final CheckMenuItem ignore = new CheckMenuItem(userTriggered ? Messages.get("label.close", "Close") : Messages.get("label.wcag.ignore", "Ignore errors"));
        ignore.addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                ignore.setChecked(true, true);
                CKEditorField.this.ignoreWcagWarnings = !userTriggered;
                CKEditorField.this.wcagPanel.el().fadeToggle(FxConfig.NONE);
                CKEditorField.this.el().getParent().removeStyleName(CKEditorField.this.invalidStyle);
            }
        });
        this.wcagPanel.getHeader().addTool((Component)ignore);
        this.wcagPanel.setBorders(true);
        this.wcagPanel.add(CKEditorField.getWarningGrid(wcagResult));
        this.wcagPanel.addStyleName("wcag-panel");
        parent.insert((Widget)this.wcagPanel, parent.indexOf((Component)this));
        parent.layout();
    }

    private static Widget getWarningGrid(WCAGValidationResult wcagResult) {
        ArrayList<Object> configs = new ArrayList<Object>();
        RowNumberer rowNumberer = new RowNumberer();
        configs.add(rowNumberer);
        ColumnConfig column = new ColumnConfig();
        column.setId("type");
        column.setAlignment(Style.HorizontalAlignment.CENTER);
        column.setWidth(40);
        column.setRenderer((GridCellRenderer)new GridCellRenderer<WCAGViolation>(){

            public Object render(WCAGViolation model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<WCAGViolation> store, Grid<WCAGViolation> grid) {
                Html html = null;
                if ("warning".equalsIgnoreCase(model.getType())) {
                    html = new Html(StandardIconsProvider.STANDARD_ICONS.warning().getHTML());
                    html.setToolTip(Messages.get("label.warning", "Warning"));
                } else if ("information".equalsIgnoreCase(model.getType())) {
                    html = new Html(StandardIconsProvider.STANDARD_ICONS.information().getHTML());
                    html.setToolTip(Messages.get("label.information", "Information"));
                } else {
                    html = new Html(StandardIconsProvider.STANDARD_ICONS.error().getHTML());
                    html.setToolTip(Messages.get("label.error", "Error"));
                }
                return html;
            }
        });
        configs.add(column);
        column = new ColumnConfig();
        column.setId("line");
        column.setHeaderHtml(Messages.get("label.line", "Line"));
        column.setWidth(50);
        configs.add(column);
        column = new ColumnConfig();
        column.setId("column");
        column.setHeaderHtml(Messages.get("label.column", "Column"));
        column.setWidth(50);
        configs.add(column);
        column = new ColumnConfig();
        column.setId("message");
        column.setHeaderHtml(Messages.get("label.description", "Description"));
        column.setRenderer((GridCellRenderer)new GridCellRenderer<WCAGViolation>(){

            public Object render(WCAGViolation model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<WCAGViolation> store, Grid<WCAGViolation> grid) {
                Html txt = new Html(model.getMessage());
                txt.setToolTip(model.getMessage());
                return txt;
            }
        });
        configs.add(column);
        column = new ColumnConfig();
        column.setId("context");
        column.setHeaderHtml(Messages.get("label.context", "Context"));
        column.setWidth(60);
        column.setAlignment(Style.HorizontalAlignment.CENTER);
        column.setRenderer((GridCellRenderer)new GridCellRenderer<WCAGViolation>(){

            public Object render(WCAGViolation model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<WCAGViolation> store, Grid<WCAGViolation> grid) {
                if (model.getContext() == null || model.getContext().length() == 0) {
                    return "";
                }
                ToolTipConfig tt = new ToolTipConfig();
                tt.setTitle(Messages.get("label.context", "Context"));
                tt.setTemplate(new Template(model.getContext()));
                Html icon = new Html(StandardIconsProvider.STANDARD_ICONS.about().getHTML());
                icon.setToolTip(tt);
                return icon;
            }
        });
        configs.add(column);
        column = new ColumnConfig();
        column.setId("code");
        column.setHeaderHtml(Messages.get("label.code", "Code"));
        column.setWidth(60);
        column.setAlignment(Style.HorizontalAlignment.CENTER);
        column.setRenderer((GridCellRenderer)new GridCellRenderer<WCAGViolation>(){

            public Object render(WCAGViolation model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<WCAGViolation> store, Grid<WCAGViolation> grid) {
                if (model.getCode() == null || model.getCode().length() == 0) {
                    return "";
                }
                ToolTipConfig tt = new ToolTipConfig();
                tt.setTitle(Messages.get("label.code", "Code"));
                tt.setTemplate(new Template(model.getCode()));
                Html icon = new Html(StandardIconsProvider.STANDARD_ICONS.about().getHTML());
                icon.setToolTip(tt);
                return icon;
            }
        });
        configs.add(column);
        column = new ColumnConfig();
        column.setId("example");
        column.setHeaderHtml(Messages.get("label.example", "Example"));
        column.setAlignment(Style.HorizontalAlignment.CENTER);
        column.setWidth(80);
        configs.add(column);
        ListStore store = new ListStore();
        store.add(wcagResult.getErrors());
        store.add(wcagResult.getWarnings());
        store.add(wcagResult.getInfos());
        Grid grid = new Grid(store, new ColumnModel(configs));
        grid.setHeight(store.getCount() > 3 ? 100 : 35 + 20 * store.getCount());
        grid.setStyleAttribute("borderTop", "none");
        grid.setAutoExpandColumn("message");
        grid.setAutoExpandMax(900);
        grid.setBorders(false);
        grid.setStripeRows(true);
        grid.setColumnLines(true);
        grid.setColumnReordering(true);
        grid.addPlugin((ComponentPlugin)rowNumberer);
        grid.addStyleName("wcag-warning-grid");
        return grid;
    }

    public boolean isIgnoreWcagWarnings() {
        return this.ignoreWcagWarnings;
    }

    public void checkWCAGCompliance() {
        String text;
        if (this.wcagPanel != null) {
            this.el().getParent().removeStyleName(this.invalidStyle);
            ((LayoutContainer)this.getParent()).remove((Widget)this.wcagPanel);
            this.wcagPanel = null;
        }
        if ((text = this.ckeditor.getData()) == null || text.length() == 0) {
            MessageBox.info((String)Messages.get("label.information", "Information"), (String)Messages.getWithArgs("label.wcag.report.title", "WCAG Compliance ({0} errors / {1} warnings / {2} infos)", new String[]{String.valueOf(0), String.valueOf(0), String.valueOf(0)}), null);
            return;
        }
        HashMap<String, String> toValidate = new HashMap<String, String>(1);
        toValidate.put("text", text);
        JahiaContentManagementService.App.getInstance().validateWCAG(toValidate, (AsyncCallback<Map<String, WCAGValidationResult>>)new BaseAsyncCallback<Map<String, WCAGValidationResult>>(){

            public void onSuccess(Map<String, WCAGValidationResult> result) {
                WCAGValidationResult validationResult = result.get("text");
                if (validationResult.isEmpty()) {
                    MessageBox.info((String)Messages.get("label.information", "Information"), (String)Messages.getWithArgs("label.wcag.report.title", "WCAG Compliance ({0} errors / {1} warnings / {2} infos)", new String[]{String.valueOf(0), String.valueOf(0), String.valueOf(0)}), null);
                } else {
                    CKEditorField.this.showWarnings(validationResult, true);
                }
            }

            @Override
            public void onApplicationFailure(Throwable caught) {
                super.onApplicationFailure(caught);
            }
        });
    }

    protected void onUnload() {
        instances.remove(this.ckeditor.getInstanceId());
        super.onUnload();
    }

    public static CKEditorField getInstance(String editorInstanceId) {
        return instances.get(editorInstanceId);
    }

    public void focus() {
        this.ckeditor.focus();
    }
}

