/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.form;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.AdapterField;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.FrameElement;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.NamedFrame;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.messages.Messages;

public class FileUploadField
extends AdapterField {
    public FileUploadField(String name) {
        super((Widget)new Uploader(name));
        this.setName(name);
        ((Uploader)this.getWidget()).addListener(new Listener(){

            @Override
            public void onChange(Event event) {
                FileUploadField.this.setUploadedValue(((Uploader)FileUploadField.this.getWidget()).getKey());
            }
        });
    }

    public void setValue(Object o) {
        ((Uploader)this.getWidget()).setValue((String)o, (String)o);
    }

    public void setUploadedValue(String o) {
        super.setValue((Object)o);
    }

    public String getRawValue() {
        String v;
        String string = v = this.rendered ? this.getInputEl().getValue() : "";
        if (v == null || v.equals(this.emptyText)) {
            return "";
        }
        return v;
    }

    static interface Listener {
        public void onChange(Event var1);
    }

    static class Uploader
    extends HorizontalPanel {
        private String name;
        private String key;
        private FormPanel form;
        private Text status;
        private Button clear;
        private NamedFrame target;
        private List<Listener> listeners = new ArrayList<Listener>();

        public Uploader(String defname) {
            this.status = new Text();
            this.status.setStyleName("x-form-field");
            this.target = new NamedFrame("target" + defname){

                public void onBrowserEvent(Event event) {
                    Log.debug((String)"LOADED");
                    Log.error((String)((FrameElement)this.getElement().cast()).getContentDocument().getClass().toString());
                    Document document = ((FrameElement)this.getElement().cast()).getContentDocument();
                    Log.error((String)document.getClass().toString());
                    Element elem = document.getElementById("uploaded");
                    if (elem != null) {
                        Uploader.this.setValue(elem.getAttribute("name"), elem.getAttribute("key"));
                    }
                    super.onBrowserEvent(event);
                }
            };
            this.target.sinkEvents(32768);
            this.target.setVisible(false);
            this.form = new FormPanel(this.target);
            String entryPoint = JahiaGWTParameters.getServiceEntryPoint();
            if (entryPoint == null) {
                entryPoint = "/gwt/";
            }
            this.form.setAction(entryPoint + "fileupload");
            this.form.setEncoding("multipart/form-data");
            this.form.setMethod("post");
            this.clear = new Button(Messages.get("label.stop", "Stop"), (SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent event) {
                    Uploader.this.setValue(null, "clear");
                }
            });
            this.clear.addStyleName("button-stop");
            this.name = null;
            this.key = null;
            this.initForm();
            this.status.setText("");
            this.clear.setVisible(false);
            this.add((Component)this.status);
            this.add((Widget)this.form);
            this.add((Component)this.clear);
            this.add((Widget)this.target);
        }

        public void setValue(String name, String key) {
            this.name = name;
            this.key = key;
            if (name == null) {
                this.initForm();
                this.status.setText("");
                this.clear.setVisible(false);
            } else {
                this.status.setText(name);
                this.clear.setText(Messages.get("label.clear", "Clear"));
                this.clear.setVisible(true);
                this.form.setVisible(false);
            }
            for (Listener listener : this.listeners) {
                listener.onChange(null);
            }
        }

        public void addListener(Listener list) {
            this.listeners.add(list);
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        private void initForm() {
            FileUpload upload = new FileUpload(){

                public final void onBrowserEvent(Event event) {
                    Uploader.this.status.setText(Messages.get("message.uploading", "Uploading..."));
                    Uploader.this.form.submit();
                    Uploader.this.form.setVisible(false);
                    Uploader.this.clear.setText(Messages.get("label.stop", "Stop"));
                    Uploader.this.clear.setVisible(true);
                    super.onBrowserEvent(event);
                }
            };
            upload.sinkEvents(1536);
            upload.setName("asyncupload");
            this.form.clear();
            this.form.add((Widget)upload);
            this.form.setVisible(true);
        }
    }
}

