/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.form;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.form.Validator;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.content.CronField;

public abstract class FormQuickRemotePublication
extends FormPanel {
    public FormQuickRemotePublication() {
        this.createUI();
    }

    protected void createUI() {
        this.setLabelWidth(130);
        this.setFieldWidth(500);
        this.setBodyBorder(false);
        this.setFrame(false);
        this.setAutoHeight(true);
        this.setHeaderVisible(false);
        this.setButtonAlign(Style.HorizontalAlignment.CENTER);
        this.setStyleAttribute("padding", "4");
        final TextField nameField = new TextField();
        nameField.setName("name");
        nameField.setFieldLabel(Messages.get("label.name", "Name"));
        nameField.setAllowBlank(false);
        nameField.setMaxLength(200);
        this.add((Component)nameField);
        final ComboBox localPath = new ComboBox();
        final ListStore store = new ListStore();
        JahiaContentManagementService.App.getInstance().getRoot(Arrays.asList("/sites/*"), Arrays.asList("jnt:virtualsite"), null, null, null, null, null, false, false, null, null, false, (AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

            public void onSuccess(List<GWTJahiaNode> result) {
                store.add(result);
            }
        });
        localPath.setStore(store);
        localPath.setDisplayField("displayName");
        localPath.setValueField("uuid");
        localPath.setTypeAhead(true);
        localPath.setTriggerAction(ComboBox.TriggerAction.ALL);
        localPath.setForceSelection(true);
        localPath.setName("node");
        localPath.setFieldLabel(Messages.get("label.source", "Source"));
        this.add((Component)localPath);
        final TextField remoteUrlField = new TextField();
        remoteUrlField.setName("remoteUrl");
        remoteUrlField.setEmptyText("http://www.target-acme-site.com");
        remoteUrlField.setFieldLabel(Messages.get("label.remoteUrl", "Target server URL"));
        remoteUrlField.setAllowBlank(false);
        this.add((Component)remoteUrlField);
        final TextField remotePath = new TextField();
        remotePath.setName("remotePath");
        remotePath.setEmptyText("/sites/targetSite");
        remotePath.setValidator(new Validator(){

            public String validate(Field<?> field, String s) {
                if (s.startsWith("/")) {
                    return null;
                }
                return Messages.get("failure.remotePublication.remotePath.invalid", "Remote path should be an absolute path to a node on the distant server");
            }
        });
        remotePath.setFieldLabel(Messages.get("label.remotePath", "Remote path"));
        remotePath.setAllowBlank(false);
        this.add((Component)remotePath);
        final TextField remoteUser = new TextField();
        remoteUser.setName("remoteUser");
        remoteUser.setFieldLabel(Messages.get("label.remoteUser", "Remote user"));
        remoteUser.setAllowBlank(false);
        remoteUser.setValue((Object)"root");
        remoteUser.setEnabled(false);
        this.add((Component)remoteUser);
        final TextField remotePassword = new TextField();
        remotePassword.setPassword(true);
        remotePassword.setName("remotePassword");
        remotePassword.setFieldLabel(Messages.get("label.remotePassword", "Remote password"));
        remotePassword.setAllowBlank(false);
        this.add((Component)remotePassword);
        final CronField schedule = new CronField();
        schedule.setName("schedule");
        schedule.setFieldLabel(Messages.get("label.remoteSchedule", "Schedule"));
        this.add((Component)schedule);
        final CheckBox doValidate = new CheckBox();
        doValidate.setFieldLabel(Messages.get("label.remoteValidate", "Test settings"));
        doValidate.setValue(Boolean.TRUE);
        this.add((Component)doValidate);
        Button saveButton = new Button(Messages.get("label.save", "Save"));
        saveButton.addStyleName("button-save");
        saveButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent componentEvent) {
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("remoteUrl", (String)remoteUrlField.getValue());
                props.put("remotePath", (String)remotePath.getValue());
                props.put("remoteUser", (String)remoteUser.getValue());
                props.put("remotePassword", (String)remotePassword.getValue());
                props.put("node", ((GWTJahiaNode)localPath.getValue()).getUUID());
                props.put("schedule", schedule.getValue());
                JahiaContentManagementService.App.getInstance().createRemotePublication((String)nameField.getValue(), props, doValidate.getValue(), (AsyncCallback<Boolean>)new BaseAsyncCallback<Boolean>(){

                    public void onSuccess(Boolean result) {
                        if (FormQuickRemotePublication.this.getParent() instanceof Window) {
                            ((Window)FormQuickRemotePublication.this.getParent()).hide();
                        }
                        FormQuickRemotePublication.this.onRemotePublicationCreated();
                    }

                    @Override
                    public void onApplicationFailure(Throwable caught) {
                        MessageBox.alert((String)Messages.get("label.error", "Error"), (String)caught.getMessage(), null);
                    }
                });
            }
        });
        this.addButton(saveButton);
        this.layout();
    }

    public abstract void onRemotePublicationCreated();
}

