/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.publication;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.LoadEvent;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.ModelIconProvider;
import com.extjs.gxt.ui.client.data.TreeLoader;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.LoadListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.Record;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentPlugin;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.grid.CheckColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.util.icons.ContentModelIconProvider;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.NodeColumnConfigList;
import org.jahia.ajax.gwt.client.widget.node.GWTJahiaNodeTreeFactory;
import org.jahia.ajax.gwt.client.widget.publication.PublicationWorkflow;
import org.jahia.ajax.gwt.client.widget.workflow.WorkflowActionDialog;

public class PublicationManagerEngine
extends Window {
    private final Linker linker;
    private TreeLoader<GWTJahiaNode> loader;
    private TreeGrid<GWTJahiaNode> m_tree;
    private List<GWTJahiaLanguage> languages;
    private Map<String, LayoutContainer> checkboxMap;
    private List<String> nodeTypes;

    public PublicationManagerEngine(Linker linker, List<GWTJahiaLanguage> result, List<String> nodeTypes) {
        this.addStyleName("publication-manager-engine");
        this.linker = linker;
        this.languages = result;
        this.nodeTypes = nodeTypes;
        this.setLayout((Layout)new FitLayout());
        this.init();
    }

    private void init() {
        this.setHeadingHtml(Messages.get("label.publicationmanager", "Publication Manager"));
        this.setLayout((Layout)new FitLayout());
        this.setSize(800, 600);
        this.setBorders(false);
        this.setBodyBorder(false);
        this.setModal(true);
        this.setMaximizable(true);
        this.getHeader().setBorders(false);
        this.getHeader().setIcon(ToolbarIconProvider.getInstance().getIcon("siteRepository"));
        GWTJahiaNodeTreeFactory factory = new GWTJahiaNodeTreeFactory(Arrays.asList("/sites/" + this.linker.getSelectionContext().getMainNode().getSiteKey()), true);
        factory.setNodeTypes(this.nodeTypes);
        factory.setFields(Arrays.asList("name", "displayName", "publicationInfos", "workflowInfos"));
        factory.setSelectedPath(this.linker.getSelectionContext().getMainNode().getPath());
        this.loader = factory.getLoader();
        LinkedList<ColumnConfig> columns = new LinkedList<ColumnConfig>();
        Object config = new ColumnConfig("displayName", Messages.get("label.name", "Name"), 150);
        config.setRenderer(NodeColumnConfigList.NAME_TREEGRID_RENDERER);
        config.setSortable(false);
        columns.add((ColumnConfig)config);
        this.checkboxMap = new HashMap<String, LayoutContainer>();
        for (GWTJahiaLanguage gWTJahiaLanguage : this.languages) {
            config = new PublicationCheckColumnConfig("publicationInfos", gWTJahiaLanguage.getDisplayName(), 100);
            config.setDataIndex(gWTJahiaLanguage.getLanguage());
            config.setSortable(false);
            TableData td = new TableData();
            td.setHorizontalAlign(Style.HorizontalAlignment.CENTER);
            td.setVerticalAlign(Style.VerticalAlignment.MIDDLE);
            HorizontalPanel p = new HorizontalPanel();
            p.add((Widget)new Text(gWTJahiaLanguage.getDisplayName()), (LayoutData)td);
            config.setWidget((Widget)p, gWTJahiaLanguage.getLanguage());
            columns.add((ColumnConfig)config);
        }
        ColumnModel cm = new ColumnModel(columns);
        this.m_tree = factory.getTreeGrid(cm);
        for (ColumnConfig column : columns) {
            if (!(column instanceof CheckColumnConfig)) continue;
            this.m_tree.addPlugin((ComponentPlugin)column);
        }
        this.m_tree.setHideHeaders(false);
        this.m_tree.setIconProvider((ModelIconProvider)ContentModelIconProvider.getInstance());
        this.m_tree.setAutoExpand(false);
        this.m_tree.setAutoExpandMax(1000);
        this.m_tree.setAutoExpandMin(150);
        this.m_tree.setAutoExpandColumn("displayName");
        this.m_tree.setBorders(true);
        this.setScrollMode(Style.Scroll.AUTO);
        this.add((Component)this.m_tree);
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setAlignment(Style.HorizontalAlignment.CENTER);
        Button button = new Button(Messages.get("label.publish", "Publish"));
        button.addStyleName("button-publish");
        buttonBar.add((Component)button);
        Button cancelButton = new Button(Messages.get("label.cancel", "Cancel"));
        cancelButton.addStyleName("button-cancel");
        buttonBar.add((Component)cancelButton);
        this.setBottomComponent((Component)buttonBar);
        this.m_tree.mask(Messages.get("label.loading", "Loading..."), "x-mask-loading");
        this.loader.addLoadListener(new LoadListener(){

            public void loaderLoad(LoadEvent le) {
                PublicationManagerEngine.this.m_tree.unmask();
            }
        });
        this.loader.load();
        cancelButton.addListener(Events.Select, (Listener)new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent ce) {
                PublicationManagerEngine.this.hide();
            }
        });
        button.addSelectionListener((SelectionListener)new StartWorkflowButtonSelectionListener(this));
    }

    private class PublicationCheckColumnConfig
    extends CheckColumnConfig {
        public PublicationCheckColumnConfig(String id, String name, int width) {
            super(id, name, width);
            this.setRenderer((GridCellRenderer)new GridCellRenderer<ModelData>(){

                public Object render(ModelData model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<ModelData> listStore, Grid<ModelData> grid) {
                    return PublicationCheckColumnConfig.this.renderHTML(model, property, config, rowIndex, colIndex, listStore);
                }
            });
        }

        protected Object renderHTML(ModelData model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<ModelData> store) {
            GWTJahiaNode node = (GWTJahiaNode)model;
            Map<String, GWTJahiaPublicationInfo> infos = node.getAggregatedPublicationInfos();
            if (infos != null) {
                GWTJahiaPublicationInfo info = infos.get(this.getDataIndex());
                TableData td = new TableData();
                td.setHorizontalAlign(Style.HorizontalAlignment.CENTER);
                td.setVerticalAlign(Style.VerticalAlignment.MIDDLE);
                HorizontalPanel p = new HorizontalPanel();
                LayoutContainer ctn = new LayoutContainer();
                ctn.addStyleName("x-grid3-check-col");
                ctn.addStyleName("x-grid3-check-col" + this.getCheckState(node, info));
                ctn.addStyleName("x-grid3-cc-" + this.getId() + "-" + config.name);
                ctn.setWidth(16);
                ctn.setHeight(16);
                p.add((Widget)ctn, (LayoutData)td);
                Image res = GWTJahiaPublicationInfo.renderPublicationStatusImage(info);
                p.add((Widget)res, (LayoutData)td);
                if (info.isLocked().booleanValue()) {
                    p.add((Widget)StandardIconsProvider.STANDARD_ICONS.lock().createImage());
                    ctn.addStyleName("x-grid3-check-col-disabled");
                }
                return p;
            }
            return "";
        }

        private int getState(GWTJahiaNode node) {
            return node.getAggregatedPublicationInfos() != null ? node.getAggregatedPublicationInfos().get(this.getDataIndex()).getStatus() : 0;
        }

        private String getCheckState(GWTJahiaNode model, GWTJahiaPublicationInfo info) {
            boolean wfStatus;
            Object o;
            Record record = this.grid.getStore().getRecord((ModelData)model);
            boolean checked = false;
            if (record != null && (o = record.get(this.getDataIndex())) != null && o instanceof Boolean) {
                checked = (Boolean)o;
            }
            return (wfStatus = this.getStatus(model, info)) ? (checked ? "-on" : "") : "-disabled";
        }

        public boolean getStatus(GWTJahiaNode node, GWTJahiaPublicationInfo info) {
            if (info.get("checkboxEnabled") != null) {
                return (Boolean)info.get("checkboxEnabled");
            }
            boolean b = info.isPublishable() && (info.getWorkflowDefinition() != null || info.isAllowedToPublishWithoutWorkflow() != false);
            info.set("checkboxEnable", b);
            return b;
        }

        protected void onMouseDown(GridEvent<ModelData> ge) {
            String cls = ge.getTarget().getClassName();
            if (cls != null && cls.indexOf("x-grid3-cc-" + this.getId() + "-" + this.getDataIndex() + " ") != -1 && cls.indexOf("disabled") == -1) {
                ge.stopEvent();
                int index = this.grid.getView().findRowIndex((Element)ge.getTarget());
                ModelData m = this.grid.getStore().getAt(index);
                Record r = this.grid.getStore().getRecord(m);
                if (r.get(this.getDataIndex()) == null) {
                    r.set(this.getDataIndex(), (Object)Boolean.TRUE);
                } else {
                    boolean value = (Boolean)r.get(this.getDataIndex()) == false;
                    r.set(this.getDataIndex(), (Object)value);
                }
            }
        }

        public void init(Component component) {
            this.grid = (Grid)component;
            this.grid.addListener(Events.CellClick, (Listener)new Listener<GridEvent>(){

                public void handleEvent(GridEvent e) {
                    PublicationCheckColumnConfig.this.onMouseDown((GridEvent<ModelData>)e);
                }
            });
        }
    }

    private class StartWorkflowButtonSelectionListener
    extends SelectionListener<ButtonEvent> {
        private final Window dialog;
        private List<WorkflowActionDialog> dialogList;

        public StartWorkflowButtonSelectionListener(Window window) {
            this.dialog = window;
            this.dialogList = new LinkedList<WorkflowActionDialog>();
        }

        public void componentSelected(ButtonEvent ce) {
            ListStore store = PublicationManagerEngine.this.m_tree.getStore();
            List nodes = store.getModels();
            ArrayList<GWTJahiaPublicationInfo> all = new ArrayList<GWTJahiaPublicationInfo>();
            for (GWTJahiaNode node : nodes) {
                Record record = store.getRecord((ModelData)node);
                for (GWTJahiaLanguage language : PublicationManagerEngine.this.languages) {
                    List<GWTJahiaPublicationInfo> list;
                    boolean checked;
                    Object o;
                    if (record == null || (o = record.get(language.getLanguage())) == null || !(o instanceof Boolean) || !(checked = ((Boolean)o).booleanValue()) || (list = node.getFullPublicationInfos().get(language.getLanguage())) == null) continue;
                    all.addAll(list);
                }
            }
            if (all.isEmpty()) {
                MessageBox.info((String)Messages.get("label.publish", "Publication"), (String)Messages.get("label.publication.nothingToPublish", "Nothing to publish"), null);
                return;
            }
            PublicationWorkflow.create(all, PublicationManagerEngine.this.linker, false);
            PublicationManagerEngine.this.hide();
        }
    }
}

