/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.widget.MessageBox;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;

public class ClearAllLocksActionItem
extends BaseActionItem {
    private boolean doSubNodes = false;

    public void setDoSubNodes(boolean doSubNodes) {
        this.doSubNodes = doSubNodes;
    }

    @Override
    public void onComponentSelection() {
        String selectedPaths = this.linker.getSelectionContext().getSingleSelection().getPath();
        JahiaContentManagementService.App.getInstance().clearAllLocks(selectedPaths, this.doSubNodes, new BaseAsyncCallback(){

            @Override
            public void onApplicationFailure(Throwable throwable) {
                MessageBox.alert((String)Messages.get("label.error", "Error"), (String)throwable.getLocalizedMessage(), null);
                ClearAllLocksActionItem.this.linker.loaded();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("refreshMain", true);
                ClearAllLocksActionItem.this.linker.refresh(data);
            }

            public void onSuccess(Object o) {
                ClearAllLocksActionItem.this.linker.loaded();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("refreshMain", true);
                ClearAllLocksActionItem.this.linker.refresh(data);
            }
        });
    }

    @Override
    public void handleNewLinkerSelection() {
        LinkerSelectionContext lh = this.linker.getSelectionContext();
        GWTJahiaNode singleSelection = lh.getSingleSelection();
        this.setEnabled(singleSelection != null && singleSelection.isLockable() != false && this.hasPermission(lh.getSelectionPermissions()) && PermissionsUtils.isPermitted("jcr:lockManagement", lh.getSelectionPermissions()) && singleSelection.getLockInfos() != null && !lh.getSingleSelection().getLockInfos().isEmpty() && (PermissionsUtils.isPermitted("clearLock", lh.getSelectionPermissions()) || this.checkLockInfos(singleSelection.getLockInfos())));
    }

    private boolean checkLockInfos(Map<String, List<String>> lockInfos) {
        for (List<String> list : lockInfos.values()) {
            for (String s : list) {
                if (s.equals(JahiaGWTParameters.getCurrentUser())) continue;
                return false;
            }
        }
        return true;
    }
}

