/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BasePagingLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.ListLoader;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.PagingLoadConfig;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.PagingLoader;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.toolbar.PagingToolBar;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaBasicDataBean;
import org.jahia.ajax.gwt.client.data.GWTJahiaChannel;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;
import org.jahia.ajax.gwt.client.widget.SearchField;
import org.jahia.ajax.gwt.client.widget.form.CalendarField;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;

public class CustomizedPreviewActionItem
extends BaseActionItem {
    private transient SearchField userSearchField;
    private transient String lastUserSearchValue;
    private transient Grid<GWTJahiaNode> userGrid;
    private transient String defaultWindowOptions = "resizable=yes,scrollbars=yes";

    @Override
    public void onComponentSelection() {
        Window window = new Window();
        window.addStyleName("customized-preview");
        window.setSize(500, 430);
        window.setPlain(true);
        window.setModal(true);
        window.setBlinkModal(true);
        window.setBorders(false);
        window.setHeadingHtml(Messages.get("label.preview.window.title", "Customized preview"));
        window.setLayout((Layout)new FitLayout());
        window.setButtonAlign(Style.HorizontalAlignment.CENTER);
        window.setBodyBorder(false);
        RpcProxy<PagingLoadResult<GWTJahiaNode>> proxy = new RpcProxy<PagingLoadResult<GWTJahiaNode>>(){

            protected void load(Object pageLoaderConfig, AsyncCallback<PagingLoadResult<GWTJahiaNode>> callback) {
                if (CustomizedPreviewActionItem.this.userSearchField != null) {
                    String newSearch = CustomizedPreviewActionItem.this.userSearchField.getText().trim().replace("'", "''");
                    String query = "select * from [jnt:user] as u where (isdescendantnode(u,'/users/') or isdescendantnode(u,'/sites/" + JahiaGWTParameters.getSiteKey().replace("'", "''") + "/users/'))";
                    if (newSearch.length() > 0) {
                        query = query + " and (CONTAINS(u.*,'*" + newSearch + "*') OR LOWER(u.[j:nodename]) LIKE '*" + newSearch.toLowerCase() + "*') ";
                    }
                    query = query + " ORDER BY u.[j:nodename]";
                    int offset = CustomizedPreviewActionItem.this.lastUserSearchValue != null && CustomizedPreviewActionItem.this.lastUserSearchValue.equals(newSearch) ? ((PagingLoadConfig)pageLoaderConfig).getOffset() : 0;
                    JahiaContentManagementServiceAsync service = JahiaContentManagementService.App.getInstance();
                    service.searchSQL(query, ((PagingLoadConfig)pageLoaderConfig).getLimit(), offset, null, GWTJahiaNode.DEFAULT_USER_FIELDS, false, callback);
                    CustomizedPreviewActionItem.this.lastUserSearchValue = newSearch;
                }
            }
        };
        final BasePagingLoader loader = new BasePagingLoader((DataProxy)proxy);
        this.userSearchField = new SearchField(Messages.get("label.search", "Search: "), false){

            @Override
            public void onFieldValidation(String value) {
                loader.load();
            }

            @Override
            public void onSaveButtonClicked(String value) {
            }
        };
        this.userSearchField.setWidth(490);
        loader.setLimit(10);
        loader.load();
        HorizontalPanel panel = new HorizontalPanel();
        panel.add((Widget)this.userSearchField);
        ListStore store = new ListStore((ListLoader)loader);
        ArrayList<ColumnConfig> columns = new ArrayList<ColumnConfig>();
        columns.add(new ColumnConfig("displayName", Messages.get("label.username", "User name"), 150));
        columns.add(new ColumnConfig("j:lastName", Messages.get("label.lastName", "Last name"), 130));
        columns.add(new ColumnConfig("j:firstName", Messages.get("label.firstName", "First name"), 130));
        columns.add(new ColumnConfig("providerKey", Messages.get("column.provider.label", "Provider"), 75));
        ColumnModel cm = new ColumnModel(columns);
        PagingToolBar toolBar = new PagingToolBar(10);
        toolBar.bind((PagingLoader)loader);
        toolBar.setBorders(false);
        toolBar.setWidth(480);
        this.userGrid = new Grid(store, cm);
        this.userGrid.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
        this.userGrid.setLoadMask(true);
        this.userGrid.setBorders(false);
        this.userGrid.setHeight(250);
        this.userGrid.setWidth(490);
        VerticalPanel verticalPanel = new VerticalPanel();
        verticalPanel.add(this.userGrid);
        verticalPanel.add((Widget)toolBar);
        window.setTopComponent((Component)panel);
        panel = new HorizontalPanel();
        panel.setTableHeight("30px");
        panel.setVerticalAlign(Style.VerticalAlignment.BOTTOM);
        Label label = new Label("&nbsp;&nbsp;&nbsp;&nbsp;" + Messages.get("label.preview.window.date", "Pick a date for the preview") + "&nbsp;&nbsp;&nbsp;");
        label.setWidth(200);
        label.setLabelFor("previewDate");
        final Date date = new Date();
        final CalendarField calendarField = new CalendarField("yyyy-MM-dd HH:mm", true, false, "previewDate", false, date);
        panel.add((Widget)label);
        panel.add((Widget)calendarField);
        verticalPanel.add((Widget)panel);
        window.add((Widget)verticalPanel);
        panel = new HorizontalPanel();
        panel.setTableHeight("30px");
        panel.setVerticalAlign(Style.VerticalAlignment.BOTTOM);
        label = new Label("&nbsp;&nbsp;&nbsp;&nbsp;" + Messages.get("label.preview.window.channel", "Channel") + "&nbsp;&nbsp;&nbsp;");
        label.setLabelFor("previewChannel");
        final Label orientationLabel = new Label("&nbsp;&nbsp;&nbsp;&nbsp;" + Messages.get("label.preview.window.channelOrientation", "Orientation") + "&nbsp;&nbsp;&nbsp;");
        orientationLabel.setLabelFor("previewChannelOrientation");
        orientationLabel.hide();
        ListStore orientations = new ListStore();
        final ComboBox orientationCombo = new ComboBox();
        orientationCombo.setDisplayField("displayName");
        orientationCombo.setName("previewChannelOrientation");
        orientationCombo.setStore(orientations);
        orientationCombo.setTypeAhead(true);
        orientationCombo.setTriggerAction(ComboBox.TriggerAction.ALL);
        orientationCombo.hide();
        final ListStore states = new ListStore();
        final ComboBox combo = new ComboBox();
        JahiaContentManagementServiceAsync contentService = JahiaContentManagementService.App.getInstance();
        contentService.getChannels((AsyncCallback<List<GWTJahiaChannel>>)new BaseAsyncCallback<List<GWTJahiaChannel>>(){

            public void onSuccess(List<GWTJahiaChannel> result) {
                states.add(result);
                combo.setStore(states);
            }
        });
        combo.setDisplayField("display");
        combo.setName("previewChannel");
        combo.setStore(states);
        combo.setTypeAhead(true);
        combo.setTriggerAction(ComboBox.TriggerAction.ALL);
        combo.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaChannel>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaChannel> event) {
                GWTJahiaChannel selectedChannel = (GWTJahiaChannel)event.getSelectedItem();
                Map<String, String> capabilities = selectedChannel.getCapabilities();
                if (capabilities != null && capabilities.containsKey("variants")) {
                    String[] variants = capabilities.get("variants").split(",");
                    String[] displayNames = null;
                    if (capabilities.containsKey("variants-displayNames")) {
                        displayNames = capabilities.get("variants-displayNames").split(",");
                    }
                    ListStore orientations = orientationCombo.getStore();
                    orientations.removeAll();
                    for (int i = 0; i < variants.length; ++i) {
                        String displayName = displayNames == null ? variants[i] : displayNames[i];
                        orientations.add((ModelData)new GWTJahiaBasicDataBean(variants[i], displayName));
                    }
                    orientationCombo.setValue(orientations.getAt(0));
                    orientationLabel.show();
                    orientationCombo.show();
                } else {
                    orientationLabel.hide();
                    orientationCombo.hide();
                }
            }
        });
        panel.add((Widget)label);
        panel.add((Widget)combo);
        panel.add((Widget)orientationLabel);
        panel.add((Widget)orientationCombo);
        verticalPanel.add((Widget)panel);
        window.add((Widget)verticalPanel);
        Button ok = new Button(Messages.get("label.preview.window.confirm", "Show customized preview"));
        ok.addStyleName("button-preview");
        ok.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent buttonEvent) {
                GWTJahiaNode node = CustomizedPreviewActionItem.this.linker.getSelectionContext().getMainNode();
                if (node != null) {
                    String path = node.getPath();
                    String locale = JahiaGWTParameters.getLanguage();
                    JahiaContentManagementService.App.getInstance().getNodeURL(null, path, null, null, "default", locale, false, (AsyncCallback<String>)new BaseAsyncCallback<String>(){

                        public void onSuccess(String url) {
                            GWTJahiaNode selectedItem = (GWTJahiaNode)CustomizedPreviewActionItem.this.userGrid.getSelectionModel().getSelectedItem();
                            String alias = null;
                            ArrayList<String> urlParameters = new ArrayList<String>();
                            if (selectedItem != null) {
                                alias = "alias=" + selectedItem.getName();
                                urlParameters.add(alias);
                            }
                            String previewDate = null;
                            if (((Date)calendarField.getValue()).after(date)) {
                                previewDate = "prevdate=" + ((Date)calendarField.getValue()).getTime();
                                urlParameters.add(previewDate);
                            }
                            GWTJahiaChannel channel = (GWTJahiaChannel)combo.getValue();
                            String windowFeatures = null;
                            if (channel != null && !"default".equals(channel.getValue())) {
                                urlParameters.add("channel=" + channel.getValue());
                                Map<String, String> capabilities = channel.getCapabilities();
                                if (capabilities != null && capabilities.containsKey("variants")) {
                                    int variantIndex = 0;
                                    String[] variants = capabilities.get("variants").split(",");
                                    String variant = ((GWTJahiaBasicDataBean)orientationCombo.getValue()).getValue();
                                    urlParameters.add("variant=" + variant);
                                    for (int i = 0; i < variants.length; ++i) {
                                        if (!variants[i].equals(variant)) continue;
                                        variantIndex = i;
                                        break;
                                    }
                                    int[] imageSize = channel.getVariantDecoratorImageSize(variantIndex);
                                    windowFeatures = "resizable=no,status=no,menubar=no,toolbar=no,width=" + imageSize[0] + ",height=" + imageSize[1];
                                }
                            }
                            StringBuilder urlParams = new StringBuilder();
                            for (int i = 0; i < urlParameters.size(); ++i) {
                                if (i == 0) {
                                    urlParams.append("?");
                                }
                                urlParams.append((String)urlParameters.get(i));
                                if (i >= urlParameters.size() - 1) continue;
                                urlParams.append("&");
                            }
                            String url1 = url + urlParams.toString();
                            CustomizedPreviewActionItem.openWindow(url1, "customizedpreview", windowFeatures != null ? windowFeatures : CustomizedPreviewActionItem.this.defaultWindowOptions);
                        }
                    });
                }
            }
        });
        window.setBottomComponent((Component)ok);
        window.show();
    }

    public static native void openWindow(String var0, String var1, String var2);

    public void setDefaultWindowOptions(String defaultWindowOptions) {
        this.defaultWindowOptions = defaultWindowOptions;
    }
}

