/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTModuleReleaseInfo;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.widget.toolbar.action.ForgeLoginWindow;

public class ReleaseModuleWindow
extends Window {
    private Callback callback;
    private GWTModuleReleaseInfo releaseInfo;

    public ReleaseModuleWindow(GWTModuleReleaseInfo releaseInfo) {
        this.addStyleName("release-module-window");
        this.releaseInfo = releaseInfo != null ? releaseInfo : new GWTModuleReleaseInfo();
    }

    private String generateVersionNumber(List<Integer> orderedVersionNumbers, int index) {
        ArrayList<Integer> newOrderedVersionNumbers = new ArrayList<Integer>(orderedVersionNumbers);
        newOrderedVersionNumbers.set(index, orderedVersionNumbers.get(index) + 1);
        for (int i = index + 1; i < newOrderedVersionNumbers.size(); ++i) {
            newOrderedVersionNumbers.set(i, 0);
        }
        StringBuilder sb = new StringBuilder();
        for (Integer n : newOrderedVersionNumbers) {
            sb.append(".").append(n);
        }
        sb.append("-SNAPSHOT");
        return sb.substring(1);
    }

    protected void onRender(Element element, int index) {
        super.onRender(element, index);
        String versionInfo = (String)JahiaGWTParameters.getSiteNode().get("j:versionInfo");
        this.setLayout((Layout)new FitLayout());
        this.setHeadingHtml(Messages.get("label.releaseWar") + "&nbsp;" + versionInfo + "&nbsp;->&nbsp;" + versionInfo.replace("-SNAPSHOT", ""));
        this.setModal(true);
        this.setWidth(500);
        this.setHeight(150);
        List versionNumbers = (List)JahiaGWTParameters.getSiteNode().get("j:versionNumbers");
        FormPanel formPanel = new FormPanel();
        formPanel.setHeaderVisible(false);
        formPanel.setLabelWidth(150);
        formPanel.setButtonAlign(Style.HorizontalAlignment.CENTER);
        final SimpleComboBox cbNextVersion = new SimpleComboBox();
        cbNextVersion.setFieldLabel(Messages.get("label.nextVersion", "Next iteration version"));
        cbNextVersion.setTriggerAction(ComboBox.TriggerAction.ALL);
        cbNextVersion.setForceSelection(false);
        String minorVersion = this.generateVersionNumber(versionNumbers, 1);
        cbNextVersion.add((Object)minorVersion);
        cbNextVersion.add((Object)this.generateVersionNumber(versionNumbers, 0));
        cbNextVersion.setSimpleValue((Object)minorVersion);
        formPanel.add((Widget)cbNextVersion);
        final FieldSet fs = new FieldSet();
        fs.setCheckboxToggle(true);
        FormLayout fl = new FormLayout();
        fl.setLabelWidth(100);
        fl.setDefaultWidth(330);
        fs.setLayout((Layout)fl);
        final TextField tfUsername = new TextField();
        final TextField tfPassword = new TextField();
        tfUsername.setFieldLabel(Messages.get("label.username", "Username"));
        tfPassword.setFieldLabel(Messages.get("label.password", "Password"));
        tfPassword.setPassword(true);
        this.setHeight(300);
        if (this.releaseInfo.getForgeUrl() != null) {
            fs.setHeadingHtml(Messages.get("label.releaseModule.publishToModuleForge", "Publish to module Private App Store"));
            LabelField lbCatalogUrl = new LabelField();
            lbCatalogUrl.setToolTip(this.releaseInfo.getForgeUrl());
            lbCatalogUrl.setValue((Object)this.releaseInfo.getForgeUrl());
            lbCatalogUrl.setFieldLabel(Messages.get("label.url", "URL") + ":");
            fs.add((Widget)lbCatalogUrl);
            tfUsername.setValue((Object)ForgeLoginWindow.username);
            tfPassword.setValue((Object)ForgeLoginWindow.password);
            formPanel.add((Widget)fs);
        } else if (this.releaseInfo.getRepositoryUrl() != null) {
            fs.setHeadingHtml(Messages.get("label.releaseModule.publishToMaven", "Publish to Maven distribution server"));
            if (this.releaseInfo.getRepositoryId() != null) {
                LabelField lbRepoId = new LabelField();
                lbRepoId.setValue((Object)this.releaseInfo.getRepositoryId());
                lbRepoId.setFieldLabel(Messages.get("label.id", "ID") + ":");
                fs.add((Widget)lbRepoId);
            }
            LabelField lbRepoUrl = new LabelField();
            lbRepoUrl.setToolTip(this.releaseInfo.getRepositoryUrl());
            lbRepoUrl.setValue((Object)this.releaseInfo.getRepositoryUrl());
            lbRepoUrl.setFieldLabel(Messages.get("label.url", "URL") + ":");
            fs.add((Widget)lbRepoUrl);
            formPanel.add((Widget)fs);
        }
        fs.add((Widget)tfUsername);
        fs.add((Widget)tfPassword);
        Button b = new Button(Messages.get("label.release", "Release"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                String v = cbNextVersion.getRawValue();
                if (v == null || v.length() == 0 || !v.endsWith("-SNAPSHOT")) {
                    cbNextVersion.markInvalid(Messages.get("label.snapshotRequired", "Working version number must end with -SNAPSHOT"));
                    return;
                }
                ReleaseModuleWindow.this.releaseInfo.setNextVersion(cbNextVersion.getRawValue());
                ReleaseModuleWindow.this.releaseInfo.setPublishToForge(ReleaseModuleWindow.this.releaseInfo.getForgeUrl() != null && fs.isVisible() && fs.isExpanded());
                ReleaseModuleWindow.this.releaseInfo.setPublishToMaven(ReleaseModuleWindow.this.releaseInfo.getRepositoryUrl() != null && fs.isVisible() && fs.isExpanded());
                ReleaseModuleWindow.this.releaseInfo.setUsername((String)tfUsername.getValue());
                ReleaseModuleWindow.this.releaseInfo.setPassword((String)tfPassword.getValue());
                if (ReleaseModuleWindow.this.releaseInfo.isPublishToForge()) {
                    ForgeLoginWindow.username = (String)tfUsername.getValue();
                    ForgeLoginWindow.password = (String)tfPassword.getValue();
                }
                ReleaseModuleWindow.this.callback.handle(ReleaseModuleWindow.this.releaseInfo);
            }
        });
        b.addStyleName("button-release");
        formPanel.addButton(b);
        final ReleaseModuleWindow w = this;
        b = new Button(Messages.get("label.cancel", "Cancel"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                w.hide();
            }
        });
        b.addStyleName("button-cancel");
        formPanel.addButton(b);
        this.add((Component)formPanel);
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public static interface Callback {
        public void handle(GWTModuleReleaseInfo var1);
    }
}

