/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.toolbar.action.NodeTypeAwareBaseActionItem;

public class SwitchModeActionItem
extends NodeTypeAwareBaseActionItem {
    private static final long serialVersionUID = 4479018020274946474L;
    private boolean openInNewWindow;
    private boolean showOpenInNewWindowSubmenu = true;

    @Override
    public void handleNewLinkerSelection() {
        if (this.showOpenInNewWindowSubmenu) {
            Menu m = new Menu();
            MenuItem menuItem = new MenuItem(Messages.get("label.openInNewWindow", "Open in new window"));
            menuItem.setIcon(ToolbarIconProvider.getInstance().getIcon("openWindow"));
            menuItem.addStyleName(this.getGwtToolbarItem().getClassName() + "-openWindow");
            menuItem.addSelectionListener((SelectionListener)new SelectionListener<MenuEvent>(){

                public void componentSelected(MenuEvent ce) {
                    SwitchModeActionItem.this.onComponentSelection(true);
                }
            });
            m.add((Component)menuItem);
            this.setSubMenu(m);
        }
        String workspace = this.getPropertyValue(this.getGwtToolbarItem(), "workspace");
        if (this.linker instanceof EditLinker && ((EditLinker)this.linker).isInSettingsPage() || !this.hasPermission(this.linker.getSelectionContext().getMainNode()) || !this.isNodeTypeAllowed(this.linker.getSelectionContext().getMainNode())) {
            this.setEnabled(false);
        } else if (workspace.equalsIgnoreCase("live")) {
            GWTJahiaNode node = this.linker.getSelectionContext().getMainNode();
            if (node == null) {
                this.setEnabled(false);
            } else {
                GWTJahiaPublicationInfo publicationInfo;
                GWTJahiaPublicationInfo gWTJahiaPublicationInfo = publicationInfo = node.getAggregatedPublicationInfo() != null ? node.getAggregatedPublicationInfo() : node.getQuickPublicationInfo();
                if (publicationInfo.getStatus() == 4 || publicationInfo.getStatus() == 5) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                }
            }
        } else {
            this.setEnabled(true);
        }
    }

    @Override
    public void onComponentSelection() {
        this.onComponentSelection(this.openInNewWindow);
    }

    private void onComponentSelection(final boolean openWindow) {
        String workspace = this.getPropertyValue(this.getGwtToolbarItem(), "workspace");
        final String urlParams = this.getPropertyValue(this.getGwtToolbarItem(), "urlParams");
        String servlet = this.getPropertyValue(this.getGwtToolbarItem(), "servlet");
        GWTJahiaNode node = this.linker.getSelectionContext().getMainNode();
        if (node != null) {
            String path = node.getPath();
            String locale = JahiaGWTParameters.getLanguage();
            JahiaContentManagementService.App.getInstance().getNodeURL(servlet, path, null, null, workspace, locale, false, (AsyncCallback<String>)new BaseAsyncCallback<String>(){

                public void onSuccess(String url) {
                    String url1 = url + (urlParams != null ? "?" + urlParams : "");
                    if (openWindow) {
                        Window.open((String)url1, (String)"_blank", (String)"");
                    } else {
                        Window.Location.assign((String)url1);
                    }
                }

                @Override
                public void onApplicationFailure(Throwable caught) {
                    Window.alert((String)Messages.get("label.error.404.title"));
                    SwitchModeActionItem.this.setEnabled(false);
                }
            });
        }
    }

    public void setOpenInNewWindow(boolean openInNewWindow) {
        this.openInNewWindow = openInNewWindow;
    }

    public void setShowOpenInNewWindowSubmenu(boolean showOpenInNewWindowSubmenu) {
        this.showOpenInNewWindowSubmenu = showOpenInNewWindowSubmenu;
    }
}

