/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Module;
import org.jahia.ajax.gwt.client.widget.toolbar.action.ViewStatusActionItem;

public class ViewPublishStatusActionItem
extends ViewStatusActionItem {
    @Override
    public void viewStatus(final List<Module> moduleList) {
        final HashMap<String, Module> modules = new HashMap<String, Module>();
        for (Module module : moduleList) {
            if (module.getNode() == null) continue;
            modules.put(module.getNode().getPath(), module);
        }
        this.linker.loading(Messages.get("label.gettingPublicationInfo", "Getting publication information"));
        JahiaContentManagementService.App.getInstance().getNodes(new ArrayList<String>(modules.keySet()), Arrays.asList("publicationInfo"), (AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

            public void onSuccess(List<GWTJahiaNode> result) {
                ViewPublishStatusActionItem.this.linker.loaded();
                Listener<ComponentEvent> removeListener = ViewPublishStatusActionItem.this.createRemoveListener();
                String lastUnpublished = null;
                boolean allPublished = true;
                for (GWTJahiaNode node : result) {
                    Module module = (Module)((Object)modules.get(node.getPath()));
                    GWTJahiaPublicationInfo info = node.getAggregatedPublicationInfo();
                    if (info.getStatus() == 1 || info.isWorkInProgress().booleanValue()) continue;
                    allPublished = false;
                    if (lastUnpublished != null && node.getPath().startsWith(lastUnpublished)) continue;
                    String label = GWTJahiaPublicationInfo.statusToLabel.get(info.getStatus());
                    String status = Messages.get("label.publication." + label, label);
                    if (info.isLocked().booleanValue()) {
                        ViewPublishStatusActionItem.this.infoLayers.addInfoLayer(module, Messages.get("label.publication.locked", "locked"), "orange", "orange", removeListener, true, "0.7");
                        continue;
                    }
                    if (info.getStatus() == 4 || info.getStatus() == 5) {
                        lastUnpublished = node.getPath();
                        ViewPublishStatusActionItem.this.infoLayers.addInfoLayer(module, status, "black", "black", removeListener, false, "0.7");
                        continue;
                    }
                    if (info.getStatus() == 3) {
                        ViewPublishStatusActionItem.this.infoLayers.addInfoLayer(module, status, "red", "red", removeListener, true, "0.7");
                        continue;
                    }
                    if (info.getStatus() == 7) {
                        ViewPublishStatusActionItem.this.infoLayers.addInfoLayer(module, status, "blue", "blue", removeListener, true, "0.7");
                        continue;
                    }
                    if (info.getStatus() == 9) {
                        ViewPublishStatusActionItem.this.infoLayers.addInfoLayer(module, status, "red", "red", removeListener, true, "0.7");
                        continue;
                    }
                    if (info.getStatus() == 6) {
                        ViewPublishStatusActionItem.this.infoLayers.addInfoLayer(module, status, "red", "red", removeListener, true, "0.7");
                        continue;
                    }
                    if (info.getStatus() != 10) continue;
                    ViewPublishStatusActionItem.this.infoLayers.addInfoLayer(module, status, "red", "red", removeListener, true, "0.7");
                }
                if (allPublished) {
                    ViewPublishStatusActionItem.this.infoLayers.addInfoLayer((Module)((Object)moduleList.iterator().next()), Messages.get("everything.published", "Everything published"), "black", "white", removeListener, false, "0.7");
                }
            }
        });
    }
}

