/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.jndi;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.naming.Reference;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.core.JahiaRepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.jndi.BindableRepository;

public class JahiaBindableRepository
extends BindableRepository {
    private static final long serialVersionUID = -6081646750488342618L;

    public JahiaBindableRepository(Reference reference) throws RepositoryException {
        super(reference);
    }

    protected JackrabbitRepository createRepository() throws RepositoryException {
        RepositoryConfig config = RepositoryConfig.create((String)this.resolvePath(this.getReference().get("configFilePath").getContent().toString()), (String)this.resolvePath(this.getReference().get("repHomeDir").getContent().toString()));
        return JahiaRepositoryImpl.create(config);
    }

    public String resolvePath(String path) {
        Pattern p = Pattern.compile("(.*)\\$\\{(.*)\\}(.*)");
        Matcher m = p.matcher(path);
        while (m.matches()) {
            String key = m.group(2);
            String value = System.getProperty(key);
            if (value == null) {
                value = System.getenv(key);
            }
            path = value != null ? m.group(1) + value + m.group(3) : m.group(1) + m.group(3);
            m.reset();
            m = p.matcher(path);
        }
        return path;
    }
}

