/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.commons.server;

import com.google.gwt.user.client.rpc.RemoteService;
import java.util.Locale;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.jahia.ajax.gwt.client.core.SessionExpirationException;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.commons.server.RequestResponseAware;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.preferences.user.UserPreferencesHelper;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;

public abstract class JahiaRemoteService
implements RemoteService,
ServletContextAware,
RequestResponseAware {
    private static final transient Logger logger = LoggerFactory.getLogger(JahiaRemoteService.class);
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletContext servletContext;

    protected JCRSessionWrapper retrieveCurrentSession() throws GWTJahiaServiceException {
        return this.retrieveCurrentSession(this.getLocale());
    }

    protected JCRSessionWrapper retrieveCurrentSession(Locale locale) throws GWTJahiaServiceException {
        return this.retrieveCurrentSession(this.getWorkspace(), locale, false);
    }

    protected JCRSessionWrapper retrieveCurrentSession(String workspace, Locale locale, boolean useSiteFallbackLanguage) throws GWTJahiaServiceException {
        this.checkSession();
        try {
            return JCRSessionFactory.getInstance().getCurrentUserSession(workspace, locale, useSiteFallbackLanguage ? this.getFallbackLocale() : null);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.cannot.open.user.session", this.getUILocale()));
        }
    }

    protected Locale getLocale() {
        return LanguageCodeConverters.languageCodeToLocale(this.request.getParameter("lang"));
    }

    private Locale getFallbackLocale() throws GWTJahiaServiceException {
        Locale fallback = null;
        try {
            String siteParam = this.request.getParameter("site");
            if (siteParam == null) {
                return null;
            }
            JCRSiteNode site = (JCRSiteNode)JCRSessionFactory.getInstance().getCurrentUserSession(this.getWorkspace()).getNodeByUUID(siteParam);
            if (site.isMixLanguagesActive()) {
                fallback = LanguageCodeConverters.getLocaleFromCode(site.getDefaultLanguage());
            }
            return fallback;
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.cannot.open.user.session", this.getUILocale()));
        }
    }

    protected JCRSiteNode getSite() {
        try {
            String site = this.request.getParameter("site");
            if (!StringUtils.isEmpty((String)site)) {
                return (JCRSiteNode)this.retrieveCurrentSession().getNodeByUUID(site);
            }
            return (JCRSiteNode)this.retrieveCurrentSession().getNode(JCRContentUtils.getSystemSitePath());
        }
        catch (Exception e) {
            logger.error("Cannot get site", (Throwable)e);
            return null;
        }
    }

    protected String getWorkspace() {
        String workspace = this.request.getParameter("workspace");
        if (!StringUtils.isEmpty((String)workspace)) {
            return workspace;
        }
        return "default";
    }

    protected Locale getUILocale() throws GWTJahiaServiceException {
        Locale locale;
        Locale sessionLocale = (Locale)this.getSession().getAttribute("org.jahia.services.multilang.uilocale");
        JCRUserNode remoteJahiaUserNode = this.getRemoteJahiaUserNode();
        Locale locale2 = locale = sessionLocale != null ? UserPreferencesHelper.getPreferredLocale(remoteJahiaUserNode, sessionLocale) : UserPreferencesHelper.getPreferredLocale(remoteJahiaUserNode, LanguageCodeConverters.resolveLocaleForGuest(this.request));
        if (locale == null) {
            if (!JahiaUserManagerService.isGuest(this.getRemoteJahiaUser())) {
                locale = UserPreferencesHelper.getPreferredLocale(remoteJahiaUserNode);
            }
            if (locale == null) {
                locale = this.getLocale();
            }
            this.request.getSession(false).setAttribute("org.jahia.services.multilang.uilocale", (Object)locale);
        }
        return locale;
    }

    protected JahiaUser getRemoteJahiaUser() {
        return JCRSessionFactory.getInstance().getCurrentUser();
    }

    protected JCRUserNode getRemoteJahiaUserNode() {
        JahiaUser jUser = this.getRemoteJahiaUser();
        if (jUser == null) {
            return null;
        }
        return JahiaUserManagerService.getInstance().lookupUserByPath(jUser.getLocalPath());
    }

    protected String getRemoteUser() {
        JahiaUser jUser = this.getRemoteJahiaUser();
        if (jUser != null) {
            return jUser.getUserKey();
        }
        return null;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected HttpSession getSession() throws SessionExpirationException {
        this.checkSession();
        return this.getRequest().getSession();
    }

    private void checkSession() throws SessionExpirationException {
        if (this.request.getSession(false) == null) {
            throw new SessionExpirationException();
        }
    }
}

