/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.FindUsersAndGroups;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindUsersAndGroupsInAcl
extends FindUsersAndGroups {
    private static final Logger logger = LoggerFactory.getLogger(FindUsersAndGroupsInAcl.class);

    public static String getFindUsersAndGroupsInAclServletPath() {
        return "/cms/findUsersAndGroupsInAcl";
    }

    protected Set<JCRNodeWrapper> findMatchingPrincipals(List<Map<String, Object>> rolesForNode, String queryTerm) {
        if (rolesForNode.isEmpty()) {
            return Collections.emptySet();
        }
        Pattern pattern = Pattern.compile(queryTerm, 2);
        HashSet<JCRNodeWrapper> matching = new HashSet<JCRNodeWrapper>();
        for (Map<String, Object> principalEntry : rolesForNode) {
            JCRNodeWrapper principal = (JCRNodeWrapper)principalEntry.get("principal");
            if ("user".equals(principalEntry.get("principalType"))) {
                if (!this.userMatches((JCRUserNode)principal, pattern)) continue;
                matching.add(principal);
                continue;
            }
            if ("group".equals(principalEntry.get("principalType"))) {
                if (!this.groupMatches((JCRGroupNode)principal, pattern)) continue;
                matching.add(principal);
                continue;
            }
            logger.warn("Unknown principal type for entry {}. Skipping.", principalEntry);
        }
        return matching;
    }

    protected boolean groupMatches(JCRGroupNode group, Pattern pattern) {
        boolean matches = false;
        for (String prop : this.groupSearchProperties) {
            try {
                String value = "groupname".equals(prop) ? group.getName() : (group.hasProperty(prop) ? group.getProperty(prop).getString() : null);
                if (!StringUtils.isNotEmpty((String)value) || !pattern.matcher(value).matches()) continue;
                matches = true;
                break;
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return matches;
    }

    @Override
    protected Set<JCRNodeWrapper> search(String queryTerm, HttpServletRequest request) {
        String sourceNodePath = FindUsersAndGroupsInAcl.getParameter(request, "sourceNode");
        queryTerm = queryTerm.contains("*") ? StringUtils.replace((String)queryTerm, (String)"*", (String)".*") : queryTerm + ".*";
        JCRNodeWrapper sourceNode = null;
        try {
            sourceNode = JCRSessionFactory.getInstance().getCurrentUserSession().getNode(sourceNodePath);
        }
        catch (PathNotFoundException e) {
            throw new JahiaBadRequestException("Source node " + sourceNodePath + " cannot be found", e);
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
        List<Map<String, Object>> rolesForNode = JCRContentUtils.getRolesForNode(sourceNode, Boolean.valueOf(FindUsersAndGroupsInAcl.getParameter(request, "includeInherited", "false")), true, FindUsersAndGroupsInAcl.getParameter(request, "roles", null), -1, false);
        rolesForNode.addAll(JCRContentUtils.getRolesForNode(sourceNode, Boolean.valueOf(FindUsersAndGroupsInAcl.getParameter(request, "includeInherited", "false")), false, FindUsersAndGroupsInAcl.getParameter(request, "roles", null), -1, false));
        Set<JCRNodeWrapper> result = this.findMatchingPrincipals(rolesForNode, queryTerm);
        if (logger.isDebugEnabled()) {
            logger.debug("Found {} matching principals in ACL of the node {}", (Object)result.size(), (Object)sourceNodePath);
        }
        return result;
    }

    protected boolean userMatches(JCRUserNode user, Pattern pattern) {
        boolean matches = false;
        for (String prop : this.searchProperties) {
            try {
                String value = "username".equals(prop) ? user.getName() : (user.hasProperty(prop) ? user.getProperty(prop).getString() : null);
                if (!StringUtils.isNotEmpty((String)value) || !pattern.matcher(value).matches()) continue;
                matches = true;
                break;
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return matches;
    }
}

