/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.Action;
import org.jahia.bin.ActionResult;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;

public abstract class SystemAction
extends Action {
    @Override
    public ActionResult doExecute(final HttpServletRequest req, final RenderContext renderContext, final Resource resource, JCRSessionWrapper session, final Map<String, List<String>> parameters, final URLResolver urlResolver) throws Exception {
        return JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(JCRSessionFactory.getInstance().getCurrentUser(), session.getWorkspace().getName(), session.getLocale(), new JCRCallback<ActionResult>(){

            @Override
            public ActionResult doInJCR(JCRSessionWrapper session) throws RepositoryException {
                try {
                    Resource systemResource = null;
                    if (resource != null) {
                        systemResource = new Resource(session.getNode(resource.getNode().getPath()), resource.getTemplateType(), resource.getTemplate(), resource.getContextConfiguration());
                    }
                    return SystemAction.this.doExecuteAsSystem(req, renderContext, session, systemResource, parameters, urlResolver);
                }
                catch (Exception e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
        });
    }

    public abstract ActionResult doExecuteAsSystem(HttpServletRequest var1, RenderContext var2, JCRSessionWrapper var3, Resource var4, Map<String, List<String>> var5, URLResolver var6) throws Exception;
}

