/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.jahia.bin.JahiaController;
import org.jahia.services.textextraction.TextExtractionService;
import org.jahia.settings.SettingsBean;
import org.jahia.tools.files.FileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.InternalResourceView;

public class TextExtractor
extends JahiaController {
    private static Logger logger = LoggerFactory.getLogger(TextExtractor.class);
    private SettingsBean settingsBean;
    private TextExtractionService textExtractionService;
    private View view;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.textExtractionService.isEnabled()) {
            response.sendError(400, "Text extraction service is not enabled.");
            return null;
        }
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            response.sendError(400, "No file was submitted");
            return null;
        }
        FileUpload upload = new FileUpload(request, this.settingsBean.getTmpContentDiskPath(), Integer.MAX_VALUE);
        if (upload.getFileItems().size() == 0) {
            response.sendError(400, "No file was submitted");
            return null;
        }
        DiskFileItem inputFile = upload.getFileItems().values().iterator().next();
        InputStream stream = null;
        try {
            stream = inputFile.getInputStream();
            Metadata metadata = new Metadata();
            metadata.set("Content-Type", inputFile.getContentType());
            metadata.set("resourceName", inputFile.getName());
            long startTime = System.currentTimeMillis();
            String content = this.textExtractionService.parse(stream, metadata);
            HashMap<String, Object> model = new HashMap<String, Object>();
            HashMap<String, String[]> properties = new HashMap<String, String[]>();
            for (String name : metadata.names()) {
                properties.put(name, (String[])(metadata.isMultiValued(name) ? metadata.getValues(name) : metadata.get(name)));
            }
            model.put("metadata", properties);
            model.put("content", content);
            model.put("file", inputFile);
            model.put("extracted", Boolean.TRUE);
            model.put("extractionTime", System.currentTimeMillis() - startTime);
            ModelAndView modelAndView = new ModelAndView(this.view, model);
            return modelAndView;
        }
        catch (Exception e) {
            logger.error("Error extracting text for uploaded file " + inputFile.getFieldName() + ". Cause: " + e.getMessage(), (Throwable)e);
            response.sendError(500, "Exception occurred: " + e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
            for (DiskFileItem file : upload.getFileItems().values()) {
                file.delete();
            }
        }
        return null;
    }

    public void setSettingsBean(SettingsBean settingsBean) {
        this.settingsBean = settingsBean;
    }

    public void setTextExtractionService(TextExtractionService textExtractionService) {
        this.textExtractionService = textExtractionService;
    }

    public void setView(String view) {
        this.view = new InternalResourceView(view);
    }
}

