/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.errors;

import java.io.IOException;
import java.io.StringWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.iterators.EnumerationIterator;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.errors.ErrorFileDumper;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorLoggingFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(ErrorLoggingFilter.class);
    private static Throwable previousException = null;
    private static int previousExceptionOccurrences = 0;

    public void destroy() {
        ErrorFileDumper.shutdown();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Boolean alreadyForwarded = (Boolean)request.getAttribute("org.jahia.exception.forwarded");
        if (alreadyForwarded == null || !alreadyForwarded.booleanValue()) {
            ErrorLoggingFilter.handle((HttpServletRequest)request, (HttpServletResponse)response);
        }
        filterChain.doFilter(request, response);
    }

    protected static void dumpToFile(HttpServletRequest request) {
        if (ErrorFileDumper.isShutdown()) {
            return;
        }
        try {
            Throwable t = ErrorLoggingFilter.getException(request);
            int code = (Integer)request.getAttribute("javax.servlet.error.status_code");
            int n = code = code != 0 ? code : 500;
            if (code < 500) {
                logger.debug("Status code below 500, will not dump error to file");
                return;
            }
            ErrorFileDumper.dumpToFile(t, request);
        }
        catch (Exception throwable) {
            logger.warn("Error creating error file", (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void emailAlert(HttpServletRequest request, HttpServletResponse response) {
        Throwable exception = ErrorLoggingFilter.getException(request);
        try {
            Class<ErrorLoggingFilter> clazz = ErrorLoggingFilter.class;
            synchronized (ErrorLoggingFilter.class) {
                if (previousException != null && exception != null && exception.toString().equals(previousException.toString()) && ++previousExceptionOccurrences < SettingsBean.getInstance().getMail_maxRegroupingOfPreviousException()) {
                    // ** MonitorExit[var5_3] (shouldn't be in output)
                    return;
                }
                Throwable previousExceptionToMail = previousException;
                int previousExceptionOccurrencesToMail = previousExceptionOccurrences;
                previousException = exception;
                previousExceptionOccurrences = 1;
                // ** MonitorExit[var5_3] (shouldn't be in output)
                StringWriter msgBodyWriter = ErrorFileDumper.generateErrorReport(new ErrorFileDumper.HttpRequestData(request), exception, previousExceptionOccurrencesToMail, previousExceptionToMail);
                ServicesRegistry.getInstance().getMailService().sendMessage(null, null, null, null, "Server Error: " + (exception != null ? exception.getMessage() : ""), msgBodyWriter.toString());
                logger.debug("Mail was sent successfully.");
            }
        }
        catch (Exception ex) {
            logger.warn("Error sending an e-mail alert: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected static Throwable getException(HttpServletRequest request) {
        Throwable ex = (Throwable)request.getAttribute("javax.servlet.error.exception");
        ex = ex != null ? ex : (Throwable)request.getAttribute("org.jahia.exception");
        return ex;
    }

    protected static String getLogMessage(HttpServletRequest request) {
        String requestInfo;
        Throwable ex = ErrorLoggingFilter.getException(request);
        String message = (String)request.getAttribute("javax.servlet.error.message");
        Integer code = (Integer)request.getAttribute("javax.servlet.error.status_code");
        switch (code) {
            case 404: {
                message = "Requested resource is not available: " + request.getAttribute("javax.servlet.error.request_uri");
                break;
            }
            case 401: {
                message = "Authorization required for resource: " + request.getAttribute("javax.servlet.error.request_uri");
                break;
            }
            case 403: {
                message = "Access denied for resource: " + request.getAttribute("javax.servlet.error.request_uri");
                break;
            }
            case 503: {
                message = "Service unavailable";
                break;
            }
            default: {
                if (StringUtils.isNotEmpty((String)message)) {
                    if (ex == null || !StringUtils.isNotEmpty((String)ex.getMessage()) || message.equals(ex.getMessage())) break;
                    message = message + ". Error message: " + ex.getMessage();
                    break;
                }
                message = ex != null && StringUtils.isNotEmpty((String)ex.getMessage()) ? ex.getMessage() : "Unexpected exception occurred";
            }
        }
        if (logger.isInfoEnabled() && (requestInfo = (String)request.getAttribute("org.jahia.exception.requestInfo")) != null) {
            message = message + "\n" + request.getAttribute("org.jahia.exception.requestInfo");
        }
        return message;
    }

    protected static void handle(HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("org.jahia.exception.requestInfo", (Object)ErrorLoggingFilter.getRequestInfo(request));
        ErrorLoggingFilter.logDebugInfo(request, response);
        if (503 == (Integer)request.getAttribute("javax.servlet.error.status_code") && (StringUtils.equals((String)"Jahia in under maintenance", (String)((String)request.getAttribute("javax.servlet.error.message"))) || StringUtils.equals((String)"Jahia License Violation", (String)((String)request.getAttribute("javax.servlet.error.message"))))) {
            return;
        }
        ErrorLoggingFilter.logException(request, response);
        ErrorLoggingFilter.dumpToFile(request);
        if (ErrorLoggingFilter.isMailServiceEnabled() && ErrorLoggingFilter.isEmailAlertRequired(request, response)) {
            ErrorLoggingFilter.emailAlert(request, response);
        }
    }

    public void init(FilterConfig cfg) throws ServletException {
    }

    protected static boolean isEmailAlertRequired(HttpServletRequest request, HttpServletResponse response) {
        Throwable error = ErrorLoggingFilter.getException(request);
        return error != null && error instanceof JahiaException && ServicesRegistry.getInstance().getMailService().getSettings().getNotificationSeverity() != 0 && ServicesRegistry.getInstance().getMailService().getSettings().getNotificationSeverity() <= ((JahiaException)error).getSeverity();
    }

    private static boolean isMailServiceEnabled() {
        return ServicesRegistry.getInstance().getMailService().isEnabled();
    }

    protected static void logDebugInfo(HttpServletRequest request, HttpServletResponse response) {
        if (logger.isDebugEnabled()) {
            logger.debug("Handling exception for request [" + request.getAttribute("javax.servlet.error.request_uri") + "]:\nStatus code: " + request.getAttribute("javax.servlet.error.status_code") + "\nError message: " + request.getAttribute("javax.servlet.error.message") + "\nException type: " + request.getAttribute("javax.servlet.error.exception_type") + "\nException: " + request.getAttribute("javax.servlet.error.exception") + "\nServlet name: " + request.getAttribute("javax.servlet.error.servlet_name"));
        }
    }

    protected static void logException(HttpServletRequest request, HttpServletResponse response) {
        Throwable ex = ErrorLoggingFilter.getException(request);
        int code = (Integer)request.getAttribute("javax.servlet.error.status_code");
        code = code != 0 ? code : 500;
        String message = ErrorLoggingFilter.getLogMessage(request);
        if (code >= 500) {
            if (ex != null) {
                logger.error(message, ex);
            } else {
                logger.error(message);
            }
        } else if (ex != null && logger.isDebugEnabled()) {
            logger.debug(message, ex);
        } else if (401 == code) {
            logger.info(message);
        } else {
            logger.warn("[Error code: " + code + "]" + (message != null && message.length() > 0 ? ": " + message : ""));
        }
    }

    private static String getRequestInfo(HttpServletRequest request) {
        StringBuilder info = new StringBuilder(512);
        if (request != null) {
            String uri = (String)request.getAttribute("javax.servlet.error.request_uri");
            String queryString = (String)request.getAttribute("javax.servlet.forward.query_string");
            if (StringUtils.isNotEmpty((String)queryString)) {
                uri = uri + "?" + queryString;
            }
            info.append("Request information:").append("\nURL: ").append(uri).append("\nMethod: ").append(request.getMethod()).append("\nProtocol: ").append(request.getProtocol()).append("\nRemote host: ").append(request.getRemoteHost()).append("\nRemote address: ").append(request.getRemoteAddr()).append("\nRemote port: ").append(request.getRemotePort()).append("\nRemote user: ").append(request.getRemoteUser()).append("\nSession ID: ").append(request.getRequestedSessionId()).append("\nSession user: ").append(ErrorLoggingFilter.getUserInfo(request)).append("\nRequest headers: ");
            EnumerationIterator headerNames = new EnumerationIterator(request.getHeaderNames());
            while (headerNames.hasNext()) {
                String headerName = (String)headerNames.next();
                String headerValue = request.getHeader(headerName);
                info.append("\n  ").append(headerName).append(": ").append(headerValue);
            }
        }
        return info.toString();
    }

    protected static String getUserInfo(HttpServletRequest request) {
        JahiaUser user = JCRSessionFactory.getInstance().getCurrentUser();
        if (user == null) {
            try {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    user = (JahiaUser)session.getAttribute("org.jahia.usermanager.jahiauser");
                }
            }
            catch (IllegalStateException session) {
                // empty catch block
            }
        }
        String info = user != null ? user.getUsername() : null;
        info = info != null ? info : String.valueOf(request.getUserPrincipal());
        return info;
    }
}

