/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.data.webapps;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jahia.data.webapps.Security_Role;
import org.jahia.data.webapps.Servlet_Element;
import org.jahia.exceptions.JahiaException;
import org.jahia.utils.xml.XMLParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Web_App_Xml {
    private static final int SERVLET_TYPE = 1;
    private static final int JSP_TYPE = 2;
    private String displayName;
    private String desc;
    private List<Servlet_Element> servlets = new ArrayList<Servlet_Element>();
    private Map<String, String> servletMappings = new HashMap<String, String>();
    private List<Security_Role> roles = new ArrayList<Security_Role>();
    private List<String> welcomeFiles = new ArrayList<String>();
    private Document xmlDocument;

    private Web_App_Xml(Document xmlDocument) {
        this.xmlDocument = xmlDocument;
    }

    public static Web_App_Xml parse(InputStream stream) throws JahiaException {
        Web_App_Xml xml;
        try {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dfactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Document xmlDocument = dfactory.newDocumentBuilder().parse(stream);
            xmlDocument.normalize();
            xml = new Web_App_Xml(xmlDocument);
            xml.extractDocumentData();
        }
        catch (Exception t) {
            throw new JahiaException("JahiaXmlDocument", "Exception while parsing web.xml stream", 2, 12, t);
        }
        return xml;
    }

    private void extractDocumentData() throws JahiaException {
        if (this.xmlDocument == null) {
            throw new JahiaException("Web_App_Xml", "Parsed web.xml document is null", 2, 11);
        }
        if (!this.xmlDocument.hasChildNodes()) {
            throw new JahiaException("Web_App_Xml", "Main document node has no children", 2, 11);
        }
        Element webAppNode = this.xmlDocument.getDocumentElement();
        if (!webAppNode.getNodeName().equalsIgnoreCase("web-app")) {
            throw new JahiaException("Invalid XML format", "web-app tag is not present as starting tag in file", 2, 11);
        }
        Node displayNameNode = XMLParser.nextChildOfTag(webAppNode, "display-name");
        this.displayName = this.getValue(this.displayName, displayNameNode);
        Node descriptionNode = XMLParser.nextChildOfTag(webAppNode, "description");
        this.desc = this.getValue(this.desc, descriptionNode);
        this.servlets = this.getServlets(webAppNode);
        this.servletMappings = this.getServletMappings(webAppNode);
        this.roles = this.getRoles(webAppNode);
        this.welcomeFiles = this.getWelcomeFiles(webAppNode);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    protected void setDisplayName(String name) {
        this.displayName = name;
    }

    public List<Servlet_Element> getServlets() {
        return this.servlets;
    }

    public Map<String, String> getServletMappings() {
        return this.servletMappings;
    }

    public List<String> getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public List<Security_Role> getRoles() {
        return this.roles;
    }

    public String getdesc() {
        return this.desc;
    }

    protected void setdesc(String descr) {
        this.desc = descr;
    }

    private List<Security_Role> getRoles(Node parentNode) throws JahiaException {
        List<Node> nodesList = XMLParser.getChildNodes(parentNode, "security-role");
        ArrayList<Security_Role> result = new ArrayList<Security_Role>();
        int size = nodesList.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                String name = "";
                String descr = "";
                Node nodeItem = nodesList.get(i);
                Node childNode = XMLParser.nextChildOfTag(nodeItem, "role-name");
                name = this.getValue(name, childNode);
                childNode = XMLParser.nextChildOfTag(nodeItem, "desc");
                descr = this.getValue(descr, childNode);
                if (name.length() <= 0) continue;
                Security_Role role = new Security_Role(name, descr);
                result.add(role);
            }
        }
        return result;
    }

    private List<Servlet_Element> getServlets(Node parentNode) throws JahiaException {
        ArrayList<Servlet_Element> result = new ArrayList<Servlet_Element>();
        List<Node> nodesList = XMLParser.getChildNodes(parentNode, "servlet");
        int size = nodesList.size();
        if (size > 0) {
            String servletName = "";
            String descr = "";
            for (int i = 0; i < size; ++i) {
                int servletType;
                String servletsrc;
                Node nodeItem = nodesList.get(i);
                Node childNode = XMLParser.nextChildOfTag(nodeItem, "servlet-name");
                servletName = this.getValue(servletName, childNode);
                childNode = XMLParser.nextChildOfTag(nodeItem, "display-name");
                String servletDisplayName = childNode != null ? childNode.getFirstChild().getNodeValue().trim() : servletName;
                childNode = XMLParser.nextChildOfTag(nodeItem, "desc");
                descr = this.getValue(descr, childNode);
                if (XMLParser.nextChildOfTag(nodeItem, "servlet-class") != null) {
                    servletsrc = XMLParser.nextChildOfTag(nodeItem, "servlet-class").getFirstChild().getNodeValue().trim();
                    servletType = 1;
                } else {
                    servletsrc = XMLParser.nextChildOfTag(nodeItem, "jsp-file").getFirstChild().getNodeValue().trim();
                    servletType = 2;
                }
                if (servletDisplayName == null || servletDisplayName.length() <= 0 || servletName == null || servletName.length() <= 0 || servletsrc == null || servletsrc.length() <= 0) continue;
                Servlet_Element servlet = new Servlet_Element(servletName, servletDisplayName, descr, servletsrc, servletType, i + 1);
                result.add(servlet);
            }
        }
        return result;
    }

    private String getValue(String servletName, Node childNode) {
        if (childNode != null) {
            servletName = childNode.getFirstChild().getNodeValue().trim();
        }
        return servletName;
    }

    private List<String> getWelcomeFiles(Node parentNode) throws JahiaException {
        ArrayList<String> results = new ArrayList<String>();
        Node welcomeFileListNode = XMLParser.nextChildOfTag(parentNode, "welcome-file-list");
        if (welcomeFileListNode == null) {
            return results;
        }
        List<Node> nodesList = XMLParser.getChildNodes(welcomeFileListNode, "welcome-file");
        int size = nodesList.size();
        if (size > 0) {
            Node nodeItem = null;
            String filename = "";
            for (int i = 0; i < size; ++i) {
                nodeItem = nodesList.get(i);
                filename = nodeItem.getFirstChild().getNodeValue().trim();
                if (filename.length() <= 0) continue;
                results.add(filename);
            }
        }
        return results;
    }

    private Map<String, String> getServletMappings(Node parentNode) throws JahiaException {
        HashMap<String, String> result = new HashMap<String, String>();
        List<Node> nodesList = XMLParser.getChildNodes(parentNode, "servlet-mapping");
        int size = nodesList.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                String servletName = "";
                String urlPattern = "";
                Node nodeItem = nodesList.get(i);
                Node childNode = XMLParser.nextChildOfTag(nodeItem, "servlet-name");
                servletName = this.getValue(servletName, childNode);
                childNode = XMLParser.nextChildOfTag(nodeItem, "url-pattern");
                urlPattern = this.getValue(urlPattern, childNode);
                if (servletName == null || servletName.length() <= 0 || urlPattern == null || urlPattern.length() <= 0) continue;
                result.put(urlPattern, servletName);
            }
        }
        return result;
    }
}

