/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jahia.jdbc.DelegatingConnection;
import org.jahia.jdbc.ReadOnlyModeAwareDataSource;
import org.jahia.jdbc.ReadOnlySQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReadOnlyModeAwareConnection
extends DelegatingConnection {
    final ReadOnlyModeStatus status;

    ReadOnlyModeAwareConnection(Connection connection, ReadOnlyModeStatus status) {
        super(connection);
        this.status = status;
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement statement = super.createStatement();
        return this.createProxy(statement);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement statement = super.prepareStatement(sql);
        return this.createProxy(statement, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement call = super.prepareCall(sql);
        return this.createProxy(call, sql);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement statement = super.createStatement(resultSetType, resultSetConcurrency);
        return this.createProxy(statement);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement statement = super.prepareStatement(sql, resultSetType, resultSetConcurrency);
        return this.createProxy(statement, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement call = super.prepareCall(sql, resultSetType, resultSetConcurrency);
        return this.createProxy(call, sql);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement statement = super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.createProxy(statement);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement statement = super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.createProxy(statement, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement call = super.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.createProxy(call, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement statement = super.prepareStatement(sql, autoGeneratedKeys);
        return this.createProxy(statement, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement statement = super.prepareStatement(sql, columnIndexes);
        return this.createProxy(statement, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement statement = super.prepareStatement(sql, columnNames);
        return this.createProxy(statement, sql);
    }

    private Statement createProxy(Statement statement) {
        ReadOnlyAwareStatementHandler handler = new ReadOnlyAwareStatementHandler(statement, this.status, null);
        return this.createProxy(Statement.class, handler);
    }

    private PreparedStatement createProxy(PreparedStatement statement, String sql) {
        ReadOnlyAwareStatementHandler handler = new ReadOnlyAwareStatementHandler(statement, this.status, sql, null);
        return this.createProxy(PreparedStatement.class, handler);
    }

    private CallableStatement createProxy(CallableStatement statement, String sql) {
        ReadOnlyAwareStatementHandler handler = new ReadOnlyAwareStatementHandler(statement, this.status, sql, null);
        return this.createProxy(CallableStatement.class, handler);
    }

    private <T extends Statement> T createProxy(Class<T> type, InvocationHandler handler) {
        return (T)((Statement)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{type}, handler));
    }

    static final class ReadOnlyAwareStatementHandler<T extends Statement>
    implements InvocationHandler {
        private static final Logger logger = LoggerFactory.getLogger(ReadOnlyModeAwareDataSource.class);
        private static final String GUARDED_OPERATION_PREFIX = "execute";
        private static final String ADD_BATCH_OPERATION = "addBatch";
        private static final String CLEAR_BATCH_OPERATION = "clearBatch";
        private final List<String> batches = new ArrayList<String>();
        private final String sql;
        private final T target;
        private final ReadOnlyModeStatus status;

        private ReadOnlyAwareStatementHandler(T target, ReadOnlyModeStatus status) {
            this(target, status, null);
        }

        private ReadOnlyAwareStatementHandler(T target, ReadOnlyModeStatus status, String sql) {
            this.target = target;
            this.status = status;
            this.sql = sql;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.status.isReadOnlyEnabled() && this.isGuardedOperation(method, args)) {
                this.logDismissedOperation(args);
                throw new ReadOnlySQLException();
            }
            Object result = method.invoke(this.target, args);
            if (ADD_BATCH_OPERATION.equals(method.getName())) {
                if (args != null && args.length > 0 && args[0] instanceof String) {
                    this.batches.add((String)args[0]);
                }
            } else if (CLEAR_BATCH_OPERATION.equals(method.getName())) {
                this.batches.clear();
            }
            return result;
        }

        private boolean isGuardedOperation(Method method, Object[] args) {
            if (method.getName().startsWith(GUARDED_OPERATION_PREFIX)) {
                if (args == null || args.length == 0) {
                    if (this.target instanceof CallableStatement || this.target instanceof PreparedStatement) {
                        return !this.isQueryAllowed(this.sql);
                    }
                    return this.batches.stream().anyMatch(s -> !this.isQueryAllowed((String)s));
                }
                if (args[0] instanceof String) {
                    return !this.isQueryAllowed((String)args[0]);
                }
            }
            return false;
        }

        private boolean isQueryAllowed(String sql) {
            return sql == null || sql.toLowerCase().startsWith("select ");
        }

        private void logDismissedOperation(Object[] args) {
            if (!logger.isDebugEnabled()) {
                return;
            }
            if (args == null || args.length == 0) {
                if (this.target instanceof CallableStatement || this.target instanceof PreparedStatement) {
                    logger.debug("Dismissed query: {}", (Object)this.sql);
                } else {
                    String queries = this.batches.stream().collect(Collectors.joining(",", "{", "}"));
                    logger.debug("Dismissed {} {}: {}", new Object[]{this.batches.size(), this.batches.size() > 1 ? "queries" : "query", queries});
                }
            } else {
                logger.debug("Dismissed query: {}", args[0]);
            }
        }

        /* synthetic */ ReadOnlyAwareStatementHandler(Statement x0, ReadOnlyModeStatus x1, 1 x2) {
            this(x0, x1);
        }

        /* synthetic */ ReadOnlyAwareStatementHandler(Statement x0, ReadOnlyModeStatus x1, String x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    @FunctionalInterface
    static interface ReadOnlyModeStatus {
        public boolean isReadOnlyEnabled();
    }
}

