/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jahia.bin.Login;
import org.jahia.osgi.FrameworkService;
import org.jahia.params.valves.AuthValveContext;
import org.jahia.params.valves.BaseAuthValve;
import org.jahia.params.valves.BaseLoginEvent;
import org.jahia.params.valves.CookieAuthConfig;
import org.jahia.params.valves.CookieAuthValveImpl;
import org.jahia.pipelines.PipelineException;
import org.jahia.pipelines.valves.ValveContext;
import org.jahia.security.license.LicenseCheckerService;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.preferences.user.UserPreferencesHelper;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginEngineAuthValveImpl
extends BaseAuthValve {
    public static final String ACCOUNT_LOCKED = "account_locked";
    public static final String BAD_PASSWORD = "bad_password";
    public static final String LOGGED_IN_USERS_LIMIT_REACHED = "logged_in_users_limit_reached";
    public static final String LOGIN_TAG_PARAMETER = "doLogin";
    public static final String OK = "ok";
    public static final String UNKNOWN_USER = "unknown_user";
    public static final String USE_COOKIE = "useCookie";
    public static final String VALVE_RESULT = "login_valve_result";
    private static final Logger logger = LoggerFactory.getLogger(LoginEngineAuthValveImpl.class);
    private CookieAuthConfig cookieAuthConfig;
    private boolean fireLoginEvent = false;
    private String preserveSessionAttributes = null;
    private JahiaUserManagerService userManagerService;

    public void setFireLoginEvent(boolean fireLoginEvent) {
        this.fireLoginEvent = fireLoginEvent;
    }

    public void setPreserveSessionAttributes(String preserveSessionAttributes) {
        this.preserveSessionAttributes = preserveSessionAttributes;
    }

    @Override
    public void invoke(Object context, ValveContext valveContext) throws PipelineException {
        if (!this.isEnabled()) {
            valveContext.invokeNext(context);
            return;
        }
        AuthValveContext authContext = (AuthValveContext)context;
        HttpServletRequest httpServletRequest = authContext.getRequest();
        JCRUserNode theUser = this.getJcrUserNode(httpServletRequest);
        if (theUser != null) {
            logger.debug("User {} logged in.", (Object)theUser);
            Map<String, Object> savedSessionAttributes = this.preserveSessionAttributes(httpServletRequest);
            JahiaUser jahiaUser = theUser.getJahiaUser();
            if (httpServletRequest.getSession(false) != null) {
                httpServletRequest.getSession().invalidate();
            }
            this.restoreSessionAttributes(httpServletRequest, savedSessionAttributes);
            httpServletRequest.setAttribute(VALVE_RESULT, (Object)OK);
            authContext.getSessionFactory().setCurrentUser(jahiaUser);
            if (SettingsBean.getInstance().isConsiderPreferredLanguageAfterLogin()) {
                Locale preferredUserLocale = UserPreferencesHelper.getPreferredLocale(theUser, LanguageCodeConverters.resolveLocaleForGuest(httpServletRequest));
                httpServletRequest.getSession().setAttribute("org.jahia.services.multilang.currentlocale", (Object)preferredUserLocale);
            }
            String useCookie = httpServletRequest.getParameter(USE_COOKIE);
            if (!SettingsBean.getInstance().isFullReadOnlyMode() && "on".equals(useCookie)) {
                CookieAuthValveImpl.createAndSendCookie(authContext, theUser, this.cookieAuthConfig);
            }
            if (this.fireLoginEvent) {
                SpringContextSingleton.getInstance().publishEvent(new LoginEvent(this, jahiaUser, authContext));
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("user", jahiaUser);
                m.put("authContext", authContext);
                m.put("source", this);
                FrameworkService.sendEvent("org/jahia/usersgroups/login/LOGIN", m, false);
            }
        } else {
            valveContext.invokeNext(context);
        }
    }

    private JCRUserNode getJcrUserNode(HttpServletRequest httpServletRequest) {
        if (this.isLoginRequested(httpServletRequest)) {
            String username = httpServletRequest.getParameter("username");
            String password = httpServletRequest.getParameter("password");
            String site = httpServletRequest.getParameter("site");
            if (username != null && password != null) {
                return this.getJcrUserNode(httpServletRequest, username, password, site);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JCRUserNode getJcrUserNode(HttpServletRequest httpServletRequest, String username, String password, String site) {
        JCRUserNode theUser = this.userManagerService.lookupUser(username, site);
        if (theUser != null) {
            if (theUser.verifyPassword(password)) {
                if (!theUser.isAccountLocked()) {
                    if (theUser.isRoot() || !LicenseCheckerService.Stub.isLoggedInUsersLimitReached()) return theUser;
                    logger.warn("The number of logged in users has reached the authorized limit.");
                    httpServletRequest.setAttribute(VALVE_RESULT, (Object)LOGGED_IN_USERS_LIMIT_REACHED);
                    return null;
                } else {
                    logger.warn("Login failed: account for user {} is locked.", (Object)theUser.getName());
                    httpServletRequest.setAttribute(VALVE_RESULT, (Object)ACCOUNT_LOCKED);
                }
                return null;
            } else {
                logger.warn("Login failed: password verification failed for user {}", (Object)theUser.getName());
                httpServletRequest.setAttribute(VALVE_RESULT, (Object)BAD_PASSWORD);
            }
            return null;
        } else {
            logger.debug("Login failed. Unknown username {}", (Object)username);
            httpServletRequest.setAttribute(VALVE_RESULT, (Object)UNKNOWN_USER);
        }
        return null;
    }

    private Map<String, Object> preserveSessionAttributes(HttpServletRequest httpServletRequest) {
        HashMap<String, Object> savedSessionAttributes = new HashMap<String, Object>();
        if (this.preserveSessionAttributes != null && httpServletRequest.getSession(false) != null && this.preserveSessionAttributes.length() > 0) {
            String[] sessionAttributeNames = Patterns.TRIPLE_HASH.split(this.preserveSessionAttributes);
            HttpSession session = httpServletRequest.getSession(false);
            for (String sessionAttributeName : sessionAttributeNames) {
                Object attributeValue = session.getAttribute(sessionAttributeName);
                if (attributeValue == null) continue;
                savedSessionAttributes.put(sessionAttributeName, attributeValue);
            }
        }
        return savedSessionAttributes;
    }

    private void restoreSessionAttributes(HttpServletRequest httpServletRequest, Map<String, Object> savedSessionAttributes) {
        if (savedSessionAttributes.size() > 0) {
            HttpSession session = httpServletRequest.getSession();
            for (Map.Entry<String, Object> savedSessionAttribute : savedSessionAttributes.entrySet()) {
                session.setAttribute(savedSessionAttribute.getKey(), savedSessionAttribute.getValue());
            }
        }
    }

    protected boolean isLoginRequested(HttpServletRequest request) {
        String doLogin = request.getParameter(LOGIN_TAG_PARAMETER);
        if (doLogin != null) {
            return Boolean.valueOf(doLogin) != false || "1".equals(doLogin);
        }
        if ("/cms".equals(request.getServletPath())) {
            return Login.getMapping().equals(request.getPathInfo());
        }
        return false;
    }

    public void setCookieAuthConfig(CookieAuthConfig cookieAuthConfig) {
        this.cookieAuthConfig = cookieAuthConfig;
    }

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }

    public class LoginEvent
    extends BaseLoginEvent {
        private static final long serialVersionUID = -7356560804745397662L;

        public LoginEvent(Object source, JahiaUser jahiaUser, AuthValveContext authValveContext) {
            super(source, jahiaUser, authValveContext);
        }
    }
}

