/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.params.valves.LogoutUrlProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class LogoutConfig
implements ApplicationListener<ApplicationEvent> {
    private static final Logger logger = LoggerFactory.getLogger(LogoutConfig.class);
    private LinkedList<LogoutUrlProvider> logoutUrlProviders = new LinkedList();

    public static LogoutConfig getInstance() {
        return Holder.INSTANCE;
    }

    private LogoutConfig() {
    }

    public String getCustomLogoutUrl(HttpServletRequest request) {
        return this.logoutUrlProviders.isEmpty() ? null : this.logoutUrlProviders.getFirst().getLogoutUrl(request);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        Map beansOfType = null;
        if (event instanceof JahiaContextLoaderListener.RootContextInitializedEvent) {
            JahiaContextLoaderListener.RootContextInitializedEvent rootContextInitializedEvent = (JahiaContextLoaderListener.RootContextInitializedEvent)event;
            beansOfType = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)rootContextInitializedEvent.getContext(), LogoutUrlProvider.class);
        } else if (event instanceof ContextRefreshedEvent) {
            ContextRefreshedEvent contextRefreshedEvent = (ContextRefreshedEvent)event;
            beansOfType = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)contextRefreshedEvent.getApplicationContext(), LogoutUrlProvider.class);
        }
        if (beansOfType != null && !beansOfType.isEmpty()) {
            for (LogoutUrlProvider provider : beansOfType.values()) {
                this.osgiBind(provider);
            }
        }
    }

    public void osgiBind(LogoutUrlProvider provider) {
        if (provider != null && provider.hasCustomLogoutUrl()) {
            logger.info("Using login URL provider {}", (Object)provider);
            this.logoutUrlProviders.addFirst(provider);
        }
    }

    public void osgiUnbind(LogoutUrlProvider provider) {
        if (provider != null && provider.hasCustomLogoutUrl()) {
            logger.info("Using login URL provider {}", (Object)provider);
            this.logoutUrlProviders.remove(provider);
        }
    }

    private static class Holder {
        static final LogoutConfig INSTANCE = new LogoutConfig();

        private Holder() {
        }
    }
}

