/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.registries;

import java.util.Collection;
import org.apache.commons.collections.FastHashMap;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.JahiaService;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.applications.ApplicationsManagerService;
import org.jahia.services.applications.DispatchingService;
import org.jahia.services.cache.CacheService;
import org.jahia.services.categories.CategoryService;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.JCRVersionService;
import org.jahia.services.deamons.filewatcher.JahiaFileWatcherService;
import org.jahia.services.importexport.ImportExportBaseService;
import org.jahia.services.mail.MailService;
import org.jahia.services.preferences.JahiaPreferencesService;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicyService;
import org.jahia.services.query.QueryService;
import org.jahia.services.scheduler.SchedulerService;
import org.jahia.services.search.SearchService;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ServicesRegistry {
    private static transient Logger logger = LoggerFactory.getLogger(ServicesRegistry.class);
    private static ServicesRegistry theObject = new ServicesRegistry();
    private FastHashMap servicesCache = new FastHashMap();

    public static ServicesRegistry getInstance() {
        return theObject;
    }

    public void init() throws JahiaException {
        this.getServiceInstances();
    }

    public Collection<? extends JahiaService> getServiceInstances() {
        return SpringContextSingleton.getInstance().getContext().getBeansOfType(JahiaService.class).values();
    }

    public JahiaService getService(String serviceName) {
        JahiaService jahiaService = (JahiaService)this.servicesCache.get((Object)serviceName);
        if (jahiaService != null) {
            return jahiaService;
        }
        ApplicationContext context = SpringContextSingleton.getInstance().getContext();
        if (context != null) {
            jahiaService = (JahiaService)context.getBean(serviceName);
            this.servicesCache.put((Object)serviceName, (Object)jahiaService);
        } else {
            logger.warn("Application context is not (yet) available when trying to retrieve service " + serviceName + ", will return null !");
        }
        return jahiaService;
    }

    public DispatchingService getApplicationsDispatchService() {
        return (DispatchingService)this.getService("DispatchingService");
    }

    public JahiaUserManagerService getJahiaUserManagerService() {
        return (JahiaUserManagerService)this.getService("JahiaUserManagerService");
    }

    public JahiaGroupManagerService getJahiaGroupManagerService() {
        return (JahiaGroupManagerService)this.getService("JahiaGroupManagerService");
    }

    public JahiaFileWatcherService getJahiaFileWatcherService() {
        return (JahiaFileWatcherService)this.getService("JahiaFileWatcherService");
    }

    public ApplicationsManagerService getApplicationsManagerService() {
        return (ApplicationsManagerService)this.getService("ApplicationsManagerService");
    }

    public JahiaSitesService getJahiaSitesService() {
        return (JahiaSitesService)this.getService("JahiaSitesService");
    }

    public CacheService getCacheService() {
        return (CacheService)this.getService("JahiaCacheService");
    }

    public MailService getMailService() {
        return (MailService)this.getService("MailService");
    }

    public CategoryService getCategoryService() {
        return (CategoryService)this.getService("CategoryService");
    }

    public SchedulerService getSchedulerService() {
        return (SchedulerService)this.getService("SchedulerService");
    }

    public JCRStoreService getJCRStoreService() {
        return (JCRStoreService)this.getService("JCRStoreService");
    }

    public JCRPublicationService getJCRPublicationService() {
        return (JCRPublicationService)this.getService("jcrPublicationService");
    }

    public JCRVersionService getJCRVersionService() {
        return (JCRVersionService)this.getService("jcrVersionService");
    }

    public ImportExportBaseService getImportExportService() {
        return (ImportExportBaseService)this.getService("ImportExportService");
    }

    public JahiaPreferencesService getJahiaPreferencesService() {
        return (JahiaPreferencesService)this.getService("JahiaPreferencesService");
    }

    public JahiaPasswordPolicyService getJahiaPasswordPolicyService() {
        return (JahiaPasswordPolicyService)this.getService("JahiaPasswordPolicyService");
    }

    public JahiaTemplateManagerService getJahiaTemplateManagerService() {
        return (JahiaTemplateManagerService)this.getService("JahiaTemplateManagerService");
    }

    public QueryService getQueryService() {
        return (QueryService)this.getService("QueryService");
    }

    public SearchService getSearchService() {
        return (SearchService)this.getService("SearchService");
    }

    private ServicesRegistry() {
        this.servicesCache.setFast(true);
    }
}

