/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.security.license;

import java.util.Optional;
import org.jahia.bin.Jahia;
import org.jahia.services.SpringContextSingleton;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public interface LicenseCheckerService {
    public boolean checkFeature(String var1);

    public boolean isLimitReached(String var1, String var2);

    public boolean isLoggedInUsersLimitReached();

    public Optional<Long> getSiteLimit();

    public static class Stub {
        private static volatile boolean initialized = false;
        private static volatile LicenseCheckerService instance;

        public static boolean isAllowed(String featureId) {
            LicenseCheckerService service = Stub.getInstance();
            return service != null && service.checkFeature(featureId);
        }

        public static boolean isLimitReached(String componentName, String limitName) {
            LicenseCheckerService service = Stub.getInstance();
            return service != null && service.isLimitReached(componentName, limitName);
        }

        public static boolean isLoggedInUsersLimitReached() {
            LicenseCheckerService service = Stub.getInstance();
            return service != null && service.isLoggedInUsersLimitReached();
        }

        public static Optional<Long> getSiteLimit() {
            LicenseCheckerService service = Stub.getInstance();
            if (service != null) {
                return service.getSiteLimit();
            }
            return Optional.empty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static LicenseCheckerService getInstance() {
            if (initialized) return instance;
            Class<Stub> clazz = Stub.class;
            synchronized (Stub.class) {
                if (initialized) return instance;
                if (Jahia.isEnterpriseEdition() && SpringContextSingleton.getInstance().isInitialized()) {
                    try {
                        instance = (LicenseCheckerService)SpringContextSingleton.getInstance().getContext().getBean("licenseChecker");
                    }
                    catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                        // empty catch block
                    }
                }
                initialized = true;
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }
    }
}

