/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.applications.pluto;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.pluto.driver.services.impl.resource.RenderConfigServiceImpl;
import org.apache.pluto.driver.services.impl.resource.ResourceConfig;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.jahia.services.applications.pluto.PortletWindowConfig;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.decorator.JCRPortletNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaRenderConfigServiceImpl
extends RenderConfigServiceImpl {
    ThreadLocal<PageConfig> pageConfigThreadLocal = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger(JahiaRenderConfigServiceImpl.class);
    private JCRSessionFactory sessionFactory;
    public static final String PAGE_CONFIG_ATTR = "org.jahia.services.applications.pluto.pageconfig";
    public final String DEFAULT_PAGE_NAME = "Portlet manager";

    public JahiaRenderConfigServiceImpl(ResourceConfig config) {
        super(config);
    }

    public void addPage(PageConfig pageConfig) {
        logger.warn("addPage(...) not implemented.");
    }

    public List<PageConfig> getPages() {
        ArrayList<PageConfig> pageConfigList = new ArrayList<PageConfig>();
        pageConfigList.add(this.getDefaultPage());
        return pageConfigList;
    }

    public PageConfig getPage(String pageId) {
        return this.getDefaultPage();
    }

    public void removePage(PageConfig pageConfig) {
        logger.warn("removePage(...) not implemented.");
    }

    public PageConfig getDefaultPage() {
        PageConfig pageConfig = this.pageConfigThreadLocal.get();
        if (pageConfig == null || pageConfig.getPortletIds().isEmpty()) {
            try {
                pageConfig = JCRTemplate.getInstance().doExecuteWithSystemSessionInSameWorkspaceAndLocale(new JCRCallback<PageConfig>(){

                    @Override
                    public PageConfig doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        PageConfig pageConfig = new PageConfig();
                        pageConfig.setUri("/WEB-INF/themes/pluto-default-theme.jsp");
                        pageConfig.setName("Portlet manager");
                        Query q = JahiaRenderConfigServiceImpl.this.createAllPortletsQuery(session);
                        if (q != null) {
                            QueryResult qr = q.execute();
                            NodeIterator ni = qr.getNodes();
                            ArrayList<String> portletIds = new ArrayList<String>();
                            while (ni.hasNext()) {
                                JCRNodeWrapper n = (JCRNodeWrapper)ni.nextNode();
                                portletIds.add(PortletWindowConfig.fromId(!(n instanceof JCRPortletNode) ? new JCRPortletNode(n) : (JCRPortletNode)n));
                            }
                            pageConfig.setPortletIds(portletIds);
                        }
                        return pageConfig;
                    }
                });
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (pageConfig.getPortletIds().isEmpty()) {
                this.pageConfigThreadLocal.set(null);
            } else {
                this.pageConfigThreadLocal.set(pageConfig);
            }
            return pageConfig;
        }
        return pageConfig;
    }

    private Query createAllPortletsQuery(JCRSessionWrapper session) throws RepositoryException {
        String s = "select * from [jnt:portlet]";
        QueryManagerWrapper queryManager = session.getWorkspace().getQueryManager();
        return queryManager.createQuery(s, "JCR-SQL2");
    }

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

