/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.response.FacetField;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCREventIterator;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.services.query.QueryResultWrapper;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclListener
extends DefaultEventListener {
    private static final Pattern CURRENT_SITE_PATTERN = Pattern.compile("^currentSite");
    private static final Logger logger = LoggerFactory.getLogger(AclListener.class);
    private static ThreadLocal<Boolean> inListener = new ThreadLocal();
    public static final List<String> PRIVILEGED_GROUPS = Arrays.asList("g:privileged", "g:site-privileged");
    private JCRPublicationService publicationService;
    private JahiaUserManagerService userService;
    private JahiaGroupManagerService groupService;
    private Map<String, String> foundRoles = new HashMap<String, String>();

    public void setPublicationService(JCRPublicationService publicationService) {
        this.publicationService = publicationService;
    }

    public void setUserService(JahiaUserManagerService userService) {
        this.userService = userService;
    }

    public void setGroupService(JahiaGroupManagerService groupService) {
        this.groupService = groupService;
    }

    @Override
    public int getEventTypes() {
        return 31;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(final EventIterator events) {
        JCRSessionWrapper session = ((JCREventIterator)events).getSession();
        if (inListener.get() == Boolean.TRUE) {
            return;
        }
        try {
            inListener.set(Boolean.TRUE);
            final ArrayList<Event> aclEvents = new ArrayList<Event>();
            while (events.hasNext()) {
                Event next = events.nextEvent();
                if (!next.getPath().contains("/j:acl/") && !next.getPath().startsWith("/roles/")) continue;
                aclEvents.add(next);
            }
            if (aclEvents.isEmpty()) {
                return;
            }
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, session.getWorkspace().getName(), session.getLocale(), new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper systemSession) throws RepositoryException {
                    HashSet aceIdentifiers = new HashSet();
                    HashSet addedAceIdentifiers = new HashSet();
                    HashSet removedAcePaths = new HashSet();
                    HashSet addedExtPermIds = new HashSet();
                    HashSet removedExtPermissions = new HashSet();
                    HashSet removedRoles = new HashSet();
                    AclListener.this.parseEvents(systemSession, aclEvents, aceIdentifiers, addedAceIdentifiers, removedAcePaths, addedExtPermIds, removedExtPermissions, removedRoles);
                    AclListener.this.handleAclModifications(systemSession, aceIdentifiers, addedAceIdentifiers, removedAcePaths, (JCREventIterator)events);
                    AclListener.this.handleRoleModifications(systemSession, addedExtPermIds, removedExtPermissions);
                    if (removedRoles.size() > 0) {
                        AclListener.this.handleRemovedRole(systemSession, removedRoles);
                        JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "live", null, liveSession -> {
                            AclListener.this.handleRemovedRole(liveSession, removedRoles);
                            return null;
                        });
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Cannot propagate external ACL", (Throwable)e);
        }
        finally {
            inListener.set(Boolean.FALSE);
        }
    }

    private void parseEvents(JCRSessionWrapper systemSession, List<Event> aclEvents, Set<String> aceIdentifiers, Set<String> addedAceIdentifiers, Set<String> removedAcePaths, Set<String> addedExtPermIds, Set<List<String>> removedExtPermissions, Set<String> removedRoles) throws RepositoryException {
        for (Event next : aclEvents) {
            String identifier;
            if (next.getPath().contains("/j:acl/")) {
                if (next.getType() == 4 || next.getType() == 16) {
                    try {
                        String identifier2;
                        JCRNodeWrapper nodeByIdentifier = systemSession.getNodeByIdentifier(next.getIdentifier());
                        if (!nodeByIdentifier.isNodeType("jnt:ace") || nodeByIdentifier.isNodeType("jnt:externalAce") || !nodeByIdentifier.getProperty("j:aceType").getValue().getString().equals("GRANT") || (identifier2 = next.getIdentifier()) == null) continue;
                        aceIdentifiers.add(identifier2);
                        if (next.getType() != 4) continue;
                        addedAceIdentifiers.add(identifier2);
                    }
                    catch (ItemNotFoundException e) {
                        logger.error("unable to read node " + next.getPath());
                    }
                    continue;
                }
                if (next.getType() != 2 || !StringUtils.substringAfterLast((String)next.getPath(), (String)"/").startsWith("GRANT_")) continue;
                identifier = next.getIdentifier();
                if (identifier != null) {
                    aceIdentifiers.add(identifier);
                }
                removedAcePaths.add(next.getPath());
                continue;
            }
            if (!next.getPath().startsWith("/roles/")) continue;
            if (next.getType() == 1) {
                identifier = next.getIdentifier();
                JCRNodeWrapper nodeByIdentifier = systemSession.getNodeByIdentifier(identifier);
                if (!nodeByIdentifier.isNodeType("jnt:externalPermissions")) continue;
                addedExtPermIds.add(identifier);
                continue;
            }
            if (next.getType() != 2) continue;
            String path = next.getPath();
            if (path.endsWith("-access")) {
                removedExtPermissions.add(Arrays.asList(StringUtils.substringAfterLast((String)StringUtils.substringBeforeLast((String)path, (String)"/"), (String)"/"), StringUtils.substringAfterLast((String)path, (String)"/")));
                continue;
            }
            removedRoles.add(StringUtils.substringAfterLast((String)path, (String)"/"));
        }
    }

    private void handleAclModifications(final JCRSessionWrapper systemSession, Set<String> aceIdentifiers, final Set<String> addedAceIdentifiers, Set<String> removedAcePaths, final JCREventIterator events) throws RepositoryException {
        String principal;
        final HashMap<String, Set<String>> privilegedAdded = new HashMap<String, Set<String>>();
        final HashMap<String, Set<String>> privilegedToCheck = new HashMap<String, Set<String>>();
        HashMap<String, JCRNodeWrapper> roleNodes = new HashMap<String, JCRNodeWrapper>();
        for (final String string : aceIdentifiers) {
            final HashSet<String> roles = new HashSet<String>();
            JCRNodeWrapper ace = null;
            principal = null;
            try {
                ace = systemSession.getNodeByIdentifier(string);
                principal = ace.getProperty("j:principal").getString();
                if (ace.hasProperty("j:roles")) {
                    JCRValueWrapper[] vals;
                    for (JCRValueWrapper val : vals = ace.getProperty("j:roles").getValues()) {
                        roles.add(val.getString());
                    }
                } else {
                    logger.warn("Missing roles property for acl on " + ace.getPath());
                }
            }
            catch (ItemNotFoundException vals) {
            }
            catch (InvalidItemStateException vals) {
                // empty catch block
            }
            if (!addedAceIdentifiers.contains(string)) {
                QueryManagerWrapper q = systemSession.getWorkspace().getQueryManager();
                String sql = "select * from [jnt:externalAce] as ace where ace.[j:sourceAce] = '" + string + "'";
                QueryResult qr = q.createQuery(sql, "JCR-SQL2").execute();
                NodeIterator ni = qr.getNodes();
                while (ni.hasNext()) {
                    JCRNodeWrapper n = (JCRNodeWrapper)ni.nextNode();
                    String role = n.getProperty("j:roles").getValues()[0].getString();
                    if (roles.contains(role)) continue;
                    ArrayList<JCRValueWrapper> newVals = new ArrayList<JCRValueWrapper>();
                    for (JCRValueWrapper value : n.getProperty("j:sourceAce").getValues()) {
                        if (value.getString().equals(string)) continue;
                        newVals.add(value);
                    }
                    if (newVals.size() == 0) {
                        n.remove();
                        continue;
                    }
                    n.setProperty("j:sourceAce", newVals.toArray(new Value[newVals.size()]));
                }
            }
            if (roles.isEmpty()) continue;
            if (systemSession.getWorkspace().getName().equals("live")) {
                final JCRNodeWrapper finalAce = ace;
                final String fprincipal = principal;
                JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "default", systemSession.getLocale(), new JCRCallback<Object>(){

                    @Override
                    public Object doInJCR(JCRSessionWrapper defaultSystemSession) throws RepositoryException {
                        boolean publish = events.getOperationType() == 4 || events.getLastOperationType() == 4;
                        AclListener.this.handleAclModifications(systemSession, defaultSystemSession, roles, finalAce, fprincipal, privilegedAdded, privilegedToCheck, new HashMap(), addedAceIdentifiers.contains(string), publish);
                        return null;
                    }
                });
                continue;
            }
            this.handleAclModifications(systemSession, systemSession, roles, ace, principal, privilegedAdded, privilegedToCheck, roleNodes, addedAceIdentifiers.contains(string), false);
        }
        systemSession.save();
        if (!systemSession.getWorkspace().getName().equals("live")) {
            JCRGroupNode priv;
            String site;
            for (String string : removedAcePaths) {
                String name = StringUtils.substringAfterLast((String)string, (String)"/");
                if (name.startsWith("REF")) continue;
                site = string.startsWith("/sites/") ? StringUtils.substringBefore((String)string.substring("/sites/".length()), (String)"/") : "systemsite";
                principal = StringUtils.substringAfter((String)name, (String)"_").replaceFirst("_", ":");
                if (principal.startsWith("jcr:read") || principal.startsWith("jcr:write")) {
                    principal = StringUtils.substringAfter((String)principal, (String)"_").replaceFirst("_", ":");
                }
                if (PRIVILEGED_GROUPS.contains(principal)) continue;
                if (!privilegedToCheck.containsKey(site)) {
                    privilegedToCheck.put(site, new HashSet());
                }
                ((Set)privilegedToCheck.get(site)).add(principal);
            }
            for (Map.Entry entry : privilegedToCheck.entrySet()) {
                if (privilegedAdded.get(entry.getKey()) == null) continue;
                ((Set)entry.getValue()).removeAll((Collection)privilegedAdded.get(entry.getKey()));
            }
            HashSet<String> membershipModifiedForGroups = new HashSet<String>();
            for (Map.Entry entry : privilegedToCheck.entrySet()) {
                site = (String)entry.getKey();
                priv = this.groupService.lookupGroup(site, "site-privileged", systemSession);
                if (priv == null) continue;
                for (String principal2 : (Set)entry.getValue()) {
                    JCRNodeWrapper p = this.getPrincipal(site, principal2);
                    if (p == null || !priv.isMember(p)) continue;
                    ArrayList<String> rolesName = new ArrayList<String>();
                    boolean needPrivileged = false;
                    StringBuilder sql = new StringBuilder();
                    sql.append("select ace.[j:roles] AS [rep:facet(facet.mincount=1)] from [jnt:ace] as ace");
                    sql.append(" where (not ([j:externalPermissionsName] is not null)) and ace.[j:aceType]='GRANT'");
                    sql.append(" and ace.[j:principal] = '");
                    sql.append(principal2);
                    sql.append("' and (isdescendantnode(ace, ['/sites/");
                    sql.append(site);
                    sql.append("'])");
                    if (StringUtils.equals((String)site, (String)"systemsite")) {
                        sql.append(" or isdescendantnode(ace, ['/mounts'])");
                        sql.append(" or isdescendantnode(ace, ['/j:acl'])");
                        sql.append(" or isdescendantnode(ace, ['/groups'])");
                        sql.append(" or isdescendantnode(ace, ['/users'])");
                        sql.append(" or isdescendantnode(ace, ['/modules'])");
                    }
                    sql.append(')');
                    rolesName.addAll(this.getRolesName(systemSession, sql.toString()));
                    try {
                        for (String roleName : rolesName) {
                            JCRNodeWrapper roleNode = this.getRole(systemSession, roleName, roleNodes);
                            if (roleNode == null || !roleNode.hasProperty("j:privilegedAccess") || !roleNode.getProperty("j:privilegedAccess").getBoolean()) continue;
                            needPrivileged = true;
                            break;
                        }
                    }
                    catch (PathNotFoundException pathNotFoundException) {
                        // empty catch block
                    }
                    if (needPrivileged) continue;
                    logger.info(principal2 + " do not need privileged access");
                    priv.removeMember(p);
                    membershipModifiedForGroups.add(priv.getPath());
                }
            }
            for (Map.Entry entry : privilegedAdded.entrySet()) {
                site = (String)entry.getKey();
                priv = this.groupService.lookupGroup(site, "site-privileged", systemSession);
                if (priv == null) continue;
                for (String principal2 : (Set)entry.getValue()) {
                    JCRNodeWrapper p = this.getPrincipal(site, principal2);
                    if (p == null) continue;
                    Optional<JCRNodeWrapper> matchingObject = priv.getMembers().stream().filter(member -> member.getPath().equals(p.getPath())).findAny();
                    if (matchingObject.isPresent()) {
                        if (!membershipModifiedForGroups.contains(priv.getPath())) continue;
                        systemSession.save();
                        membershipModifiedForGroups.clear();
                        if (priv.isMember(p)) continue;
                    }
                    logger.info(principal2 + " need privileged access");
                    priv.addMember(p);
                }
            }
        }
        systemSession.save();
    }

    private void handleAclModifications(JCRSessionWrapper session, JCRSessionWrapper defaultSession, Set<String> roles, JCRNodeWrapper ace, String principal, Map<String, Set<String>> privilegedAdded, Map<String, Set<String>> privilegedRemoved, Map<String, JCRNodeWrapper> roleNodes, boolean isNewAce, boolean publish) throws RepositoryException {
        boolean needPrivileged = false;
        for (String role : roles) {
            JCRNodeWrapper roleNode = this.getRole(defaultSession, role, roleNodes);
            if (roleNode == null) continue;
            do {
                JCRNodeIteratorWrapper r = roleNode.getNodes();
                while (r.hasNext()) {
                    JCRNodeWrapper externalPermissions = (JCRNodeWrapper)r.nextNode();
                    if (!externalPermissions.isNodeType("jnt:externalPermissions")) continue;
                    if (publish) {
                        this.publishExternalACE(defaultSession, ace, principal, role, externalPermissions);
                        continue;
                    }
                    this.createOrUpdateExternalACE(session, ace, principal, role, externalPermissions);
                }
                if (!roleNode.hasProperty("j:privilegedAccess") || !roleNode.getProperty("j:privilegedAccess").getBoolean()) continue;
                needPrivileged = true;
            } while ((roleNode = roleNode.getParent()).isNodeType("jnt:role"));
        }
        if (!(session.getWorkspace().getName().equals("live") || PRIVILEGED_GROUPS.contains(principal) || !needPrivileged && isNewAce)) {
            Map<String, Set<String>> p;
            Map<String, Set<String>> map = p = needPrivileged ? privilegedAdded : privilegedRemoved;
            if (!p.containsKey(ace.getResolveSite().getSiteKey())) {
                p.put(ace.getResolveSite().getSiteKey(), new HashSet());
            }
            p.get(ace.getResolveSite().getSiteKey()).add(principal);
        }
    }

    private JCRNodeWrapper getRole(JCRSessionWrapper systemSession, String roleName, Map<String, JCRNodeWrapper> roleNodes) throws RepositoryException {
        if (roleNodes.containsKey(roleName)) {
            return roleNodes.get(roleName);
        }
        if (this.foundRoles.containsKey(roleName) && systemSession.itemExists(this.foundRoles.get(roleName))) {
            JCRNodeWrapper roleNode = systemSession.getNode(this.foundRoles.get(roleName));
            roleNodes.put(roleName, roleNode);
            return roleNode;
        }
        JCRNodeIteratorWrapper ni = systemSession.getWorkspace().getQueryManager().createQuery("select * from [jnt:role] as r where localname()='" + JCRContentUtils.sqlEncode(roleName) + "' and isdescendantnode(r,['/roles'])", "JCR-SQL2").execute().getNodes();
        if (ni.hasNext()) {
            JCRNodeWrapper roleNode = (JCRNodeWrapper)ni.nextNode();
            roleNodes.put(roleName, roleNode);
            this.foundRoles.put(roleName, roleNode.getPath());
            return roleNode;
        }
        roleNodes.put(roleName, null);
        this.foundRoles.remove(roleName);
        return null;
    }

    private JCRNodeWrapper getPrincipal(String site, String principal) {
        JCRNodeDecorator p = null;
        String principalName = principal.substring(2);
        if (principal.startsWith("u:")) {
            p = this.userService.lookupUser(principalName, site);
        } else if (principal.startsWith("g:") && (p = this.groupService.lookupGroup(site, principalName)) == null) {
            p = this.groupService.lookupGroup(null, principalName);
        }
        return p;
    }

    private List<String> getRolesName(JCRSessionWrapper session, String sql) throws RepositoryException {
        QueryManagerWrapper q = session.getWorkspace().getQueryManager();
        ArrayList<String> rolesName = new ArrayList<String>();
        QueryResultWrapper qr = (QueryResultWrapper)q.createQuery(sql, "JCR-SQL2").execute();
        for (FacetField facetField : qr.getFacetFields()) {
            if (facetField.getValues() == null) continue;
            for (FacetField.Count facetFieldValue : facetField.getValues()) {
                rolesName.add(facetFieldValue.getName());
            }
        }
        return rolesName;
    }

    private void handleRoleModifications(JCRSessionWrapper session, Set<String> addedExtPermIds, Set<List<String>> removedExtPermissions) {
        for (String string : addedExtPermIds) {
            try {
                JCRNodeWrapper externalPermission = session.getNodeByIdentifier(string);
                QueryManagerWrapper q = session.getWorkspace().getQueryManager();
                String role = externalPermission.getParent().getName();
                String sql = "select * from [jnt:ace] as ace where ace.[j:roles] = '" + JCRContentUtils.sqlEncode(role) + "'";
                QueryResult qr = q.createQuery(sql, "JCR-SQL2").execute();
                NodeIterator ni = qr.getNodes();
                while (ni.hasNext()) {
                    JCRNodeWrapper ace = (JCRNodeWrapper)ni.nextNode();
                    if (ace.isNodeType("jnt:externalAce")) continue;
                    this.createOrUpdateExternalACE(session, ace, ace.getProperty("j:principal").getString(), role, externalPermission);
                }
                session.save();
            }
            catch (RepositoryException e) {
                logger.error("Cannot create or update external ACE", (Throwable)e);
            }
        }
        for (List list : removedExtPermissions) {
            try {
                QueryManagerWrapper q = session.getWorkspace().getQueryManager();
                String sql = "select * from [jnt:externalAce] as ace where ace.[j:roles] = '" + JCRContentUtils.sqlEncode((String)list.get(0)) + "' and ace.[j:externalPermissionsName] ='" + JCRContentUtils.sqlEncode((String)list.get(1)) + "'";
                QueryResult qr = q.createQuery(sql, "JCR-SQL2").execute();
                NodeIterator ni = qr.getNodes();
                while (ni.hasNext()) {
                    JCRNodeWrapper n = (JCRNodeWrapper)ni.nextNode();
                    n.remove();
                }
                session.save();
            }
            catch (RepositoryException e) {
                logger.error("Cannot remove external ACE", (Throwable)e);
            }
        }
    }

    private void handleRemovedRole(JCRSessionWrapper session, Set<String> removedRoles) {
        for (String role : removedRoles) {
            try {
                QueryManagerWrapper q = session.getWorkspace().getQueryManager();
                String sql = "select * from [jnt:ace] as ace where ace.[j:roles] = '" + JCRContentUtils.sqlEncode(role) + "'";
                QueryResult qr = q.createQuery(sql, "JCR-SQL2").execute();
                NodeIterator ni = qr.getNodes();
                while (ni.hasNext()) {
                    JCRNodeWrapper ace = (JCRNodeWrapper)ni.nextNode();
                    if (ace.isNodeType("jnt:externalAce")) continue;
                    JCRValueWrapper[] roles = ace.getProperty("j:roles").getValues();
                    ArrayList<String> newRoles = new ArrayList<String>();
                    for (JCRValueWrapper v : roles) {
                        String r = v.getString();
                        if (role.equals(r)) continue;
                        newRoles.add(r);
                    }
                    if (newRoles.isEmpty()) {
                        ace.remove();
                        continue;
                    }
                    ace.setProperty("j:roles", newRoles.toArray(new String[newRoles.size()]));
                }
                session.save();
            }
            catch (RepositoryException e) {
                logger.error("Cannot remove external ACE", (Throwable)e);
            }
        }
    }

    private void createOrUpdateExternalACE(JCRSessionWrapper session, JCRNodeWrapper ace, String principal, String role, JCRNodeWrapper externalPermissions) throws RepositoryException {
        String n;
        JCRNodeWrapper p;
        JCRNodeWrapper refNode = this.getRefAclNode(session, ace, role, externalPermissions);
        if (refNode == null) {
            return;
        }
        if (!refNode.hasNode("j:acl")) {
            refNode.addMixin("jmix:accessControlled");
            refNode.addNode("j:acl", "jnt:acl");
        }
        if ((p = this.getPrincipal(ace.getResolveSite().getSiteKey(), principal)) == null || p.getResolveSite() == null || !p.getResolveSite().getSiteKey().equals("systemsite") && !p.getResolveSite().getSiteKey().equals(refNode.getResolveSite().getSiteKey())) {
            return;
        }
        JCRNodeWrapper acl = refNode.getNode("j:acl");
        if (!acl.hasNode(n = "REF" + role + "_" + externalPermissions.getName() + "_" + JCRContentUtils.replaceColon(principal))) {
            JCRNodeWrapper refAce = acl.addNode(n, "jnt:externalAce");
            refAce.setProperty("j:aceType", "GRANT");
            refAce.setProperty("j:principal", principal);
            refAce.setProperty("j:roles", new String[]{role});
            refAce.setProperty("j:externalPermissionsName", externalPermissions.getName());
            refAce.setProperty("j:protected", true);
            refAce.setProperty("j:sourceAce", new Value[]{session.getValueFactory().createValue((Node)ace, true)});
        } else {
            JCRNodeWrapper refAce = acl.getNode(n);
            if (refAce.hasProperty("j:sourceAce")) {
                refAce.getProperty("j:sourceAce").addValue(session.getValueFactory().createValue((Node)ace, true));
            } else {
                refAce.setProperty("j:sourceAce", new Value[]{session.getValueFactory().createValue((Node)ace, true)});
            }
        }
    }

    private void publishExternalACE(JCRSessionWrapper session, JCRNodeWrapper ace, String principal, String role, JCRNodeWrapper externalPermissions) throws RepositoryException {
        JCRNodeWrapper refNode = this.getRefAclNode(session, ace, role, externalPermissions);
        if (refNode == null) {
            return;
        }
        String n = "REF" + role + "_" + externalPermissions.getName() + "_" + JCRContentUtils.replaceColon(principal);
        if (refNode.hasNode("j:acl/" + n)) {
            JCRNodeWrapper node = refNode.getNode("j:acl").getNode(n);
            this.publicationService.publishByMainId(node.getIdentifier());
        }
    }

    public JCRNodeWrapper getRefAclNode(JCRSessionWrapper session, JCRNodeWrapper ace, String role, JCRNodeWrapper externalPermissions) throws RepositoryException {
        String path = externalPermissions.getProperty("j:path").getString();
        if (!session.nodeExists(path = CURRENT_SITE_PATTERN.matcher(path).replaceFirst(ace.getResolveSite().getPath()))) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot create or update external ACE " + externalPermissions.getName() + " because the node " + path + "doesn't exist.");
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(ace.getPath() + " / " + role + " ---> " + externalPermissions.getName() + " on " + path);
        }
        return session.getNode(path);
    }
}

