/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.content.ComplexPublicationService;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.PublicationInfo;
import org.jahia.services.content.PublicationInfoNode;
import org.jahia.services.content.PublicationJob;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.scheduler.SchedulerService;
import org.jahia.services.workflow.WorkflowRule;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.utils.LanguageCodeConverters;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexPublicationServiceImpl
implements ComplexPublicationService {
    private static final transient Logger logger = LoggerFactory.getLogger(ComplexPublicationServiceImpl.class);
    private JCRSessionFactory sessionFactory;
    private JCRPublicationService publicationService;
    private WorkflowService workflowService;
    private SchedulerService schedulerService;

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setPublicationService(JCRPublicationService publicationService) {
        this.publicationService = publicationService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Override
    public ComplexPublicationService.AggregatedPublicationInfo getAggregatedPublicationInfo(String nodeIdentifier, String language, boolean subNodes, boolean references, JCRSessionWrapper sourceSession) {
        try {
            JCRNodeWrapper node = sourceSession.getNodeByIdentifier(nodeIdentifier);
            PublicationInfo publicationInfo = this.publicationService.getPublicationInfo(nodeIdentifier, Collections.singleton(language), references, subNodes, false, sourceSession.getWorkspace().getName(), "live").get(0);
            if (!subNodes) {
                String translationNodeName = "j:translation_" + language;
                if (node.hasNode(translationNodeName)) {
                    JCRNodeWrapper translationNode = node.getNode(translationNodeName);
                    PublicationInfo translationInfo = this.publicationService.getPublicationInfo(translationNode.getIdentifier(), Collections.singleton(language), references, false, false, sourceSession.getWorkspace().getName(), "live").get(0);
                    publicationInfo.getRoot().addChild(translationInfo.getRoot());
                } else if (publicationInfo.getRoot().getStatus() == 1 && node.getNodes("j:translation_*").hasNext() && !this.isPublished(nodeIdentifier, language)) {
                    publicationInfo.getRoot().setStatus(4);
                }
            }
            AggregatedPublicationInfoImpl result = new AggregatedPublicationInfoImpl(publicationInfo.getRoot().getStatus());
            if (publicationInfo.getRoot().isWorkInProgress()) {
                result.setWorkInProgress(true);
            }
            String translationNodeRelPath = publicationInfo.getRoot().getChildren().size() > 0 ? "/j:translation_" + language : null;
            for (PublicationInfoNode childNode : publicationInfo.getRoot().getChildren()) {
                if (!childNode.getPath().contains(translationNodeRelPath)) continue;
                if (childNode.getStatus() == 4) {
                    if (!this.isPublished(nodeIdentifier, language) && result.getPublicationStatus() != 10 && result.getPublicationStatus() != 5) {
                        result.setPublicationStatus(4);
                    }
                } else if (childNode.getStatus() > result.getPublicationStatus()) {
                    result.setPublicationStatus(childNode.getStatus());
                }
                if (result.getPublicationStatus() == 5 && childNode.getStatus() != 5 && childNode.getStatus() != 4) {
                    result.setPublicationStatus(childNode.getStatus());
                }
                if (childNode.isLocked()) {
                    result.setLocked(true);
                }
                if (!childNode.isWorkInProgress()) continue;
                result.setWorkInProgress(true);
            }
            result.setAllowedToPublishWithoutWorkflow(node.hasPermission("publish"));
            result.setNonRootMarkedForDeletion(result.getPublicationStatus() == 12 && !node.isNodeType("jmix:markedForDeletionRoot"));
            if (result.getPublicationStatus() == 1) {
                boolean modified;
                Set<Integer> allStatuses = publicationInfo.getTreeStatus(language);
                boolean bl = modified = !allStatuses.isEmpty() && Collections.max(allStatuses) > 1;
                if (!modified) {
                    for (PublicationInfo refInfo : publicationInfo.getAllReferences()) {
                        allStatuses = refInfo.getTreeStatus(language);
                        if (allStatuses.isEmpty() || Collections.max(allStatuses) <= 1) continue;
                        modified = true;
                        break;
                    }
                }
                if (modified) {
                    result.setPublicationStatus(3);
                }
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    private boolean isPublished(String nodeId, String language) throws RepositoryException {
        try {
            JCRSessionFactory.getInstance().getCurrentUserSession("live", LanguageCodeConverters.languageCodeToLocale(language)).getNodeByIdentifier(nodeId);
            return true;
        }
        catch (ItemNotFoundException e) {
            return false;
        }
    }

    @Override
    public Collection<ComplexPublicationService.FullPublicationInfo> getFullPublicationInfos(Collection<String> nodeIdentifiers, Collection<String> languages, boolean allSubTree, JCRSessionWrapper sourceSession) {
        try {
            if (languages == null) {
                languages = Collections.singletonList(null);
            }
            LinkedHashMap<String, FullPublicationInfoImpl> result = new LinkedHashMap<String, FullPublicationInfoImpl>();
            ArrayList<String> nodeIdentifierList = new ArrayList<String>(nodeIdentifiers);
            for (String language : languages) {
                List<PublicationInfo> publicationInfos = this.publicationService.getPublicationInfos(nodeIdentifierList, Collections.singleton(language), true, true, allSubTree, sourceSession.getWorkspace().getName(), "live");
                for (PublicationInfo publicationInfo : publicationInfos) {
                    publicationInfo.clearInternalAndPublishedReferences(nodeIdentifierList);
                }
                Collection<FullPublicationInfoImpl> infos = this.convert(publicationInfos, language, "publish", sourceSession);
                String lastGroup = null;
                String lastTitle = null;
                Locale locale = language != null ? new Locale(language) : null;
                for (FullPublicationInfoImpl info : infos) {
                    if (!info.isPublishable() && info.getPublicationStatus() != 6 || info.getWorkflowDefinition() == null && !info.isAllowedToPublishWithoutWorkflow()) continue;
                    result.put(language != null ? language + "/" + info.getNodeIdentifier() : info.getNodeIdentifier(), info);
                    if (!info.getWorkflowGroup().equals(lastGroup)) {
                        lastGroup = info.getWorkflowGroup();
                        lastTitle = locale != null ? info.getNodeTitle() + " ( " + locale.getDisplayName(locale) + " )" : info.getNodeTitle();
                    }
                    info.setWorkflowTitle(lastTitle);
                }
            }
            return new ArrayList<ComplexPublicationService.FullPublicationInfo>(result.values());
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    @Override
    public Collection<ComplexPublicationService.FullPublicationInfo> getFullUnpublicationInfos(Collection<String> nodeIdentifiers, Collection<String> languages, boolean allSubTree, JCRSessionWrapper session) {
        try {
            List<PublicationInfo> publicationInfos = this.publicationService.getPublicationInfos(new ArrayList<String>(nodeIdentifiers), null, false, true, allSubTree, "live", "live");
            LinkedHashMap<String, FullPublicationInfoImpl> result = new LinkedHashMap<String, FullPublicationInfoImpl>();
            for (String language : languages) {
                Collection<FullPublicationInfoImpl> infos = this.convert(publicationInfos, language, "unpublish", session);
                String lastGroup = null;
                String lastTitle = null;
                Locale locale = new Locale(language);
                for (FullPublicationInfoImpl info : infos) {
                    if (info.getPublicationStatus() != 1 || info.getWorkflowDefinition() == null && !info.isAllowedToPublishWithoutWorkflow()) continue;
                    result.put(language + "/" + info.getNodeIdentifier(), info);
                    if (lastGroup == null || !info.getWorkflowGroup().equals(lastGroup)) {
                        lastGroup = info.getWorkflowGroup();
                        lastTitle = info.getNodeTitle() + " ( " + locale.getDisplayName(locale) + " )";
                    }
                    info.setWorkflowTitle(lastTitle);
                }
            }
            Set<String> clearedIdentifiers = ComplexPublicationServiceImpl.clearNodeIdentifiersOnTranslationNodes(result);
            ComplexPublicationServiceImpl.removeSharedNodes(result, languages, clearedIdentifiers);
            return new ArrayList<ComplexPublicationService.FullPublicationInfo>(result.values());
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    private Collection<FullPublicationInfoImpl> convert(Collection<PublicationInfo> publicationInfos, String language, String workflowAction, JCRSessionWrapper session) throws RepositoryException {
        ArrayList<FullPublicationInfoImpl> result = new ArrayList<FullPublicationInfoImpl>();
        ArrayList<String> mainPaths = new ArrayList<String>();
        for (PublicationInfo publicationInfo : publicationInfos) {
            Collection<FullPublicationInfoImpl> infos = this.convert(publicationInfo, publicationInfo.getRoot(), mainPaths, language, workflowAction, session).values();
            result.addAll(infos);
        }
        return result;
    }

    private Map<String, FullPublicationInfoImpl> convert(PublicationInfo publicationInfo, PublicationInfoNode root, List<String> mainPaths, String language, String workflowAction, JCRSessionWrapper session) {
        LinkedHashMap<String, FullPublicationInfoImpl> infos = new LinkedHashMap<String, FullPublicationInfoImpl>();
        return this.convert(publicationInfo, root, mainPaths, language, infos, workflowAction, session);
    }

    private Map<String, FullPublicationInfoImpl> convert(PublicationInfo publicationInfo, PublicationInfoNode root, List<String> mainPaths, String language, Map<String, FullPublicationInfoImpl> infos, String workflowAction, JCRSessionWrapper session) {
        PublicationInfoNode node = publicationInfo.getRoot();
        ArrayList<PublicationInfo> referencePublicationInfos = new ArrayList<PublicationInfo>();
        this.convert(infos, root, mainPaths, null, node, referencePublicationInfos, language, workflowAction, session);
        LinkedHashMap<String, FullPublicationInfoImpl> result = new LinkedHashMap<String, FullPublicationInfoImpl>();
        result.putAll(infos);
        for (PublicationInfo referencePublicationInfo : referencePublicationInfos) {
            if (infos.containsKey(referencePublicationInfo.getRoot().getUuid())) continue;
            result.putAll(this.convert(referencePublicationInfo, referencePublicationInfo.getRoot(), mainPaths, language, infos, workflowAction, session));
        }
        return result;
    }

    private ComplexPublicationService.FullPublicationInfo convert(Map<String, FullPublicationInfoImpl> allInfos, PublicationInfoNode root, List<String> mainPaths, WorkflowRule lastRule, PublicationInfoNode node, Collection<PublicationInfo> references, String language, String workflowAction, JCRSessionWrapper session) {
        FullPublicationInfoImpl info = new FullPublicationInfoImpl(node.getUuid(), node.getStatus());
        try {
            JCRNodeWrapper jcrNode;
            if (node.getStatus() == 11) {
                JCRSessionWrapper liveSession = this.sessionFactory.getCurrentUserSession("live", session.getLocale(), session.getFallbackLocale());
                jcrNode = liveSession.getNodeByUUID(node.getUuid());
            } else {
                WorkflowRule rule;
                jcrNode = session.getNodeByUUID(node.getUuid());
                if ((lastRule == null || jcrNode.hasNode("j:workflowRules")) && (rule = this.workflowService.getWorkflowRuleForAction(jcrNode, false, workflowAction)) != null && !rule.equals(lastRule)) {
                    lastRule = this.workflowService.getWorkflowRuleForAction(jcrNode, true, workflowAction) != null ? rule : null;
                }
            }
            if (jcrNode.hasProperty("jcr:title")) {
                info.setNodeTitle(jcrNode.getProperty("jcr:title").getString());
            } else {
                info.setNodeTitle(jcrNode.getName());
            }
            info.setNodePath(jcrNode.getPath());
            info.setNodeType(jcrNode.getPrimaryNodeType());
            info.setAllowedToPublishWithoutWorkflow(jcrNode.hasPermission("publish"));
            info.setNonRootMarkedForDeletion(jcrNode.isNodeType("jmix:markedForDeletion") && !jcrNode.isNodeType("jmix:markedForDeletionRoot"));
        }
        catch (RepositoryException e) {
            logger.warn("Issue when reading workflow and delete status of node " + node.getPath(), (Throwable)e);
            info.setNodeTitle(node.getPath());
        }
        info.setAllPublishedLanguagesInSubTree(this.getAllPublishedLanguagesInSubTree(node));
        info.setLanguage(language);
        info.setWorkInProgress(node.isWorkInProgress());
        info.setPublicationRootNodeIdentifier(root.getUuid());
        String mainPath = root.getPath();
        info.setPublicationRootNodePath(mainPath);
        if (!mainPaths.contains(mainPath)) {
            mainPaths.add(mainPath);
        }
        info.setPublicationRootNodePathIndex(mainPaths.indexOf(mainPath));
        HashMap<String, FullPublicationInfoImpl> infosByNodePath = new HashMap<String, FullPublicationInfoImpl>();
        infosByNodePath.put(node.getPath(), info);
        ArrayList<String> referenceUuids = new ArrayList<String>();
        allInfos.put(node.getUuid(), info);
        if (lastRule != null) {
            info.setWorkflowGroup(language + lastRule.getDefinitionPath());
            info.setWorkflowDefinition(lastRule.getProviderKey() + ":" + lastRule.getWorkflowDefinitionKey());
        } else {
            info.setWorkflowGroup(language + " no-workflow");
        }
        String translationNodePath = node.getChildren().size() > 0 ? "/j:translation_" + language : null;
        for (PublicationInfoNode childNode : node.getChildren()) {
            FullPublicationInfoImpl lastInfo;
            if (childNode.getPath().contains(translationNodePath)) {
                String path = StringUtils.substringBeforeLast((String)childNode.getPath(), (String)"/j:translation");
                lastInfo = (FullPublicationInfoImpl)infosByNodePath.get(path);
                if (lastInfo != null) {
                    if (childNode.getStatus() > lastInfo.getPublicationStatus()) {
                        lastInfo.setPublicationStatus(childNode.getStatus());
                    }
                    if (lastInfo.getPublicationStatus() == 5 && childNode.getStatus() != 5) {
                        lastInfo.setPublicationStatus(childNode.getStatus());
                    }
                    if (childNode.isLocked()) {
                        info.setLocked(true);
                    }
                    if (childNode.isWorkInProgress()) {
                        info.setWorkInProgress(true);
                    }
                    lastInfo.setTranslationNodeIdentifier(childNode.getUuid());
                }
                for (PublicationInfo publicationInfo : childNode.getReferences()) {
                    if (referenceUuids.contains(publicationInfo.getRoot().getUuid()) || allInfos.containsKey(publicationInfo.getRoot().getUuid())) continue;
                    referenceUuids.add(publicationInfo.getRoot().getUuid());
                    allInfos.putAll(this.convert(publicationInfo, publicationInfo.getRoot(), mainPaths, language, allInfos, workflowAction, session));
                }
                continue;
            }
            if (!childNode.getPath().contains("/j:translation") || node.getStatus() != 12 && node.getStatus() != 11) continue;
            String key = StringUtils.substringBeforeLast((String)childNode.getPath(), (String)"/j:translation");
            lastInfo = (FullPublicationInfoImpl)infosByNodePath.get(key);
            lastInfo.addDeletedTranslationNodeIdentifier(childNode.getUuid());
        }
        references.addAll(node.getReferences());
        for (PublicationInfo publicationInfo : node.getReferences()) {
            if (referenceUuids.contains(publicationInfo.getRoot().getUuid())) continue;
            referenceUuids.add(publicationInfo.getRoot().getUuid());
            if (mainPaths.contains(publicationInfo.getRoot().getPath()) || allInfos.containsKey(publicationInfo.getRoot().getUuid())) continue;
            allInfos.putAll(this.convert(publicationInfo, publicationInfo.getRoot(), mainPaths, language, allInfos, workflowAction, session));
        }
        allInfos.remove(node.getUuid());
        allInfos.put(node.getUuid(), info);
        for (PublicationInfoNode sub : node.getChildren()) {
            if (sub.getPath().contains("/j:translation")) continue;
            this.convert(allInfos, root, mainPaths, lastRule, sub, references, language, workflowAction, session);
        }
        return info;
    }

    private Set<String> getAllPublishedLanguagesInSubTree(PublicationInfoNode node) {
        HashSet<String> result = new HashSet<String>();
        if (node.getStatus() != 5 && node.getStatus() != 4 && node.getPath().contains("/j:translation_")) {
            result.add(StringUtils.substringAfterLast((String)node.getPath(), (String)"/j:translation_"));
        }
        for (PublicationInfoNode childNode : node.getChildren()) {
            result.addAll(this.getAllPublishedLanguagesInSubTree(childNode));
        }
        return result;
    }

    private static void removeSharedNodes(Map<String, FullPublicationInfoImpl> infosByPath, Collection<String> languages, Set<String> clearedIdentifiers) {
        HashSet<String> paths = new HashSet<String>(infosByPath.keySet());
        for (String path : paths) {
            boolean contentStillPublishedInOtherLanguage;
            FullPublicationInfoImpl info = infosByPath.get(path);
            boolean clearedForTranslation = clearedIdentifiers.contains(info.getNodeIdentifier());
            boolean hasI18NSubContent = !info.getAllPublishedLanguagesInSubTree().isEmpty();
            boolean contentNotPublishedInLanguage = hasI18NSubContent && !info.getAllPublishedLanguagesInSubTree().contains(info.getLanguage());
            HashSet<String> remainingPublishedLanguages = new HashSet<String>(info.getAllPublishedLanguagesInSubTree());
            remainingPublishedLanguages.removeAll(languages);
            boolean bl = contentStillPublishedInOtherLanguage = hasI18NSubContent && !remainingPublishedLanguages.isEmpty();
            if (info.getTranslationNodeIdentifier() != null || !clearedForTranslation && !contentNotPublishedInLanguage && !contentStillPublishedInOtherLanguage) continue;
            infosByPath.remove(path);
        }
    }

    private static Set<String> clearNodeIdentifiersOnTranslationNodes(Map<String, FullPublicationInfoImpl> infosByPath) {
        HashSet<String> clearedIdentifiers = new HashSet<String>();
        for (FullPublicationInfoImpl info : infosByPath.values()) {
            if (info.getTranslationNodeIdentifier() == null) continue;
            clearedIdentifiers.add(info.getNodeIdentifier());
            info.clearNodeIdentifier();
        }
        return clearedIdentifiers;
    }

    @Override
    public void publish(Collection<String> nodeIdentifiers, Collection<String> languages, JCRSessionWrapper session) {
        Collection<ComplexPublicationService.FullPublicationInfo> infos = this.getFullPublicationInfos(nodeIdentifiers, languages, false, session);
        LinkedList<String> uuids = new LinkedList<String>();
        for (ComplexPublicationService.FullPublicationInfo info : infos) {
            if (info.getPublicationStatus() == 11 || !info.isAllowedToPublishWithoutWorkflow()) continue;
            if (info.getNodeIdentifier() != null) {
                uuids.add(info.getNodeIdentifier());
            }
            if (info.getTranslationNodeIdentifier() != null) {
                uuids.add(info.getTranslationNodeIdentifier());
            }
            for (String deletedTranslationNodeIdentifier : info.getDeletedTranslationNodeIdentifiers()) {
                uuids.add(deletedTranslationNodeIdentifier);
            }
        }
        String workspaceName = session.getWorkspace().getName();
        ArrayList<String> paths = new ArrayList<String>();
        for (String uuid : uuids) {
            try {
                paths.add(session.getNodeByIdentifier(uuid).getPath());
            }
            catch (RepositoryException e) {
                throw new JahiaRuntimeException(e);
            }
        }
        JobDetail jobDetail = BackgroundJob.createJahiaJob("Publication", PublicationJob.class);
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put((Object)"publicationInfos", uuids);
        jobDataMap.put((Object)"publicationPaths", paths);
        jobDataMap.put("source", workspaceName);
        jobDataMap.put("destination", "live");
        jobDataMap.put("checkPermissions", true);
        try {
            this.schedulerService.scheduleJobNow(jobDetail);
        }
        catch (SchedulerException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    private static class FullPublicationInfoImpl
    extends PublicationInfoSupport
    implements ComplexPublicationService.FullPublicationInfo {
        private String nodeIdentifier;
        private String nodePath;
        private String nodeTitle;
        private ExtendedNodeType nodeType;
        private String publicationRootNodeIdentifier;
        private String publicationRootNodePath;
        private int publicationRootNodePathIndex;
        private String workflowTitle;
        private String workflowDefinition;
        private String workflowGroup;
        private String language;
        private String translationNodeIdentifier;
        private LinkedHashSet<String> deletedTranslationNodeIdentifiers = new LinkedHashSet();
        private Set<String> allPublishedLanguagesInSubTree = new HashSet<String>();

        public FullPublicationInfoImpl(String nodeIdentifier, int publicationStatus) {
            super(publicationStatus);
            this.nodeIdentifier = nodeIdentifier;
        }

        @Override
        public String getNodeIdentifier() {
            return this.nodeIdentifier;
        }

        public void clearNodeIdentifier() {
            this.nodeIdentifier = null;
        }

        @Override
        public String getNodePath() {
            return this.nodePath;
        }

        public void setNodePath(String nodePath) {
            this.nodePath = nodePath;
        }

        @Override
        public String getNodeTitle() {
            return this.nodeTitle;
        }

        public void setNodeTitle(String nodeTitle) {
            this.nodeTitle = nodeTitle;
        }

        @Override
        public ExtendedNodeType getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(ExtendedNodeType nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public String getPublicationRootNodeIdentifier() {
            return this.publicationRootNodeIdentifier;
        }

        public void setPublicationRootNodeIdentifier(String publicationRootNodeIdentifier) {
            this.publicationRootNodeIdentifier = publicationRootNodeIdentifier;
        }

        @Override
        public String getPublicationRootNodePath() {
            return this.publicationRootNodePath;
        }

        public void setPublicationRootNodePath(String publicationRootNodePath) {
            this.publicationRootNodePath = publicationRootNodePath;
        }

        @Override
        public int getPublicationRootNodePathIndex() {
            return this.publicationRootNodePathIndex;
        }

        public void setPublicationRootNodePathIndex(int publicationRootNodePathIndex) {
            this.publicationRootNodePathIndex = publicationRootNodePathIndex;
        }

        @Override
        public String getWorkflowTitle() {
            return this.workflowTitle;
        }

        public void setWorkflowTitle(String workflowTitle) {
            this.workflowTitle = workflowTitle;
        }

        @Override
        public String getWorkflowDefinition() {
            return this.workflowDefinition;
        }

        public void setWorkflowDefinition(String workflowDefinition) {
            this.workflowDefinition = workflowDefinition;
        }

        @Override
        public String getWorkflowGroup() {
            return this.workflowGroup;
        }

        public void setWorkflowGroup(String workflowGroup) {
            this.workflowGroup = workflowGroup;
        }

        @Override
        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public String getTranslationNodeIdentifier() {
            return this.translationNodeIdentifier;
        }

        public void setTranslationNodeIdentifier(String translationNodeIdentifier) {
            this.translationNodeIdentifier = translationNodeIdentifier;
        }

        @Override
        public Collection<String> getDeletedTranslationNodeIdentifiers() {
            return Collections.unmodifiableCollection(this.deletedTranslationNodeIdentifiers);
        }

        public void addDeletedTranslationNodeIdentifier(String deletedTranslationNodeIdentifier) {
            this.deletedTranslationNodeIdentifiers.add(deletedTranslationNodeIdentifier);
        }

        public Set<String> getAllPublishedLanguagesInSubTree() {
            return this.allPublishedLanguagesInSubTree;
        }

        public void setAllPublishedLanguagesInSubTree(Set<String> allPublishedLanguagesInSubTree) {
            this.allPublishedLanguagesInSubTree = allPublishedLanguagesInSubTree;
        }

        @Override
        public boolean isPublishable() {
            if (this.isLocked()) {
                return false;
            }
            int publicationStatus = this.getPublicationStatus();
            if (publicationStatus <= 1) {
                return false;
            }
            if (publicationStatus == 6) {
                return false;
            }
            if (publicationStatus == 10) {
                return false;
            }
            if (this.isWorkInProgress()) {
                return false;
            }
            return !this.isNonRootMarkedForDeletion();
        }
    }

    private static class AggregatedPublicationInfoImpl
    extends PublicationInfoSupport
    implements ComplexPublicationService.AggregatedPublicationInfo {
        public AggregatedPublicationInfoImpl(int publicationStatus) {
            super(publicationStatus);
        }
    }

    private static class PublicationInfoSupport {
        private int publicationStatus;
        private boolean locked;
        private boolean workInProgress;
        private boolean allowedToPublishWithoutWorkflow;
        private boolean nonRootMarkedForDeletion;

        public PublicationInfoSupport(int publicationStatus) {
            this.publicationStatus = publicationStatus;
        }

        public int getPublicationStatus() {
            return this.publicationStatus;
        }

        public void setPublicationStatus(int publicationStatus) {
            this.publicationStatus = publicationStatus;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
        }

        public boolean isWorkInProgress() {
            return this.workInProgress;
        }

        public void setWorkInProgress(boolean workInProgress) {
            this.workInProgress = workInProgress;
        }

        public boolean isAllowedToPublishWithoutWorkflow() {
            return this.allowedToPublishWithoutWorkflow;
        }

        public void setAllowedToPublishWithoutWorkflow(boolean allowedToPublishWithoutWorkflow) {
            this.allowedToPublishWithoutWorkflow = allowedToPublishWithoutWorkflow;
        }

        public boolean isNonRootMarkedForDeletion() {
            return this.nonRootMarkedForDeletion;
        }

        public void setNonRootMarkedForDeletion(boolean nonRootMarkedForDeletion) {
            this.nonRootMarkedForDeletion = nonRootMarkedForDeletion;
        }
    }
}

