/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCREventIterator;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.throwing.ThrowingFunction;

public class DefaultValueListener
extends DefaultEventListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultValueListener.class);

    @Override
    public int getEventTypes() {
        return 21;
    }

    public void onEvent(final EventIterator eventIterator) {
        try {
            JCRSessionWrapper eventSession = ((JCREventIterator)eventIterator).getSession();
            JahiaUser user = eventSession.getUser();
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(user, this.workspace, null, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    HashSet<Session> sessions = null;
                    while (eventIterator.hasNext()) {
                        Event event = eventIterator.nextEvent();
                        if (DefaultValueListener.this.isExternal(event)) continue;
                        try {
                            JCRNodeWrapper node;
                            block10: {
                                node = null;
                                String eventPath = event.getPath();
                                try {
                                    if (event.getType() == 1) {
                                        node = (JCRNodeWrapper)session.getItem(eventPath);
                                    }
                                    if (!eventPath.endsWith("jcr:mixinTypes")) break block10;
                                    String path = eventPath.substring(0, eventPath.lastIndexOf(47));
                                    node = (JCRNodeWrapper)session.getItem(path.length() == 0 ? "/" : path);
                                }
                                catch (PathNotFoundException e) {
                                    continue;
                                }
                            }
                            if (node == null || !DefaultValueListener.this.handleNode(node)) continue;
                            node.getRealNode().getSession().save();
                            if (sessions == null) {
                                sessions = new HashSet<Session>();
                            }
                            sessions.add(node.getRealNode().getSession());
                        }
                        catch (NoSuchNodeTypeException node) {
                        }
                        catch (Exception e) {
                            logger.error("Error when executing event", (Throwable)e);
                        }
                    }
                    if (sessions != null && !sessions.isEmpty()) {
                        for (Session jcrsession : sessions) {
                            jcrsession.save();
                        }
                    }
                    return null;
                }
            });
        }
        catch (NoSuchNodeTypeException eventSession) {
        }
        catch (Exception e) {
            logger.error("Error when executing event", (Throwable)e);
        }
    }

    private boolean handleNode(JCRNodeWrapper node) throws RepositoryException {
        boolean anythingChanged = false;
        JCRSiteNode resolvedSite = node.getResolveSite();
        ArrayList<ExtendedNodeType> nodeTypes = new ArrayList<ExtendedNodeType>();
        ExtendedNodeType primaryNodeType = node.getPrimaryNodeType();
        nodeTypes.add(primaryNodeType);
        ExtendedNodeType[] mixin = node.getMixinNodeTypes();
        nodeTypes.addAll(Arrays.asList(mixin));
        List<Locale> locales = resolvedSite == null ? null : resolvedSite.getLanguagesAsLocales();
        for (NodeType nodeType : nodeTypes) {
            ExtendedNodeType extendedNodeType = NodeTypeRegistry.getInstance().getNodeType(nodeType.getName());
            if (extendedNodeType != null && locales != null) {
                Collection<ExtendedPropertyDefinition> propertyDefinitions = extendedNodeType.getPropertyDefinitionsAsMap().values();
                for (ExtendedPropertyDefinition propertyDefinition : propertyDefinitions) {
                    if (!propertyDefinition.isAutoCreated() || !propertyDefinition.isInternationalized() && !propertyDefinition.isOverride()) continue;
                    Value[] defValues = propertyDefinition.getDefaultValues();
                    for (Locale locale : locales) {
                        defValues = propertyDefinition.hasDynamicDefaultValues() ? propertyDefinition.getDefaultValues(locale) : defValues;
                        if (defValues.length <= 0) continue;
                        boolean handled = this.handlePropertyDefaultValues(node, propertyDefinition, defValues, locale);
                        anythingChanged = anythingChanged || handled;
                    }
                }
            }
            if (extendedNodeType == null) continue;
            Collection<ExtendedNodeDefinition> childNodeDefinitions = extendedNodeType.getChildNodeDefinitionsAsMap().values();
            for (ExtendedNodeDefinition definition : childNodeDefinitions) {
                if (!definition.isAutoCreated() || node.hasNode(definition.getName())) continue;
                JCRNodeWrapper autoCreated = node.addNode(definition.getName(), definition.getDefaultPrimaryTypeName());
                if (autoCreated.isNodeType("jmix:originWS")) {
                    autoCreated.setProperty("j:originWS", this.workspace);
                }
                this.handleNode(autoCreated);
                anythingChanged = true;
            }
        }
        return anythingChanged;
    }

    protected boolean handlePropertyDefaultValues(JCRNodeWrapper n, ExtendedPropertyDefinition pd, Value[] values, Locale locale) throws RepositoryException {
        String propertyName;
        JCRNodeWrapper targetNode = pd.isInternationalized() ? n.getOrCreateI18N(locale) : n;
        if (targetNode.hasProperty(propertyName = pd.getName())) {
            return false;
        }
        boolean valuesSet = false;
        if (values.length > 0) {
            if (pd.isMultiple()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Setting default values for property [{}].[{}]: {}", new Object[]{pd.getDeclaringNodeType().getName(), propertyName, Arrays.stream(values).map(ThrowingFunction.unchecked(Value::getString)).collect(Collectors.joining(", "))});
                }
                targetNode.setProperty(propertyName, values);
            } else if (values.length == 1) {
                targetNode.setProperty(propertyName, values[0]);
                if (logger.isDebugEnabled()) {
                    logger.debug("Setting default value for property [{}].[{}]: {}", new Object[]{pd.getDeclaringNodeType().getName(), propertyName, values[0].getString()});
                }
            } else {
                throw new ValueFormatException("Property [" + pd.getDeclaringNodeType().getName() + "].[" + propertyName + "] cannot accept multiple values");
            }
            valuesSet = true;
        }
        return valuesSet;
    }
}

