/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.retention.RetentionManager;
import javax.jcr.security.AccessControlManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import javax.validation.ConstraintViolation;
import javax.validation.groups.Default;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.commons.xml.SystemViewExporter;
import org.apache.jackrabbit.core.security.JahiaLoginModule;
import org.jahia.services.content.CompositeConstraintViolationException;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRItemWrapper;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRNodeWrapperImpl;
import org.jahia.services.content.JCRObservationManager;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRValueFactoryImpl;
import org.jahia.services.content.JCRVersionService;
import org.jahia.services.content.JCRWorkspaceWrapper;
import org.jahia.services.content.MultiplePropertyIterator;
import org.jahia.services.content.NodeConstraintViolationException;
import org.jahia.services.content.PropertyConstraintViolationException;
import org.jahia.services.content.PropertyIteratorImpl;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.content.decorator.validation.AdvancedGroup;
import org.jahia.services.content.decorator.validation.AdvancedSkipOnImportGroup;
import org.jahia.services.content.decorator.validation.DefaultSkipOnImportGroup;
import org.jahia.services.content.decorator.validation.JCRNodeValidator;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.importexport.DocumentViewExporter;
import org.jahia.services.importexport.DocumentViewImportHandler;
import org.jahia.services.importexport.ReferencesHelper;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.settings.readonlymode.ReadOnlyModeController;
import org.jahia.utils.i18n.Messages;
import org.jahia.utils.xml.JahiaSAXParserFactory;
import org.jahia.utils.xml.JahiaTransformerFactory;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class JCRSessionWrapper
implements Session {
    private static final Logger logger = LoggerFactory.getLogger(JCRSessionWrapper.class);
    public static final String DEREF_SEPARATOR = "@/";
    private JCRSessionFactory sessionFactory;
    private JahiaUser user;
    private Credentials credentials;
    private JCRWorkspaceWrapper workspace;
    private boolean isLive = true;
    private Locale locale;
    private Set<String> tokens = new HashSet<String>();
    private Map<JCRStoreProvider, Session> sessions = new HashMap<JCRStoreProvider, Session>();
    private Map<String, JCRNodeWrapper> sessionCacheByPath = new HashMap<String, JCRNodeWrapper>();
    private Map<String, JCRNodeWrapper> sessionCacheByIdentifier = new HashMap<String, JCRNodeWrapper>();
    private Map<String, JCRNodeWrapper> newNodes = new HashMap<String, JCRNodeWrapper>();
    private Map<String, JCRNodeWrapper> changedNodes = new HashMap<String, JCRNodeWrapper>();
    private Map<String, String> nsToPrefix = new HashMap<String, String>();
    private Map<String, String> prefixToNs = new HashMap<String, String>();
    private Map<String, String> uuidMapping = new HashMap<String, String>();
    private Map<String, String> pathMapping = new LinkedHashMap<String, String>();
    private Map<String, Object> resolvedReferences = new HashMap<String, Object>();
    private boolean isSystem;
    private boolean skipValidation;
    private boolean isCurrentUserSession = false;
    private Date versionDate;
    private Locale fallbackLocale;
    private String versionLabel;
    private boolean readOnlyCacheEnabled = false;
    private static AtomicLong activeSessions = new AtomicLong(0L);
    private Exception thisSessionTrace;
    protected UUID uuid = UUID.randomUUID();
    private static Map<UUID, JCRSessionWrapper> activeSessionsObjects = new ConcurrentSkipListMap<UUID, JCRSessionWrapper>();
    private boolean ignoreReadOnlyMode = false;

    public JCRSessionWrapper(JahiaUser user, Credentials credentials, boolean isSystem, String workspace, Locale locale, JCRSessionFactory sessionFactory, Locale fallbackLocale) {
        this.user = user;
        this.credentials = credentials;
        this.isSystem = isSystem;
        this.versionDate = null;
        this.versionLabel = null;
        this.workspace = workspace == null ? new JCRWorkspaceWrapper("default", this, sessionFactory) : new JCRWorkspaceWrapper(workspace, this, sessionFactory);
        this.locale = locale;
        this.fallbackLocale = fallbackLocale;
        this.sessionFactory = sessionFactory;
        if (!isSystem) {
            activeSessions.incrementAndGet();
        }
        this.thisSessionTrace = SettingsBean.getInstance().isDevelopmentMode() ? new Exception((isSystem ? "System " : "") + "Session: " + this.uuid + " Thread: " + Thread.currentThread().getName() + "_" + Thread.currentThread().getId() + " created " + new DateTime().toString()) : new Exception((isSystem ? "System " : "") + "Session: " + this.uuid);
        activeSessionsObjects.put(this.uuid, this);
    }

    public JCRNodeWrapper getRootNode() throws RepositoryException {
        JCRStoreProvider provider = this.sessionFactory.getProvider("/");
        return provider.getNodeWrapper(this.getProviderSession(provider).getRootNode(), "/", null, this);
    }

    public Repository getRepository() {
        return this.sessionFactory;
    }

    public String getUserID() {
        return ((SimpleCredentials)this.credentials).getUserID();
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public boolean isSkipValidation() {
        return this.skipValidation;
    }

    public void setSkipValidation(boolean skipValidation) {
        this.skipValidation = skipValidation;
    }

    public Object getAttribute(String s) {
        return null;
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public JCRWorkspaceWrapper getWorkspace() {
        return this.workspace;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Session impersonate(Credentials credentials) throws LoginException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public JCRNodeWrapper getNodeByUUID(String uuid) throws ItemNotFoundException, RepositoryException {
        return this.getNodeByUUID(uuid, true);
    }

    public JCRNodeWrapper getNodeByUUID(String uuid, boolean checkVersion) throws ItemNotFoundException, RepositoryException {
        if (StringUtils.isEmpty((String)uuid)) {
            throw new RepositoryException("invalid identifier: " + uuid);
        }
        if (this.sessionCacheByIdentifier.containsKey(uuid)) {
            return this.sessionCacheByIdentifier.get(uuid);
        }
        Throwable originalEx = null;
        for (JCRStoreProvider provider : this.sessionFactory.getProviderList()) {
            if (!provider.isInitialized()) {
                logger.debug("Provider " + provider.getKey() + " / " + provider.getClass().getName() + " is not yet initialized, skipping...");
                continue;
            }
            try {
                JCRNodeWrapper frozen;
                Session session = this.getProviderSession(provider);
                boolean isAliased = this.sessionFactory.checkAliasedStatusAndToggleSessionIfNeeded(session, this.getUser());
                Node n = session.getNodeByIdentifier(uuid);
                JCRNodeWrapper wrapper = null;
                if (checkVersion && (this.versionDate != null || this.versionLabel != null) && (frozen = this.getFrozenVersionAsRegular(n, provider, false)) != null) {
                    wrapper = frozen;
                }
                if (wrapper == null) {
                    wrapper = provider.getNodeWrapper(n, this);
                }
                if (!isAliased) {
                    this.sessionCacheByIdentifier.put(uuid, wrapper);
                    this.sessionCacheByPath.put(wrapper.getPath(), wrapper);
                }
                return wrapper;
            }
            catch (ItemNotFoundException ee) {
                if (originalEx != null) continue;
                originalEx = ee;
            }
            catch (UnsupportedRepositoryOperationException uso) {
                logger.debug("getNodeByUUID unsupported by: {} / {}", (Object)provider.getKey(), (Object)provider.getClass().getName());
                if (originalEx != null) continue;
                originalEx = uso;
            }
            catch (RepositoryException ex) {
                if (originalEx == null) {
                    originalEx = ex;
                }
                logger.warn("repository exception : " + provider.getKey() + " / " + provider.getClass().getName() + " : " + ex.getMessage());
            }
        }
        if (originalEx != null) {
            if (originalEx instanceof ItemNotFoundException) {
                throw originalEx;
            }
            throw new ItemNotFoundException(uuid, originalEx);
        }
        throw new ItemNotFoundException(uuid);
    }

    public JCRNodeWrapper getNodeByUUID(String providerKey, String uuid) throws ItemNotFoundException, RepositoryException {
        JCRStoreProvider provider = this.sessionFactory.getProviders().get(providerKey);
        if (provider == null) {
            throw new ItemNotFoundException(uuid);
        }
        Session session = this.getProviderSession(provider);
        Node n = session.getNodeByIdentifier(uuid);
        return provider.getNodeWrapper(n, this);
    }

    public JCRItemWrapper getItem(String path) throws PathNotFoundException, RepositoryException {
        return this.getItem(path, true);
    }

    public JCRItemWrapper getItem(String path, boolean checkVersion) throws PathNotFoundException, RepositoryException {
        if (this.sessionCacheByPath.containsKey(path)) {
            return this.sessionCacheByPath.get(path);
        }
        if (path.contains(DEREF_SEPARATOR)) {
            JCRNodeWrapper parent = (JCRNodeWrapper)this.getItem(StringUtils.substringBeforeLast((String)path, (String)DEREF_SEPARATOR), checkVersion);
            return this.dereference(parent, StringUtils.substringAfterLast((String)path, (String)DEREF_SEPARATOR));
        }
        for (Map.Entry<String, JCRStoreProvider> mp : this.sessionFactory.getMountPoints().entrySet()) {
            String key = mp.getKey();
            JCRStoreProvider provider = mp.getValue();
            if (!provider.isDefault() && !path.equals(key) && !path.startsWith(key + "/")) continue;
            String localPath = path;
            if (!key.equals("/")) {
                localPath = localPath.substring(key.length());
            }
            if (localPath.equals("")) {
                localPath = "/";
            }
            Session session = this.getProviderSession(provider);
            boolean isAliased = this.sessionFactory.checkAliasedStatusAndToggleSessionIfNeeded(session, this.getUser());
            Item item = session.getItem(provider.getRelativeRoot() + localPath);
            if (item.isNode()) {
                JCRNodeWrapper frozen;
                Node node = (Node)item;
                JCRNodeWrapper wrapper = null;
                if (checkVersion && (this.versionDate != null || this.versionLabel != null) && node.isNodeType("mix:versionable") && (frozen = this.getFrozenVersionAsRegular(node, provider, false)) != null) {
                    wrapper = frozen;
                }
                if (wrapper == null) {
                    wrapper = provider.getNodeWrapper(node, localPath, null, this);
                }
                if (!isAliased) {
                    this.sessionCacheByPath.put(path, wrapper);
                    this.sessionCacheByIdentifier.put(wrapper.getIdentifier(), wrapper);
                }
                return wrapper;
            }
            JCRPropertyWrapper jcrPropertyWrapper = provider.getPropertyWrapper((Property)item, this);
            return jcrPropertyWrapper.getParent().getProperty(jcrPropertyWrapper.getName());
        }
        throw new PathNotFoundException(path);
    }

    private JCRNodeWrapper dereference(JCRNodeWrapper parent, String refPath) throws RepositoryException {
        JCRNodeWrapper wrapper;
        JCRNodeWrapper referencedNode = (JCRNodeWrapper)parent.getProperty("j:node").getNode();
        Node realReferencedNode = referencedNode.getRealNode();
        String fullPath = parent.getPath() + DEREF_SEPARATOR + refPath;
        String refRootName = StringUtils.substringBefore((String)refPath, (String)"/");
        if (!realReferencedNode.getName().equals(refRootName)) {
            throw new PathNotFoundException(fullPath);
        }
        if ((refPath = StringUtils.substringAfter((String)refPath, (String)"/")).equals("")) {
            wrapper = referencedNode.getProvider().getNodeWrapper(realReferencedNode, fullPath, parent, this);
        } else {
            Node node = realReferencedNode.getNode(refPath);
            fullPath = parent.getPath() + DEREF_SEPARATOR + refRootName + node.getPath().substring(realReferencedNode.getPath().length());
            wrapper = referencedNode.getProvider().getNodeWrapper(node, fullPath, null, this);
        }
        this.sessionCacheByPath.put(fullPath, wrapper);
        return wrapper;
    }

    public JCRNodeWrapper getNode(String path) throws PathNotFoundException, RepositoryException {
        return this.getNode(path, true);
    }

    public JCRNodeWrapper getNode(String path, boolean checkVersion) throws PathNotFoundException, RepositoryException {
        JCRItemWrapper item = this.getItem(path, checkVersion);
        if (item.isNode()) {
            return (JCRNodeWrapper)item;
        }
        throw new PathNotFoundException();
    }

    public boolean itemExists(String path) throws RepositoryException {
        try {
            this.getItem(path);
            return true;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public void move(String source, String dest) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.getWorkspace().move(source, dest, true);
        this.updatePathInCache(source, dest, this.sessionCacheByPath);
        this.updatePathInCache(source, dest, this.newNodes);
        this.updatePathInCache(source, dest, this.changedNodes);
    }

    private void updatePathInCache(String source, String dest, Map<String, JCRNodeWrapper> cacheByPath) {
        String sourcePrefix = source + "/";
        HashSet<String> paths = new HashSet<String>(cacheByPath.keySet());
        for (String s : paths) {
            if (!s.equals(source) && !s.startsWith(sourcePrefix)) continue;
            JCRNodeWrapper n = cacheByPath.remove(s);
            if (n instanceof JCRNodeDecorator) {
                n = ((JCRNodeDecorator)n).getDecoratedNode();
            }
            String newPath = dest;
            if (source.length() < n.getPath().length()) {
                newPath = newPath + n.getPath().substring(source.length());
            }
            String localPath = newPath;
            if (n.getProvider().getMountPoint().length() > 1) {
                localPath = newPath.substring(n.getProvider().getMountPoint().length());
            }
            ((JCRNodeWrapperImpl)n).localPath = localPath;
            ((JCRNodeWrapperImpl)n).localPathInProvider = localPath;
            cacheByPath.put(newPath, n);
        }
    }

    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.save(1);
    }

    void registerNewNode(JCRNodeWrapper node) {
        this.newNodes.put(node.getPath(), node);
    }

    void registerChangedNode(JCRNodeWrapper node) {
        if (!this.newNodes.containsKey(node.getPath())) {
            this.changedNodes.put(node.getPath(), node);
        }
    }

    void unregisterNewNode(JCRNodeWrapper node) {
        if (!this.newNodes.isEmpty() || !this.changedNodes.isEmpty()) {
            this.newNodes.remove(node.getPath());
            this.changedNodes.remove(node.getPath());
            try {
                if (node.hasNodes()) {
                    JCRNodeIteratorWrapper it = node.getNodes();
                    while (it.hasNext()) {
                        this.unregisterNewNode((JCRNodeWrapper)it.next());
                    }
                }
            }
            catch (RepositoryException e) {
                logger.warn("Error unregistering new nodes", (Throwable)e);
            }
        }
    }

    public Collection<JCRNodeWrapper> getChangedNodes() {
        ArrayList<JCRNodeWrapper> nodes = new ArrayList<JCRNodeWrapper>(this.changedNodes.size() + this.newNodes.size());
        nodes.addAll(this.changedNodes.values());
        nodes.addAll(this.newNodes.values());
        return nodes;
    }

    public void save(int operationType) throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.validate(operationType);
        JCRObservationManager.doWorkspaceWriteCall(this, operationType, new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper thisSession) throws RepositoryException {
                for (Session session : JCRSessionWrapper.this.sessions.values()) {
                    session.save();
                }
                return null;
            }
        });
        this.newNodes.clear();
        this.changedNodes.clear();
        if (this.workspace.getName().equals("default")) {
            ReferencesHelper.updateReferencesInLive(this.getResolvedReferences());
        }
    }

    public void validate() throws ConstraintViolationException, RepositoryException {
        this.validate(1);
    }

    protected void validate(int operationType) throws ConstraintViolationException, RepositoryException {
        if (!this.skipValidation) {
            CompositeConstraintViolationException exception = this.validateNodes(this.newNodes.values(), null, operationType);
            exception = this.validateNodes(this.changedNodes.values(), exception, operationType);
            if (exception != null) {
                this.refresh(true);
                throw exception;
            }
        }
    }

    protected CompositeConstraintViolationException validateNodes(Collection<JCRNodeWrapper> nodes, CompositeConstraintViolationException ccve, int operationType) throws ConstraintViolationException, RepositoryException {
        boolean isImportOperation = operationType == 13;
        for (JCRNodeWrapper node : nodes) {
            Locale errorLocale;
            try {
                for (String s : node.getNodeTypes()) {
                    Collection<ExtendedPropertyDefinition> propDefs = NodeTypeRegistry.getInstance().getNodeType(s).getPropertyDefinitionsAsMap().values();
                    for (ExtendedPropertyDefinition propertyDefinition : propDefs) {
                        String propertyName = propertyDefinition.getName();
                        if (!propertyDefinition.isMandatory() || propertyDefinition.getRequiredType() == 10 || propertyDefinition.getRequiredType() == 9 || propertyDefinition.isProtected() || propertyDefinition.isAutoCreated() && node.isNew() || propertyDefinition.isInternationalized() && this.getLocale() == null || node.hasProperty(propertyName) && (propertyDefinition.isMultiple() || propertyDefinition.getRequiredType() == 2 || !StringUtils.isEmpty((String)node.getProperty(propertyName).getString()))) continue;
                        errorLocale = null;
                        if (propertyDefinition.isInternationalized()) {
                            errorLocale = this.getLocale();
                        }
                        ccve = this.addError(ccve, new PropertyConstraintViolationException(node, Messages.getInternal("label.error.mandatoryField", LocaleContextHolder.getLocale(), "Field is mandatory"), errorLocale, propertyDefinition));
                    }
                }
            }
            catch (InvalidItemStateException e) {
                logger.debug("A new node can no longer be accessed to run validation checks", (Throwable)e);
            }
            Map<String, Constructor<?>> validators = this.sessionFactory.getDefaultProvider().getValidators();
            LinkedHashSet constraintViolations = new LinkedHashSet();
            for (Map.Entry<String, Constructor<?>> validatorEntry : validators.entrySet()) {
                if (!node.isNodeType(validatorEntry.getKey())) continue;
                try {
                    Set validate;
                    JCRNodeValidator validatorDecoratedNode = (JCRNodeValidator)validatorEntry.getValue().newInstance(node);
                    LocalValidatorFactoryBean validatorFactoryBean = this.sessionFactory.getValidatorFactoryBean();
                    Set set = validate = !isImportOperation ? validatorFactoryBean.validate((Object)validatorDecoratedNode, new Class[]{Default.class, DefaultSkipOnImportGroup.class}) : validatorFactoryBean.validate((Object)validatorDecoratedNode, new Class[]{Default.class});
                    if (validate.isEmpty()) {
                        validate = !isImportOperation ? validatorFactoryBean.validate((Object)validatorDecoratedNode, new Class[]{AdvancedGroup.class, AdvancedSkipOnImportGroup.class}) : validatorFactoryBean.validate((Object)validatorDecoratedNode, new Class[]{AdvancedGroup.class});
                    }
                    constraintViolations.addAll(validate);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            for (ConstraintViolation constraintViolation : constraintViolations) {
                String propertyName;
                try {
                    Method propertyNameGetter = constraintViolation.getConstraintDescriptor().getAnnotation().annotationType().getMethod("propertyName", new Class[0]);
                    propertyName = (String)propertyNameGetter.invoke((Object)constraintViolation.getConstraintDescriptor().getAnnotation(), new Object[0]);
                }
                catch (Exception e) {
                    propertyName = constraintViolation.getPropertyPath().toString();
                }
                if (StringUtils.isNotBlank((String)propertyName)) {
                    ExtendedPropertyDefinition propertyDefinition = node.getApplicablePropertyDefinition(propertyName);
                    if (propertyDefinition == null) {
                        propertyDefinition = node.getApplicablePropertyDefinition(propertyName.replaceFirst("_", ":"));
                    }
                    if (propertyDefinition != null) {
                        errorLocale = null;
                        if (propertyDefinition.isInternationalized() && (errorLocale = this.getLocale()) == null) continue;
                        ccve = this.addError(ccve, new PropertyConstraintViolationException(node, constraintViolation.getMessage(), errorLocale, propertyDefinition));
                        continue;
                    }
                    ccve = this.addError(ccve, new NodeConstraintViolationException(node, constraintViolation.getMessage(), null));
                    continue;
                }
                ccve = this.addError(ccve, new NodeConstraintViolationException(node, constraintViolation.getMessage(), null));
            }
        }
        return ccve;
    }

    private CompositeConstraintViolationException addError(CompositeConstraintViolationException ccve, ConstraintViolationException exception) {
        if (ccve == null) {
            ccve = new CompositeConstraintViolationException();
        }
        ccve.addException(exception);
        return ccve;
    }

    public void refresh(boolean b) throws RepositoryException {
        for (Session session : this.sessions.values()) {
            session.refresh(b);
        }
        if (!b) {
            this.newNodes.clear();
            this.changedNodes.clear();
            this.flushCaches();
        }
    }

    public boolean hasPendingChanges() throws RepositoryException {
        for (Session session : this.sessions.values()) {
            if (!session.hasPendingChanges()) continue;
            return true;
        }
        return false;
    }

    public ValueFactory getValueFactory() {
        return JCRValueFactoryImpl.getInstance();
    }

    public void checkPermission(String absPath, String actions) throws AccessControlException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public ContentHandler getImportContentHandler(String s, int i) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void importXML(String path, InputStream inputStream, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, VersionException, InvalidSerializedDataException, LockException, RepositoryException {
        this.importXML(path, inputStream, uuidBehavior, 1);
    }

    public void importXML(String path, InputStream inputStream, int uuidBehavior, int rootBehavior) throws IOException, InvalidSerializedDataException, RepositoryException {
        HashMap<String, List<String>> references = new HashMap<String, List<String>>();
        this.importXML(path, inputStream, uuidBehavior, rootBehavior, null, references);
        ReferencesHelper.resolveCrossReferences(this, references);
    }

    public void importXML(String path, InputStream inputStream, int uuidBehavior, int rootBehavior, Map<String, String> replacements, Map<String, List<String>> references) throws IOException, InvalidSerializedDataException, RepositoryException {
        JCRNodeWrapper node = this.getNode(path);
        try {
            if (!node.isCheckedOut()) {
                this.checkout(node);
            }
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
        DocumentViewImportHandler documentViewImportHandler = new DocumentViewImportHandler(this, path);
        documentViewImportHandler.setRootBehavior(rootBehavior);
        documentViewImportHandler.setUuidBehavior(uuidBehavior);
        documentViewImportHandler.setReplacements(replacements);
        if (references != null) {
            documentViewImportHandler.setReferences(references);
        }
        try {
            SAXParser parser = JahiaSAXParserFactory.newInstance().newSAXParser();
            parser.parse(inputStream, (DefaultHandler)documentViewImportHandler);
        }
        catch (SAXParseException e) {
            logger.error("Cannot import - File contains invalid XML", (Throwable)e);
            throw new RuntimeException("Cannot import file because it contains invalid XML", e);
        }
        catch (Exception e) {
            logger.error("Cannot import", (Throwable)e);
            throw new RuntimeException("Cannot import file", e);
        }
    }

    public void setNamespacePrefix(String prefix, String uri) throws NamespaceException, RepositoryException {
        this.nsToPrefix.put(uri, prefix);
        this.prefixToNs.put(prefix, uri);
        for (Session s : this.sessions.values()) {
            s.setNamespacePrefix(prefix, uri);
            try {
                NamespaceRegistry nsReg = s.getWorkspace().getNamespaceRegistry();
                if (nsReg == null) continue;
                nsReg.registerNamespace(prefix, uri);
            }
            catch (RepositoryException e) {
                logger.debug("Prefix/uri could not be registered in workspace's registry- " + prefix + "/" + uri, (Throwable)e);
            }
        }
    }

    public String[] getNamespacePrefixes() throws RepositoryException {
        HashSet<String> wsPrefixes = new HashSet<String>(Arrays.asList(this.getWorkspace().getNamespaceRegistry().getPrefixes()));
        wsPrefixes.addAll(this.prefixToNs.keySet());
        return wsPrefixes.toArray(new String[wsPrefixes.size()]);
    }

    public String getNamespaceURI(String prefix) throws NamespaceException, RepositoryException {
        if (this.prefixToNs.containsKey(prefix)) {
            return this.prefixToNs.get(prefix);
        }
        return this.getWorkspace().getNamespaceRegistry().getURI(prefix);
    }

    public String getNamespacePrefix(String uri) throws NamespaceException, RepositoryException {
        if (this.nsToPrefix.containsKey(uri)) {
            return this.nsToPrefix.get(uri);
        }
        return this.getWorkspace().getNamespaceRegistry().getPrefix(uri);
    }

    public void logout() {
        if (this.isCurrentUserSession) {
            logger.debug("Cannot close shared session");
            return;
        }
        this.doLogout();
    }

    void doLogout() {
        for (Session session : this.sessions.values()) {
            if (!session.isLive()) continue;
            session.logout();
        }
        this.sessions.clear();
        if (this.credentials instanceof SimpleCredentials) {
            SimpleCredentials simpleCredentials = (SimpleCredentials)this.credentials;
            JahiaLoginModule.removeToken(simpleCredentials.getUserID(), new String(simpleCredentials.getPassword()));
        }
        this.isLive = false;
        if (activeSessionsObjects.remove(this.uuid) == null) {
            logger.error("Could not removed session " + this + " opened here \n", (Throwable)this.thisSessionTrace);
        }
        if (!this.isSystem) {
            long actives = activeSessions.decrementAndGet();
            if (logger.isDebugEnabled() && actives < (long)activeSessionsObjects.size()) {
                HashMap<UUID, JCRSessionWrapper> copyActives = new HashMap<UUID, JCRSessionWrapper>(activeSessionsObjects);
                logger.debug("There is {} sessions but {} is retained", (Object)actives, (Object)copyActives.size());
                for (Map.Entry entry : copyActives.entrySet()) {
                    logger.debug("Active Session " + entry.getKey() + " is" + (((JCRSessionWrapper)entry.getValue()).isLive() ? "" : " not") + " live", (Throwable)((JCRSessionWrapper)entry.getValue()).getSessionTrace());
                }
            }
        }
    }

    public boolean isLive() {
        return this.isLive;
    }

    public void addLockToken(String token) {
        this.tokens.add(token);
        for (Session session : this.sessions.values()) {
            session.addLockToken(token);
        }
    }

    public String[] getLockTokens() {
        HashSet<String> allTokens = new HashSet<String>();
        allTokens.addAll(this.tokens);
        allTokens.addAll(this.sessions.values().stream().map(Session::getLockTokens).flatMap(Arrays::stream).collect(Collectors.toSet()));
        return allTokens.toArray(new String[allTokens.size()]);
    }

    public void removeLockToken(String token) {
        this.tokens.remove(token);
        for (Session session : this.sessions.values()) {
            session.removeLockToken(token);
        }
    }

    public Collection<Session> getAllSessions() {
        return this.sessions.values();
    }

    public Session getProviderSession(JCRStoreProvider provider) throws RepositoryException {
        return this.getProviderSession(provider, true);
    }

    public Session getProviderSession(JCRStoreProvider provider, boolean create) throws RepositoryException {
        if (this.sessions.get(provider) != null && !this.sessions.get(provider).isLive()) {
            this.sessions.remove(provider);
        }
        if (this.sessions.get(provider) == null && create) {
            Session s = null;
            if (this.credentials instanceof SimpleCredentials) {
                SimpleCredentials simpleCredentials = (SimpleCredentials)this.credentials;
                JahiaLoginModule.Token token = JahiaLoginModule.getToken(simpleCredentials.getUserID(), new String(simpleCredentials.getPassword()));
                JahiaUser user = this.getUser();
                String username = JahiaUserManagerService.isGuest(user) ? " guest " : user.getUsername();
                if (this.isCurrentUserSession()) {
                    s = provider.getSessionFactory().findSameSession(provider, username, this.workspace.getName(), this.isSystem());
                }
                if (s == null) {
                    s = provider.getSession(this.credentials, this.workspace.getName());
                }
                JahiaLoginModule.removeToken(simpleCredentials.getUserID(), new String(simpleCredentials.getPassword()));
                this.credentials = JahiaLoginModule.getCredentials(simpleCredentials.getUserID(), (String)simpleCredentials.getAttribute("org.jahia.realm"), token != null ? token.deniedPath : null);
            } else {
                s = provider.getSession(this.credentials, this.workspace.getName());
            }
            this.sessions.put(provider, s);
            for (String string : this.tokens) {
                s.addLockToken(string);
            }
            for (Map.Entry entry : this.prefixToNs.entrySet()) {
                s.setNamespacePrefix((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return this.sessions.get(provider);
    }

    public JahiaUser getUser() {
        return this.user;
    }

    public JahiaUser getAliasedUser() {
        return this.sessionFactory.getCurrentAliasedUser();
    }

    public Calendar getPreviewDate() {
        return this.sessionFactory.getCurrentPreviewDate();
    }

    public void exportDocumentView(String path, ContentHandler handler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        DocumentViewExporter exporter = new DocumentViewExporter(this, handler, skipBinary, noRecurse);
        JCRItemWrapper item = this.getItem(path);
        if (!item.isNode()) {
            throw new PathNotFoundException("XML export is not defined for properties: " + path);
        }
        exporter.export((JCRNodeWrapper)item);
    }

    public void exportSystemView(String path, ContentHandler handler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        SystemViewExporter exporter = new SystemViewExporter((Session)this, handler, !noRecurse, !skipBinary);
        JCRItemWrapper item = this.getItem(path);
        if (!item.isNode()) {
            throw new PathNotFoundException("XML export is not defined for properties: " + path);
        }
        exporter.export((Node)((JCRNodeWrapper)item));
    }

    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, RepositoryException {
        try {
            ContentHandler handler = this.getExportContentHandler(out);
            this.exportDocumentView(absPath, handler, skipBinary, noRecurse);
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RepositoryException("Error serializing document view XML", (Throwable)e);
        }
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, RepositoryException {
        try {
            ContentHandler handler = this.getExportContentHandler(out);
            this.exportSystemView(absPath, handler, skipBinary, noRecurse);
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RepositoryException("Error serializing system view XML", (Throwable)e);
        }
    }

    private ContentHandler getExportContentHandler(OutputStream stream) throws RepositoryException {
        try {
            SAXTransformerFactory transformerFactory = (SAXTransformerFactory)JahiaTransformerFactory.newInstance();
            TransformerHandler handler = transformerFactory.newTransformerHandler();
            Transformer transformer = handler.getTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "no");
            handler.setResult(new StreamResult(stream));
            return handler;
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RepositoryException("SAX transformer implementation not available", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new RepositoryException("Error creating an XML export content handler", (Throwable)e);
        }
    }

    public JCRNodeWrapper getNodeByIdentifier(String id) throws ItemNotFoundException, RepositoryException {
        return this.getNodeByUUID(id);
    }

    public Property getProperty(String absPath) throws PathNotFoundException, RepositoryException {
        return (Property)this.getItem(absPath);
    }

    public boolean nodeExists(String absPath) throws RepositoryException {
        return this.itemExists(absPath);
    }

    public boolean propertyExists(String absPath) throws RepositoryException {
        return this.itemExists(absPath);
    }

    public void removeItem(String absPath) throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        JCRItemWrapper item = this.getItem(absPath);
        boolean flushNeeded = false;
        if (item.isNode()) {
            JCRNodeWrapper node = (JCRNodeWrapper)item;
            this.unregisterNewNode(node);
            if (node.hasNodes()) {
                flushNeeded = true;
            }
        }
        item.remove();
        if (flushNeeded) {
            this.flushCaches();
        } else {
            this.removeFromCache(item);
        }
    }

    void removeFromCache(JCRItemWrapper item) throws RepositoryException {
        this.sessionCacheByPath.remove(item.getPath());
        if (item instanceof JCRNodeWrapper) {
            this.sessionCacheByIdentifier.remove(((JCRNodeWrapper)item).getIdentifier());
        }
    }

    void removeFromCache(String path) throws RepositoryException {
        JCRNodeWrapper node = this.sessionCacheByPath.remove(path);
        if (node != null) {
            this.sessionCacheByIdentifier.remove(node.getIdentifier());
        }
    }

    public boolean hasPermission(String absPath, String actions) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public boolean hasCapability(String s, Object o, Object[] objects) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public AccessControlManager getAccessControlManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public RetentionManager getRetentionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void checkout(Node node) throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        while (!node.isCheckedOut()) {
            if (!node.isNodeType("mix:versionable") && !node.isNodeType("mix:simpleVersionable")) {
                node = node.getParent();
                continue;
            }
            String absPath = node.getPath();
            VersionManager versionManager = this.getWorkspace().getVersionManager();
            if (!versionManager.isCheckedOut(absPath)) {
                versionManager.checkout(absPath);
            }
            return;
        }
    }

    public Map<String, String> getUuidMapping() {
        return this.uuidMapping;
    }

    public Map<String, String> getPathMapping() {
        return this.pathMapping;
    }

    public Map<String, Object> getResolvedReferences() {
        return this.resolvedReferences;
    }

    public Locale getFallbackLocale() {
        return this.fallbackLocale;
    }

    public void setFallbackLocale(Locale fallbackLocale) {
        this.fallbackLocale = fallbackLocale;
    }

    public Date getVersionDate() {
        return this.versionDate;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public void setVersionDate(Date versionDate) {
        if (this.versionDate != null) {
            throw new RuntimeException("Should not change versionDate on a session in same thread");
        }
        this.versionDate = versionDate;
    }

    public void setVersionLabel(String versionLabel) {
        if (this.versionLabel == null) {
            if (versionLabel != null && !versionLabel.startsWith(this.getWorkspace().getName())) {
                throw new RuntimeException("Cannot use label " + versionLabel + " in workspace " + this.getWorkspace().getName());
            }
        } else {
            throw new RuntimeException("Should not change versionLabel on a session in same thread");
        }
        this.versionLabel = versionLabel;
    }

    public JCRNodeWrapper getFrozenVersionAsRegular(Node objectNode, JCRStoreProvider provider) throws RepositoryException {
        return this.getFrozenVersionAsRegular(objectNode, provider, true);
    }

    protected JCRNodeWrapper getFrozenVersionAsRegular(Node objectNode, JCRStoreProvider provider, boolean throwExeptionIfNotFound) throws RepositoryException {
        try {
            VersionHistory vh = objectNode.getSession().getWorkspace().getVersionManager().getVersionHistory(objectNode.getPath());
            Version v = null;
            if (this.versionLabel != null) {
                v = JCRVersionService.findVersionByLabel(vh, this.versionLabel);
            }
            if (v == null && this.versionDate != null) {
                v = JCRVersionService.findClosestVersion(vh, this.versionDate);
            }
            if (v == null) {
                if (throwExeptionIfNotFound) {
                    throw new PathNotFoundException();
                }
                return null;
            }
            Node frozen = v.getNode("jcr:frozenNode");
            return provider.getNodeWrapper(frozen, this);
        }
        catch (UnsupportedRepositoryOperationException e) {
            if (this.getVersionDate() == null && this.getVersionLabel() == null) {
                logger.error("Error while retrieving frozen version", (Throwable)e);
            }
            return null;
        }
    }

    public static long getActiveSessions() {
        return activeSessions.get();
    }

    public static Map<UUID, JCRSessionWrapper> getActiveSessionsObjects() {
        return Collections.unmodifiableMap(activeSessionsObjects);
    }

    protected void flushCaches() {
        this.sessionCacheByIdentifier.clear();
        this.sessionCacheByPath.clear();
    }

    protected JCRNodeWrapper getCachedNode(String uuid) {
        return this.sessionCacheByIdentifier.get(uuid);
    }

    public boolean isCurrentUserSession() {
        return this.isCurrentUserSession;
    }

    public void setCurrentUserSession(boolean isCurrentUserSession) {
        this.isCurrentUserSession = isCurrentUserSession;
    }

    public Exception getSessionTrace() {
        return this.thisSessionTrace;
    }

    public PropertyIterator getWeakReferences(JCRNodeWrapper node, String propertyName) throws RepositoryException {
        ArrayList<PropertyIterator> propertyIterators = new ArrayList<PropertyIterator>();
        for (JCRStoreProvider provider : this.sessionFactory.getProviderList()) {
            Session providerSession;
            PropertyIterator pi = provider.getWeakReferences(node, propertyName, providerSession = this.getProviderSession(provider));
            if (pi == null) continue;
            propertyIterators.add(new PropertyIteratorImpl(pi, this, provider));
        }
        return new MultiplePropertyIterator((List<PropertyIterator>)propertyIterators, -1L);
    }

    public String toString() {
        return "JCRSessionWrapper (" + this.workspace.getName() + ", " + this.locale + ", " + this.user + " [aliased as " + this.getAliasedUser() + "]) {sessions=" + this.sessions + '}';
    }

    public JCRUserNode getUserNode() throws RepositoryException {
        return (JCRUserNode)this.getNode(this.user.getLocalPath());
    }

    public String getIdentifier() {
        return this.uuid.toString();
    }

    public boolean isReadOnlyCacheEnabled() {
        return this.readOnlyCacheEnabled;
    }

    public void setReadOnlyCacheEnabled(boolean readOnlyCacheEnabled) {
        this.readOnlyCacheEnabled = readOnlyCacheEnabled;
    }

    public boolean isReadOnly() {
        return !this.ignoreReadOnlyMode && this.sessionFactory.isReadOnlyModeEnabled();
    }

    public void checkReadOnly(String message) {
        if (this.isReadOnly()) {
            ReadOnlyModeController.readOnlyModeViolated(message);
        }
    }

    void setIgnoreReadOnlyMode(boolean ignored) {
        this.ignoreReadOnlyMode = ignored;
    }
}

