/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.util.XMLChar;

public class NamespaceRegistryWrapper
implements NamespaceRegistry {
    private Map<String, String> nsToPrefix = new HashMap<String, String>();
    private Map<String, String> prefixToNs = new HashMap<String, String>();
    private static final HashSet<String> reservedPrefixes = new HashSet();
    private static final HashSet<String> reservedURIs = new HashSet();

    public NamespaceRegistryWrapper() {
        this.internalRegister("j", "http://www.jahia.org/jahia/1.0");
        this.internalRegister("jnt", "http://www.jahia.org/jahia/nt/1.0");
        this.internalRegister("jmix", "http://www.jahia.org/jahia/mix/1.0");
        this.internalRegister("nt", "http://www.jcp.org/jcr/nt/1.0");
        this.internalRegister("mix", "http://www.jcp.org/jcr/mix/1.0");
        this.internalRegister("jcr", "http://www.jcp.org/jcr/1.0");
        this.internalRegister("sv", "http://www.jcp.org/jcr/sv/1.0");
        this.internalRegister("", "");
        this.internalRegister("xml", "http://www.w3.org/XML/1998/namespace");
        this.internalRegister("rep", "internal");
    }

    public synchronized void registerNamespace(String prefix, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        if (prefix == null || uri == null) {
            throw new IllegalArgumentException("prefix/uri can not be null");
        }
        if ("".equals(prefix) || "".equals(uri)) {
            throw new NamespaceException("default namespace is reserved and can not be changed");
        }
        if (this.prefixToNs.containsKey(prefix)) {
            throw new NamespaceException();
        }
        if (reservedURIs.contains(uri)) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": reserved URI");
        }
        if (reservedPrefixes.contains(prefix)) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": reserved prefix");
        }
        if (prefix.toLowerCase().startsWith("xml")) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": reserved prefix");
        }
        if (!XMLChar.isValidNCName((String)prefix)) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": invalid prefix");
        }
        String oldPrefix = this.nsToPrefix.get(uri);
        if (prefix.equals(oldPrefix)) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": mapping already exists");
        }
        if (this.prefixToNs.containsKey(prefix)) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": remapping existing prefixes is not supported.");
        }
        this.internalRegister(prefix, uri);
    }

    private void internalRegister(String prefix, String uri) {
        this.nsToPrefix.put(uri, prefix);
        this.prefixToNs.put(prefix, uri);
    }

    public void unregisterNamespace(String prefix) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        if (reservedPrefixes.contains(prefix)) {
            throw new NamespaceException("reserved prefix: " + prefix);
        }
        if (!this.prefixToNs.containsKey(prefix)) {
            throw new NamespaceException("unknown prefix: " + prefix);
        }
        throw new NamespaceException("unregistering namespaces is not supported.");
    }

    public String[] getPrefixes() throws RepositoryException {
        return this.prefixToNs.keySet().toArray(new String[this.prefixToNs.size()]);
    }

    public String[] getURIs() throws RepositoryException {
        return this.nsToPrefix.keySet().toArray(new String[this.nsToPrefix.size()]);
    }

    public String getURI(String prefix) throws NamespaceException, RepositoryException {
        if (!this.prefixToNs.containsKey(prefix)) {
            throw new NamespaceException("Prefix " + prefix + " is not a registered namespace prefix in this system");
        }
        return this.prefixToNs.get(prefix);
    }

    public String getPrefix(String uri) throws NamespaceException, RepositoryException {
        if (!this.nsToPrefix.containsKey(uri)) {
            throw new NamespaceException("URI " + uri + " is not a registered namespace URI in this system");
        }
        return this.nsToPrefix.get(uri);
    }

    static {
        reservedPrefixes.add("xml");
        reservedPrefixes.add("xmlns");
        reservedPrefixes.add("rep");
        reservedPrefixes.add("jcr");
        reservedPrefixes.add("nt");
        reservedPrefixes.add("mix");
        reservedPrefixes.add("sv");
        reservedURIs.add("http://www.w3.org/XML/1998/namespace");
        reservedURIs.add("http://www.w3.org/2000/xmlns/");
        reservedURIs.add("internal");
        reservedURIs.add("http://www.jcp.org/jcr/1.0");
        reservedURIs.add("http://www.jcp.org/jcr/nt/1.0");
        reservedURIs.add("http://www.jcp.org/jcr/mix/1.0");
        reservedURIs.add("http://www.jcp.org/jcr/sv/1.0");
    }
}

