/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.impl.jackrabbit;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.JahiaRepositoryCopier;
import org.apache.jackrabbit.core.JahiaRepositoryImpl;
import org.apache.jackrabbit.core.RepositoryCopier;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.impl.jackrabbit.JahiaRepositoryConfig;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.DatabaseUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryMigrator {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryMigrator.class);
    private File configFile;
    private boolean keepBackup;
    private boolean performMigrationToDataStoreIfNeeded;
    private File repoHome;
    private File scriptsDir;
    private SettingsBean settingsBean;
    private File targetConfigFile;

    private static Document readConfig(File cfgFile) throws JDOMException, IOException {
        SAXBuilder saxBuilder = new SAXBuilder(false);
        saxBuilder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return saxBuilder.build(cfgFile);
    }

    private static void removeCopyPrefix(File sourceConfigFile, File targetConfigFile) throws JDOMException, IOException {
        Document doc = RepositoryMigrator.readConfig(sourceConfigFile);
        Element repo = doc.getRootElement();
        for (Element param : XPath.selectNodes((Object)repo, (String)"//param[@name=\"schemaObjectPrefix\"]")) {
            String prefix = param.getAttributeValue("value");
            if (!prefix.startsWith("COPY_")) continue;
            param.setAttribute("value", StringUtils.substringAfter((String)prefix, (String)"COPY_"));
        }
        RepositoryMigrator.writeToFile(doc, targetConfigFile);
        logger.info("Removed 'COPY_' prefix in file {} and stored result in {}", (Object)sourceConfigFile, (Object)targetConfigFile);
    }

    private static void removeElements(Element root, String xpath) throws JDOMException {
        for (Element param : XPath.selectNodes((Object)root, (String)xpath)) {
            param.getParent().removeContent((Content)param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(Document doc, File file) throws IOException {
        Format customFormat = Format.getPrettyFormat();
        customFormat.setLineSeparator(System.getProperty("line.separator"));
        XMLOutputter xmlOutputter = new XMLOutputter(customFormat);
        FileWriter out = null;
        try {
            out = new FileWriter(file);
            xmlOutputter.output(doc, (Writer)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
    }

    RepositoryMigrator(File configFile, File repoHome, File targetConfigFile, boolean performMigrationToDataStoreIfNeeded) {
        this.configFile = configFile;
        this.repoHome = repoHome;
        this.targetConfigFile = targetConfigFile;
        this.performMigrationToDataStoreIfNeeded = performMigrationToDataStoreIfNeeded;
    }

    private File createTempConfigFile() throws JDOMException, IOException {
        Document doc = RepositoryMigrator.readConfig(this.targetConfigFile != null ? this.targetConfigFile : this.configFile);
        Element repo = doc.getRootElement();
        Namespace ns = repo.getNamespace();
        for (Element param : XPath.selectNodes((Object)repo, (String)"//param[@name=\"schemaObjectPrefix\"]")) {
            param.setAttribute("value", "COPY_" + param.getAttributeValue("value"));
        }
        if (this.targetConfigFile == null) {
            Element searchIndex;
            Element param = (Element)XPath.selectSingleNode((Object)repo, (String)"//param[@name=\"externalBLOBs\"]");
            boolean useDatabaseDataStore = param != null && Boolean.valueOf(param.getAttributeValue("value")) == false;
            RepositoryMigrator.removeElements(repo, "//param[@name=\"externalBLOBs\"]");
            RepositoryMigrator.removeElements(repo, "/Repository/SearchIndex/param[@name=\"supportHighlighting\"]");
            if (XPath.selectSingleNode((Object)repo, (String)"/Repository/SearchIndex/param[@name=\"indexingConfiguration\"]") == null && (searchIndex = (Element)XPath.selectSingleNode((Object)repo, (String)"/Repository/SearchIndex")) != null) {
                searchIndex.addContent((Content)new Element("param", ns).setAttribute("name", "indexingConfiguration").setAttribute("value", "${rep.home}/indexing_configuration_version.xml"));
            }
            if (XPath.selectSingleNode((Object)repo, (String)"/Repository/DataStore") == null) {
                Element store = new Element("DataStore", ns);
                if (useDatabaseDataStore) {
                    store.setAttribute("class", "org.apache.jackrabbit.core.data.db.DbDataStore");
                    store.addContent((Content)new Element("param").setAttribute("name", "dataSourceName").setAttribute("value", "jahiaDS"));
                    store.addContent((Content)new Element("param").setAttribute("name", "schemaObjectPrefix").setAttribute("value", "COPY_JR_"));
                    store.addContent((Content)new Element("param").setAttribute("name", "schemaCheckEnabled").setAttribute("value", "false"));
                    store.addContent((Content)new Element("param").setAttribute("name", "copyWhenReading").setAttribute("value", "true"));
                    store.addContent((Content)new Element("param").setAttribute("name", "minRecordLength").setAttribute("value", "1024"));
                } else {
                    store.setAttribute("class", "org.apache.jackrabbit.core.data.FileDataStore");
                    store.addContent((Content)new Element("param").setAttribute("name", "minRecordLength").setAttribute("value", "1024"));
                    store.addContent((Content)new Element("param").setAttribute("name", "path").setAttribute("value", "${rep.home}/datastore"));
                }
                repo.addContent((Content)store);
            }
        }
        File tempConfigFile = new File(this.configFile.getParentFile(), "repository-migration-temp.xml");
        RepositoryMigrator.writeToFile(doc, tempConfigFile);
        logger.info("Created temporary repository configuration for migration at {}", (Object)tempConfigFile);
        return tempConfigFile;
    }

    private File createTempRepoHome() throws IOException {
        File repoHomeCopy = new File(this.repoHome.getParentFile(), "repository-migration");
        repoHomeCopy.mkdir();
        File toCopy = new File(this.repoHome, "indexing_configuration.xml");
        if (toCopy.exists()) {
            FileUtils.copyFileToDirectory((File)toCopy, (File)repoHomeCopy);
        }
        if ((toCopy = new File(this.repoHome, "indexing_configuration_version.xml")).exists()) {
            FileUtils.copyFileToDirectory((File)toCopy, (File)repoHomeCopy);
        }
        logger.info("Using folder {} for migrated repository", (Object)repoHomeCopy);
        return repoHomeCopy;
    }

    private void dbExecute(String fileName, String description) throws IOException, SQLException {
        DatabaseUtils.executeScript(new FileReader(new File(this.scriptsDir, fileName)));
        logger.info(description);
    }

    private void dbInitSettings() throws IOException, JDOMException {
        this.settingsBean = SettingsBean.getInstance();
        this.scriptsDir = new File(this.settingsBean.getJahiaDatabaseScriptsPath(), "sql/migration/" + this.getDbType());
        logger.info("Migration SQL scripts will be looked up in folder {}", (Object)this.scriptsDir);
    }

    private String getDbType() throws JDOMException, IOException {
        Document doc = RepositoryMigrator.readConfig(this.configFile);
        Element repo = doc.getRootElement();
        String type = ((Element)XPath.selectSingleNode((Object)repo, (String)"/Repository/DataSources/DataSource/param[@name=\"databaseType\"]")).getAttributeValue("value");
        return StringUtils.isEmpty((String)type) || "default".equals(type) ? "derby" : type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void migrate() {
        block14: {
            try {
                JahiaRepositoryConfig sourceCfg;
                JahiaRepositoryConfig jahiaRepositoryConfig = sourceCfg = this.performMigrationToDataStoreIfNeeded ? JahiaRepositoryConfig.create(this.configFile.toString(), this.repoHome.toString()) : null;
                if (this.targetConfigFile == null && (!this.performMigrationToDataStoreIfNeeded || sourceCfg.getDataStore() != null)) break block14;
                long timer = System.currentTimeMillis();
                if (this.targetConfigFile != null) {
                    logger.info("Will perform repository migration using target configuration file {}", (Object)this.targetConfigFile);
                } else {
                    logger.info("Will perform repository migration from BLOB store to DataStore");
                }
                boolean clusterActivated = Boolean.getBoolean("cluster.activated");
                if (clusterActivated) {
                    System.setProperty("cluster.activated", "false");
                    sourceCfg = null;
                }
                this.keepBackup = Boolean.getBoolean("jahia.jackrabbit.backupRepositoryByMigration");
                try {
                    this.dbInitSettings();
                    this.dbExecute("jackrabbit-migration-1-create-temp-tables.sql", "Temporary DB tables created");
                    File tempRepoHome = this.createTempRepoHome();
                    File tempConfigFile = this.createTempConfigFile();
                    if (sourceCfg == null) {
                        sourceCfg = JahiaRepositoryConfig.create(this.configFile.toString(), this.repoHome.toString());
                    }
                    JahiaRepositoryConfig targetCfg = JahiaRepositoryConfig.create(tempConfigFile.toString(), tempRepoHome.toString());
                    this.performMigration(sourceCfg, targetCfg);
                    JCRContentUtils.deleteJackrabbitIndexes(this.repoHome);
                    JCRContentUtils.deleteJackrabbitIndexes(tempRepoHome);
                    File target = new File(tempConfigFile.getParentFile(), "repository-migration-target.xml");
                    RepositoryMigrator.removeCopyPrefix(tempConfigFile, target);
                    logger.info("Created target repository configuration after migration at {}", (Object)target);
                    if (this.keepBackup) {
                        File configBackup = new File(this.configFile.getParentFile(), "repository-original.xml");
                        FileUtils.copyFile((File)this.configFile, (File)configBackup);
                        logger.info("Backup original configuration to {}", (Object)configBackup);
                    }
                    FileUtils.copyFile((File)target, (File)this.configFile);
                    logger.info("Replaced original repository.xml with the target one");
                    if (!this.keepBackup) {
                        FileUtils.deleteQuietly((File)tempConfigFile);
                        FileUtils.deleteQuietly((File)target);
                    }
                    File workspaceConfig = new File(tempRepoHome, "workspaces/default/workspace.xml");
                    RepositoryMigrator.removeCopyPrefix(workspaceConfig, workspaceConfig);
                    workspaceConfig = new File(tempRepoHome, "workspaces/live/workspace.xml");
                    RepositoryMigrator.removeCopyPrefix(workspaceConfig, workspaceConfig);
                    this.dbExecute("jackrabbit-migration-2-drop-original-tables.sql", "Original DB tables dropped");
                    this.dbExecute("jackrabbit-migration-3-rename-temp-tables.sql", "Temporary DB tables renamed");
                    this.swapRepositoryHome(tempRepoHome);
                    logger.info("Complete repository migration took {} ms", (Object)(System.currentTimeMillis() - timer));
                }
                catch (Exception e) {
                    logger.warn("Unable to perform migration from BLOB store to DataStore. Cause: " + e.getMessage(), (Throwable)e);
                }
                finally {
                    if (clusterActivated) {
                        System.setProperty("cluster.activated", "true");
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Unable to check the source repository configuration. Skip DataStore migration check.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performMigration(JahiaRepositoryConfig sourceCfg, JahiaRepositoryConfig targetCfg) throws RepositoryException {
        logger.info("Start migrating repository...");
        long globalTimer = System.currentTimeMillis();
        RepositoryImpl source = JahiaRepositoryImpl.create(sourceCfg);
        RepositoryImpl target = JahiaRepositoryImpl.create(targetCfg);
        int batchSize = Integer.getInteger("jahia.jackrabbit.persistenceCopierBatchSize", 500);
        try {
            if (batchSize <= 1) {
                new RepositoryCopier(source, target).copy();
            } else {
                new JahiaRepositoryCopier(source, target, batchSize).copy();
            }
        }
        finally {
            target.shutdown();
            source.shutdown();
        }
        logger.info("Repository data migrated in {} ms", (Object)(System.currentTimeMillis() - globalTimer));
    }

    private void swapRepositoryHome(File repoHomeCopy) throws IOException {
        String repoHomePath = this.repoHome.getAbsolutePath();
        try {
            if (this.keepBackup) {
                File backupDir = new File(this.repoHome.getParentFile(), "repository-original");
                FileUtils.moveDirectory((File)this.repoHome, (File)backupDir);
                logger.info("Backup of the source repository folder at {}", (Object)backupDir);
            } else {
                try {
                    FileUtils.deleteDirectory((File)this.repoHome);
                }
                catch (IOException e) {
                    logger.warn("Issue while deleting the " + repoHomePath + " directory, we will try to empty it");
                    FileUtils.cleanDirectory((File)this.repoHome);
                }
            }
            FileUtils.moveDirectory((File)repoHomeCopy, (File)this.repoHome);
        }
        catch (IOException e) {
            logger.error("The migration was successful, except the last step: we are unable to delete directory {}. Jahia server will be stopped now.", (Object)repoHomePath);
            String repoHomeCopyPath = repoHomeCopy.getAbsolutePath();
            logger.error("Please delete the directory {} manually (perhaps an OS reboot is required to free the file locks) and copy the content of {} to {}", (Object[])new String[]{repoHomePath, repoHomeCopyPath, repoHomePath});
            logger.error("Also delete the following folders if they are present:\n{}\\index\n{}\\workspaces\\default\\index\n{}\\workspaces\\live\\index", (Object[])new String[]{repoHomePath, repoHomePath, repoHomePath});
            logger.error("Start Jahia server afterwards.", (Object[])new String[]{repoHomePath, repoHomeCopyPath, repoHomePath});
            System.exit(1);
        }
        logger.info("Replaced repository with the migrated copy");
    }
}

