/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.renderer;

import java.util.LinkedList;
import java.util.Locale;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.renderer.AbstractChoiceListRenderer;
import org.jahia.services.render.RenderContext;

public class NodeReferenceChoiceListRenderer
extends AbstractChoiceListRenderer {
    @Override
    public String getStringRendering(RenderContext context, JCRPropertyWrapper propertyWrapper) throws RepositoryException {
        JCRValueWrapper[] jCRValueWrapperArray;
        if (propertyWrapper.isMultiple()) {
            jCRValueWrapperArray = propertyWrapper.getValues();
        } else {
            Value[] valueArray = new Value[1];
            jCRValueWrapperArray = valueArray;
            valueArray[0] = propertyWrapper.getValue();
        }
        JCRValueWrapper[] values = jCRValueWrapperArray;
        LinkedList<String> displayValues = new LinkedList<String>();
        if (values != null && values.length > 0) {
            for (JCRValueWrapper value : values) {
                JCRNodeWrapper node;
                if (value == null || (node = value.getNode()) == null) continue;
                String title = null;
                if (node.hasProperty("jcr:title")) {
                    title = node.getProperty("jcr:title").getString();
                }
                displayValues.add(StringUtils.isNotEmpty(title) ? title : node.getName());
            }
        }
        return StringUtils.join(displayValues, (String)", ");
    }

    @Override
    public String getStringRendering(Locale locale, ExtendedPropertyDefinition propDef, Object propertyValue) throws RepositoryException {
        String displayValue = "";
        JCRNodeWrapper node = (JCRNodeWrapper)propertyValue;
        if (node != null) {
            String title = null;
            if (node.hasProperty("jcr:title")) {
                title = node.getProperty("jcr:title").getString();
            }
            displayValue = StringUtils.isNotEmpty(title) ? title : node.getName();
        }
        return displayValue;
    }
}

