/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import javax.jcr.RepositoryException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.rules.AbstractNodeFact;

public class PublishedNodeFact
extends AbstractNodeFact {
    boolean unpublished;
    String language;

    public PublishedNodeFact(JCRNodeWrapper node, String language, boolean unpublished) throws RepositoryException {
        super(node);
        this.language = language;
        this.unpublished = unpublished;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public String toString() {
        return (this.isUnpublished() ? "un" : "") + "published " + this.node.getPath() + (this.isTranslation() ? " in `" + this.getLanguage() + "`" : "");
    }

    public boolean isTranslation() {
        return this.language != null;
    }

    public boolean isUnpublished() {
        return this.unpublished;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        PublishedNodeFact that = (PublishedNodeFact)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.getLanguage(), (Object)that.getLanguage()).append(this.isUnpublished(), that.isUnpublished()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.node).append((Object)this.workspace).append((Object)this.operationType).append((Object)this.language).append(this.unpublished).toHashCode();
    }
}

